/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.jvm.DefaultJvmElementVisitor;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmElementVisitor;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.lang.jvm.inspection.JvmLocalInspection;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitJvmInspection;
import org.jetbrains.idea.devkit.inspections.ErrorMessageProvider;
import org.jetbrains.idea.devkit.inspections.JvmProviderKt;
import org.jetbrains.idea.devkit.inspections.LightServiceMustBeFinalErrorMessageProviders;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0014\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/devkit/inspections/LightServiceMustBeFinalInspection;", "Lorg/jetbrains/idea/devkit/inspections/DevKitJvmInspection;", "()V", "buildVisitor", "Lcom/intellij/lang/jvm/JvmElementVisitor;", "", "project", "Lcom/intellij/openapi/project/Project;", "sink", "Lcom/intellij/lang/jvm/inspection/JvmLocalInspection$HighlightSink;", "isOnTheFly", "intellij.devkit.core"})
public final class LightServiceMustBeFinalInspection
extends DevKitJvmInspection {
    @NotNull
    protected JvmElementVisitor<Boolean> buildVisitor(@NotNull Project project, @NotNull JvmLocalInspection.HighlightSink sink, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        return (JvmElementVisitor)new DefaultJvmElementVisitor<Boolean>(sink){
            final /* synthetic */ JvmLocalInspection.HighlightSink $sink;
            {
                this.$sink = $sink;
            }

            @NotNull
            public Boolean visitClass(@NotNull JvmClass clazz) {
                Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
                PsiElement sourceElement = clazz.getSourceElement();
                if (!(sourceElement instanceof PsiClass)) {
                    return true;
                }
                if (((PsiClass)sourceElement).isAnnotationType() || ((PsiClass)sourceElement).isEnum() || ((PsiClass)sourceElement).hasModifier(JvmModifier.FINAL)) {
                    return true;
                }
                PsiFile psiFile = ((PsiClass)sourceElement).getContainingFile();
                if (psiFile == null) {
                    return true;
                }
                PsiFile file = psiFile;
                PsiAnnotation psiAnnotation = ((PsiClass)sourceElement).getAnnotation(Service.class.getCanonicalName());
                if (psiAnnotation == null) {
                    return true;
                }
                PsiAnnotation serviceAnnotation = psiAnnotation;
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = serviceAnnotation.getNameReferenceElement();
                if (psiJavaCodeReferenceElement == null) {
                    return true;
                }
                PsiJavaCodeReferenceElement elementToReport = psiJavaCodeReferenceElement;
                if (((PsiClass)sourceElement).isInterface() || ((PsiClass)sourceElement).hasModifier(JvmModifier.ABSTRACT)) {
                    JvmModifiersOwner jvmModifiersOwner = (JvmModifiersOwner)sourceElement;
                    String string = Service.class.getCanonicalName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Service::class.java.canonicalName");
                    List actions = JvmElementActionFactories.createRemoveAnnotationActions((JvmModifiersOwner)jvmModifiersOwner, (AnnotationRequest)AnnotationRequestsKt.annotationRequest((String)string, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]));
                    Collection $this$toTypedArray$iv = actions;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])thisCollection$iv.toArray(new IntentionAction[0]), (PsiFile)file);
                    Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"wrapToQuickFixes(actions.toTypedArray(), file)");
                    LocalQuickFix[] fixes = localQuickFixArray;
                    String message = DevKitBundle.message("inspection.light.service.must.be.concrete.class.message", new Object[0]);
                    JvmLocalInspection.HighlightSink highlightSink = this.$sink;
                    Intrinsics.checkNotNull((Object)highlightSink, (String)"null cannot be cast to non-null type com.intellij.lang.jvm.inspection.JvmLocalInspection.HighlightSinkImpl");
                    ProblemsHolder problemsHolder = ((JvmLocalInspection.HighlightSinkImpl)highlightSink).getHolder();
                    Intrinsics.checkNotNullExpressionValue((Object)problemsHolder, (String)"sink as HighlightSinkImpl).holder");
                    ProblemsHolder holder = problemsHolder;
                    holder.registerProblem((PsiElement)elementToReport, message, ProblemHighlightType.GENERIC_ERROR, Arrays.copyOf(fixes, fixes.length));
                } else {
                    LanguageExtension languageExtension = LightServiceMustBeFinalErrorMessageProviders.INSTANCE;
                    Language language = ((PsiClass)sourceElement).getLanguage();
                    Intrinsics.checkNotNullExpressionValue((Object)language, (String)"sourceElement.language");
                    ErrorMessageProvider errorMessageProvider = (ErrorMessageProvider)JvmProviderKt.getProvider(languageExtension, language);
                    if (errorMessageProvider == null) {
                        return true;
                    }
                    ErrorMessageProvider errorMessageProvider2 = errorMessageProvider;
                    String message = errorMessageProvider2.provideErrorMessage();
                    List actions = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)((JvmModifiersOwner)sourceElement), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.FINAL, (boolean)true));
                    Collection $this$toTypedArray$iv = actions;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    LocalQuickFix[] localQuickFixArray = IntentionWrapper.wrapToQuickFixes((IntentionAction[])thisCollection$iv.toArray(new IntentionAction[0]), (PsiFile)file);
                    Intrinsics.checkNotNullExpressionValue((Object)localQuickFixArray, (String)"wrapToQuickFixes(actions.toTypedArray(), file)");
                    LocalQuickFix[] fixes = localQuickFixArray;
                    this.$sink.highlight(message, ProblemHighlightType.GENERIC_ERROR, Arrays.copyOf(fixes, fixes.length));
                }
                return true;
            }
        };
    }
}

