/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.siyeh.ig.psiutils.CommentTracker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.DevKitBundle;

@IntellijInternalApi
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u000f\u001a\u00028\u00002\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0004\u00a2\u0006\u0002\u0010\u0012J\u001d\u0010\u0013\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\u0011H$\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\b\u0010 \u001a\u00020\u0016H\u0016J\u001d\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\"J)\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0011H\u0096\u0002J\b\u0010'\u001a\u00020(H\u0016\u00a8\u0006)"}, d2={"Lorg/jetbrains/idea/devkit/inspections/quickfix/WrapInSupplierQuickFix;", "T", "Lcom/intellij/psi/PsiNamedElement;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "elementToWrap", "(Lcom/intellij/psi/PsiNamedElement;)V", "changeElementInitializerToSupplierCall", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "supplierElement", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiNamedElement;)V", "copyComments", "sourceElement", "targetElement", "excludeElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiElement;)V", "createSupplierElement", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiNamedElement;)Lcom/intellij/psi/PsiNamedElement;", "defaultSupplierElementName", "", "(Lcom/intellij/psi/PsiNamedElement;)Ljava/lang/String;", "findElement", "startElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiNamedElement;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "problemDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getText", "inlineElement", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiNamedElement;)V", "invoke", "file", "Lcom/intellij/psi/PsiFile;", "endElement", "startInWriteAction", "", "intellij.devkit.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAppServiceAsStaticFinalFieldFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppServiceAsStaticFinalFieldFixProvider.kt\norg/jetbrains/idea/devkit/inspections/quickfix/WrapInSupplierQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public abstract class WrapInSupplierQuickFix<T extends PsiNamedElement>
extends LocalQuickFixOnPsiElement {
    public WrapInSupplierQuickFix(@NotNull T elementToWrap) {
        Intrinsics.checkNotNullParameter(elementToWrap, (String)"elementToWrap");
        super((PsiElement)elementToWrap);
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspections.wrap.application.service.in.supplier.quick.fix.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspections.wra\u2026plier.quick.fix.message\")");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected abstract T findElement(@NotNull PsiElement var1);

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)problemDescriptor, (String)"problemDescriptor");
        PsiElement psiElement = problemDescriptor.getStartElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"problemDescriptor.startElement");
        T element = this.findElement(psiElement);
        this.createSupplierElement(project, element);
        element.delete();
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"DIFF");
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        CommandProcessor.getInstance().runUndoTransparentAction(() -> WrapInSupplierQuickFix.invoke$lambda$1(this, startElement, file, project));
    }

    @NotNull
    protected abstract T createSupplierElement(@NotNull Project var1, @NotNull T var2);

    @NotNull
    protected final String defaultSupplierElementName(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element.getName() + "Supplier";
    }

    protected final void copyComments(@NotNull T sourceElement, @NotNull T targetElement, @Nullable PsiElement excludeElement) {
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        Intrinsics.checkNotNullParameter(targetElement, (String)"targetElement");
        CommentTracker commentTracker = new CommentTracker();
        PsiElement psiElement = excludeElement;
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            commentTracker.markUnchanged(it);
        }
        commentTracker.grabComments((PsiElement)sourceElement);
        commentTracker.insertCommentsBefore((PsiElement)targetElement);
    }

    public static /* synthetic */ void copyComments$default(WrapInSupplierQuickFix wrapInSupplierQuickFix, PsiNamedElement psiNamedElement, PsiNamedElement psiNamedElement2, PsiElement psiElement, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyComments");
        }
        if ((n & 4) != 0) {
            psiElement = null;
        }
        wrapInSupplierQuickFix.copyComments(psiNamedElement, psiNamedElement2, psiElement);
    }

    protected abstract void changeElementInitializerToSupplierCall(@NotNull Project var1, @NotNull T var2, @NotNull T var3);

    protected abstract void inlineElement(@NotNull Project var1, @NotNull T var2);

    private static final void invoke$lambda$1$lambda$0(WrapInSupplierQuickFix this$0, Project $project, PsiNamedElement $element) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$element, (String)"$element");
        PsiNamedElement supplierField = this$0.createSupplierElement($project, $element);
        this$0.changeElementInitializerToSupplierCall($project, $element, supplierField);
    }

    private static final void invoke$lambda$1(WrapInSupplierQuickFix this$0, PsiElement $startElement, PsiFile $file, Project $project) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$startElement, (String)"$startElement");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Object element = this$0.findElement($startElement);
        if (!FileModificationService.getInstance().prepareFileForWrite($file)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> WrapInSupplierQuickFix.invoke$lambda$1$lambda$0(this$0, $project, element));
        this$0.inlineElement($project, element);
    }
}

