/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.kotlin.DevKitKotlinBundle;
import org.jetbrains.idea.devkit.kotlin.inspections.CompanionObjectInExtensionInspectionKt;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggestionProvider;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.fe10.codeInsight.newDeclaration.Fe10KotlinNewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringEventListener;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveDeclarationDelegate;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSource;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveSourceKt;
import org.jetbrains.kotlin.idea.refactoring.move.KotlinMoveTarget;
import org.jetbrains.kotlin.idea.refactoring.move.MoveDeclarationsDescriptor;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsProcessor;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J)\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0096\u0002J*\u0010\u001c\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J \u0010 \u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00130\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R#\u0010\u0005\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u0006*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/CreateObjectAndMoveProhibitedDeclarationsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "companionObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;)V", "namedDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lkotlin/internal/NoInfer;", "getNamedDeclarations", "(Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;)Ljava/util/List;", "createObject", "project", "Lcom/intellij/openapi/project/Project;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getText", "invoke", "", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "invokeRenameFix", "editor", "Lcom/intellij/openapi/editor/Editor;", "createdObject", "moveProhibitedDeclarations", "startInWriteAction", "", "suggestNamesForObjectInstance", "intellij.kotlin.devkit"})
@SourceDebugExtension(value={"SMAP\nCompanionObjectInExtensionInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompanionObjectInExtensionInspection.kt\norg/jetbrains/idea/devkit/kotlin/inspections/CreateObjectAndMoveProhibitedDeclarationsQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,206:1\n819#2:207\n847#2,2:208\n800#2,11:210\n*S KotlinDebug\n*F\n+ 1 CompanionObjectInExtensionInspection.kt\norg/jetbrains/idea/devkit/kotlin/inspections/CreateObjectAndMoveProhibitedDeclarationsQuickFix\n*L\n160#1:207\n160#1:208,2\n203#1:210,11\n*E\n"})
final class CreateObjectAndMoveProhibitedDeclarationsQuickFix
extends LocalQuickFixOnPsiElement {
    public CreateObjectAndMoveProhibitedDeclarationsQuickFix(@NotNull KtObjectDeclaration companionObject) {
        Intrinsics.checkNotNullParameter((Object)companionObject, (String)"companionObject");
        super((PsiElement)companionObject);
    }

    @NotNull
    public String getFamilyName() {
        return DevKitKotlinBundle.INSTANCE.message("inspections.create.object.and.move.prohibited.declarations.fix.text", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        CommandProcessor.getInstance().runUndoTransparentAction(() -> CreateObjectAndMoveProhibitedDeclarationsQuickFix.invoke$lambda$1(startElement, this, project, file));
    }

    private final KtObjectDeclaration createObject(Project project, KtObjectDeclaration companionObject) {
        List<String> nameSuggestions = this.suggestNamesForObjectInstance(companionObject);
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        if (!FileModificationService.getInstance().prepareFileForWrite(companionObject.getContainingFile())) {
            return null;
        }
        return (KtObjectDeclaration)ApplicationManager.getApplication().runWriteAction(() -> CreateObjectAndMoveProhibitedDeclarationsQuickFix.createObject$lambda$2(psiFactory, nameSuggestions, companionObject));
    }

    private final List<String> suggestNamesForObjectInstance(KtObjectDeclaration companionObject) {
        KtClass ktClass = KtPsiUtilKt.containingClass((KtElement)((KtElement)companionObject));
        Intrinsics.checkNotNull((Object)ktClass);
        KtClass containingClass = ktClass;
        return Fe10KotlinNameSuggester.INSTANCE.getCamelNames("Util", (Function1)new Fe10KotlinNewDeclarationNameValidator((PsiElement)containingClass, null, KotlinNameSuggestionProvider.ValidatorTarget.CLASS, null, 8, null), false);
    }

    /*
     * WARNING - void declaration
     */
    private final void moveProhibitedDeclarations(Project project, KtObjectDeclaration companionObject, KtObjectDeclaration createdObject) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.getNamedDeclarations(companionObject);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            if (CompanionObjectInExtensionInspectionKt.access$isAllowedInsideACompanionObject((KtDeclaration)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List declarationsToMove = (List)destination$iv$iv;
        MoveDeclarationsDescriptor moveDescriptor = new MoveDeclarationsDescriptor(project, (KotlinMoveSource)KotlinMoveSourceKt.KotlinMoveSource((Collection)declarationsToMove), (KotlinMoveTarget)new KotlinMoveTarget.ExistingElement((KtElement)createdObject), (KotlinMoveDeclarationDelegate)new KotlinMoveDeclarationDelegate.NestedClass(null, null, 3, null), false, false, false, null, false, null, false, false, 4080, null);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(KotlinRefactoringEventListener.Companion.getEVENT_TOPIC(), (Object)new KotlinRefactoringEventListener(createdObject, connection){
            final /* synthetic */ KtObjectDeclaration $createdObject;
            final /* synthetic */ MessageBusConnection $connection;
            {
                this.$createdObject = $createdObject;
                this.$connection = $connection;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRefactoringExit(@NotNull String refactoringId) {
                Intrinsics.checkNotNullParameter((Object)refactoringId, (String)"refactoringId");
                if (Intrinsics.areEqual((Object)refactoringId, (Object)"move.kotlin.declarations")) {
                    try {
                        if (this.$createdObject.getDeclarations().isEmpty()) {
                            this.$createdObject.delete();
                        }
                    }
                    finally {
                        this.$connection.disconnect();
                    }
                }
            }
        });
        new MoveKotlinDeclarationsProcessor(moveDescriptor, null, false, 6, null).run();
    }

    private final void invokeRenameFix(Project project, PsiFile file, Editor editor, KtObjectDeclaration createdObject) {
        if (editor == null) {
            return;
        }
        PsiElement psiElement = createdObject.getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        editor.getCaretModel().moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)nameIdentifier));
        IntentionAction renameFix = QuickFixFactory.getInstance().createRenameFix((PsiElement)createdObject);
        if (renameFix == null || !renameFix.isAvailable(project, editor, file)) {
            return;
        }
        renameFix.invoke(project, editor, file);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedDeclaration> getNamedDeclarations(KtObjectDeclaration $this$namedDeclarations) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$namedDeclarations.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final void invoke$lambda$1(PsiElement $startElement, CreateObjectAndMoveProhibitedDeclarationsQuickFix this$0, Project $project, PsiFile $file) {
        block0: {
            KtObjectDeclaration createdObject;
            Intrinsics.checkNotNullParameter((Object)$startElement, (String)"$startElement");
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
            KtObjectDeclaration companionObject = (KtObjectDeclaration)$startElement;
            KtObjectDeclaration ktObjectDeclaration = createdObject = this$0.createObject($project, companionObject);
            if (ktObjectDeclaration == null) break block0;
            KtObjectDeclaration it = ktObjectDeclaration;
            boolean bl = false;
            this$0.moveProhibitedDeclarations($project, companionObject, createdObject);
            this$0.invokeRenameFix($project, $file, PsiEditorUtil.findEditor((PsiElement)((PsiElement)createdObject)), createdObject);
        }
    }

    private static final KtObjectDeclaration createObject$lambda$2(KtPsiFactory $psiFactory, List $nameSuggestions, KtObjectDeclaration $companionObject) {
        Intrinsics.checkNotNullParameter((Object)$psiFactory, (String)"$psiFactory");
        Intrinsics.checkNotNullParameter((Object)$nameSuggestions, (String)"$nameSuggestions");
        Intrinsics.checkNotNullParameter((Object)$companionObject, (String)"$companionObject");
        KtObjectDeclaration createdObject = $psiFactory.createObject("object " + CollectionsKt.first((List)$nameSuggestions) + " {\n}");
        PsiElement psiElement = $companionObject.getParent().addBefore((PsiElement)createdObject, (PsiElement)$companionObject);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtObjectDeclaration");
        return (KtObjectDeclaration)psiElement;
    }
}

