/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.kotlin.inspections;

import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.idea.codeInsight.intentions.shared.AddBracesIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.RedundantSemicolonUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J)\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0096\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u0018*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/idea/devkit/kotlin/inspections/KtInsertCancellationCheckFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "cancellationCheckCallFqn", "", "loopKeyword", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "deleteRedundantSemicolon", "", "loop", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "getFamilyName", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "startElement", "endElement", "isAvailable", "", "addExpressionToFirstLine", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "expression", "getOrCreateBodyBlock", "intellij.kotlin.devkit"})
@SourceDebugExtension(value={"SMAP\nKtCancellationCheckInLoopsFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtCancellationCheckInLoopsFixProvider.kt\norg/jetbrains/idea/devkit/kotlin/inspections/KtInsertCancellationCheckFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,92:1\n57#2,2:93\n57#2,2:95\n*S KotlinDebug\n*F\n+ 1 KtCancellationCheckInLoopsFixProvider.kt\norg/jetbrains/idea/devkit/kotlin/inspections/KtInsertCancellationCheckFix\n*L\n43#1:93,2\n47#1:95,2\n*E\n"})
public final class KtInsertCancellationCheckFix
extends LocalQuickFixOnPsiElement {
    @NotNull
    private final String cancellationCheckCallFqn;

    public KtInsertCancellationCheckFix(@NotNull String cancellationCheckCallFqn, @NotNull PsiElement loopKeyword) {
        Intrinsics.checkNotNullParameter((Object)cancellationCheckCallFqn, (String)"cancellationCheckCallFqn");
        Intrinsics.checkNotNullParameter((Object)loopKeyword, (String)"loopKeyword");
        super(loopKeyword);
        this.cancellationCheckCallFqn = cancellationCheckCallFqn;
    }

    @NotNull
    public String getFamilyName() {
        String string = DevKitBundle.message("inspection.insert.cancellation.check.fix.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"inspection.inse\u2026ation.check.fix.message\")");
        return string;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        PsiElement $this$parentOfType_u24default$iv = startElement;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtLoopExpression.class, (boolean)true) != null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            PsiElement $this$parentOfType_u24default$iv = startElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            KtLoopExpression ktLoopExpression = (KtLoopExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtLoopExpression.class, (boolean)true);
            if (ktLoopExpression == null) {
                return;
            }
            KtLoopExpression loopStatement = ktLoopExpression;
            KtPsiFactory factory = new KtPsiFactory(project, false, 2, null);
            KtExpression cancellationCheckExpression = factory.createExpression(this.cancellationCheckCallFqn + "()");
            KtBlockExpression bodyBlock = this.getOrCreateBodyBlock(loopStatement, project);
            KtBlockExpression ktBlockExpression = bodyBlock;
            if (ktBlockExpression == null || (ktBlockExpression = this.addExpressionToFirstLine(ktBlockExpression, cancellationCheckExpression)) == null) break block1;
            KtBlockExpression it = ktBlockExpression;
            boolean bl = false;
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)it);
        }
    }

    private final KtBlockExpression getOrCreateBodyBlock(KtLoopExpression $this$getOrCreateBodyBlock, Project project) {
        KtBlockExpression ktBlockExpression;
        KtExpression loopBody = $this$getOrCreateBodyBlock.getBody();
        if (loopBody instanceof KtBlockExpression) {
            ktBlockExpression = (KtBlockExpression)loopBody;
        } else if (loopBody != null) {
            AddBracesIntention.Companion.addBraces((KtElement)$this$getOrCreateBodyBlock, loopBody);
            KtExpression ktExpression = $this$getOrCreateBodyBlock.getBody();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            ktBlockExpression = (KtBlockExpression)ktExpression;
        } else {
            PsiElement psiElement = KtPsiUtil.findChildByType((PsiElement)((PsiElement)$this$getOrCreateBodyBlock), (IElementType)KtNodeTypes.BODY);
            if (psiElement == null) {
                return null;
            }
            PsiElement containerNode = psiElement;
            containerNode.add((PsiElement)new KtPsiFactory(project, false, 2, null).createEmptyBody());
            this.deleteRedundantSemicolon($this$getOrCreateBodyBlock);
            KtExpression ktExpression = $this$getOrCreateBodyBlock.getBody();
            Intrinsics.checkNotNull((Object)ktExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBlockExpression");
            ktBlockExpression = (KtBlockExpression)ktExpression;
        }
        return ktBlockExpression;
    }

    private final void deleteRedundantSemicolon(KtLoopExpression loop) {
        PsiElement nextSibling = loop.getNextSibling();
        if (Intrinsics.areEqual((Object)nextSibling.getNode().getElementType(), (Object)KtTokens.SEMICOLON)) {
            Intrinsics.checkNotNullExpressionValue((Object)nextSibling, (String)"nextSibling");
            if (RedundantSemicolonUtilsKt.isRedundantSemicolon((PsiElement)nextSibling)) {
                nextSibling.delete();
            }
        }
    }

    private final KtExpression addExpressionToFirstLine(KtBlockExpression $this$addExpressionToFirstLine, KtExpression expression) {
        CodeStyleManager.getInstance((Project)$this$addExpressionToFirstLine.getProject()).reformat((PsiElement)$this$addExpressionToFirstLine);
        PsiElement psiElement = $this$addExpressionToFirstLine.addAfter((PsiElement)expression, $this$addExpressionToFirstLine.getLBrace());
        return psiElement instanceof KtExpression ? (KtExpression)psiElement : null;
    }
}

