/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.references.IconsReferencesQueryExecutor;
import org.jetbrains.idea.devkit.util.PsiUtil;

public final class IconsXmlReferencesContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsXmlReferencesContributor.$$$reportNull$$$0(0);
        }
        IconsXmlReferencesContributor.registerForIconXmlAttribute(registrar);
    }

    private static void registerForIconXmlAttribute(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            IconsXmlReferencesContributor.$$$reportNull$$$0(1);
        }
        registrar.registerReferenceProvider((ElementPattern)XmlPatterns.xmlAttributeValue().withLocalName(new String[]{"icon"}), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(final @NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!PsiUtil.isPluginXmlPsiElement(element)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new IconsReferencesQueryExecutor.IconPsiReferenceBase(element){

                    public PsiElement resolve() {
                        String value = ((XmlAttributeValue)element).getValue();
                        if (value.startsWith("/")) {
                            FileReference lastRef = new FileReferenceSet(element).getLastReference();
                            return lastRef != null ? lastRef.resolve() : null;
                        }
                        return IconsReferencesQueryExecutor.resolveIconPath(value, element);
                    }

                    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                        PsiElement element2;
                        PsiElement resultForFile;
                        if (newElementName == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((resultForFile = this.handleFile(element2 = this.resolve(), lastRef -> lastRef.handleElementRename(newElementName))) != null) {
                            return resultForFile;
                        }
                        PsiElement resultForField = this.handleField(element2, newElementName);
                        if (resultForField != null) {
                            return resultForField;
                        }
                        return super.handleElementRename(newElementName);
                    }

                    public PsiElement bindToElement(@NotNull PsiElement element2) throws IncorrectOperationException {
                        PsiElement resultForFile;
                        if (element2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if ((resultForFile = this.handleFile(element2, lastRef -> lastRef.bindToElement(element2))) != null) {
                            return resultForFile;
                        }
                        PsiElement resultForField = this.handleField(element2, null);
                        if (resultForField != null) {
                            return resultForField;
                        }
                        return super.bindToElement(element2);
                    }

                    private PsiElement handleFile(PsiElement element2, Function<FileReference, PsiElement> callback) {
                        FileReference lastRef;
                        if (element2 instanceof PsiFile && (lastRef = new FileReferenceSet(element2).getLastReference()) != null) {
                            return callback.apply(lastRef);
                        }
                        return null;
                    }

                    @Nullable
                    private PsiElement handleField(PsiElement element2, @Nullable String newElementName) {
                        String classQualifiedName;
                        PsiClass containingClass;
                        if (element2 instanceof PsiField && (containingClass = ((PsiField)element2).getContainingClass()) != null && (classQualifiedName = containingClass.getQualifiedName()) != null) {
                            if (newElementName == null) {
                                newElementName = ((PsiField)element2).getName();
                            }
                            if (classQualifiedName.startsWith("com.intellij.icons.")) {
                                return this.replace(classQualifiedName, newElementName, "com.intellij.icons.");
                            }
                            if (classQualifiedName.startsWith("icons.")) {
                                return this.replace(classQualifiedName, newElementName, "icons.");
                            }
                            return ElementManipulators.handleContentChange((PsiElement)this.myElement, (String)(classQualifiedName + "." + newElementName));
                        }
                        return null;
                    }

                    private PsiElement replace(@NonNls String fqn, @NonNls String newName, @NonNls String pckg) {
                        XmlAttribute parent = (XmlAttribute)this.getElement().getParent();
                        parent.setValue(fqn.substring(pckg.length()) + "." + newName);
                        return parent.getValueElement();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "newElementName";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "element";
                                break;
                            }
                        }
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsXmlReferencesContributor$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "handleElementRename";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "bindToElement";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/IconsXmlReferencesContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsXmlReferencesContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "registrar";
        objectArray2[1] = "org/jetbrains/idea/devkit/references/IconsXmlReferencesContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerForIconXmlAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

