/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.execution.testDiscovery.TestDiscoveryProducer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;

public final class TestDataGuessByTestDiscoveryUtil {
    @NonNls
    public static final String COMMUNITY_PREFIX = "/community";

    @NotNull
    static List<TestDataFile> collectTestDataByExistingFiles(@NotNull PsiMethod method) {
        if (method == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(0);
        }
        if (!TestDataGuessByTestDiscoveryUtil.isEnabled()) {
            List<TestDataFile> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiClass testClass = (PsiClass)ReadAction.compute(() -> method.getContainingClass());
        if (testClass == null) {
            List<TestDataFile> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        String testClassQualifiedName = (String)ReadAction.compute(() -> testClass.getQualifiedName());
        if (testClassQualifiedName == null) {
            List<TestDataFile> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<Couple> testQName = Collections.singletonList(Couple.of((Object)testClassQualifiedName, (Object)((String)ReadAction.compute(() -> method.getName()))));
        Project project = (Project)ReadAction.compute(() -> method.getProject());
        AffectedPathConsumer consumer = new AffectedPathConsumer(project);
        TestDiscoveryProducer.consumeAffectedPaths((Project)project, testQName, (Consumer)consumer, (byte)0);
        List<TestDataFile> list = consumer.getTestData();
        if (list == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    static List<TestDataFile> collectTestDataByExistingFiles(@NotNull PsiClass parametrizedTestClass) {
        if (parametrizedTestClass == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(5);
        }
        if (!TestDataGuessByTestDiscoveryUtil.isEnabled()) {
            List<TestDataFile> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        String testClassQualifiedName = (String)ReadAction.compute(() -> parametrizedTestClass.getQualifiedName());
        if (testClassQualifiedName == null) {
            List<TestDataFile> list = Collections.emptyList();
            if (list == null) {
                TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        Project project = (Project)ReadAction.compute(() -> parametrizedTestClass.getProject());
        AffectedPathConsumer consumer = new AffectedPathConsumer(project);
        TestDiscoveryProducer.consumeAffectedPaths((Project)project, (String)testClassQualifiedName, (Consumer)consumer, (byte)0);
        List<TestDataFile> list = consumer.getTestData();
        if (list == null) {
            TestDataGuessByTestDiscoveryUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static boolean isEnabled() {
        return Registry.is((String)"testDiscovery.enabled") || ApplicationManager.getApplication().isInternal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByTestDiscoveryUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametrizedTestClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByTestDiscoveryUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestDataByExistingFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTestDataByExistingFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    private static final class AffectedPathConsumer
    implements Consumer<String> {
        private final List<String> myTestData = new ArrayList<String>();
        private final String myBasePath;

        private AffectedPathConsumer(Project project) {
            this.myBasePath = project.getBasePath();
        }

        public void consume(String path) {
            String fullPath = this.myBasePath + path;
            if (FileUtil.exists((String)fullPath)) {
                this.myTestData.add(fullPath);
                return;
            }
            fullPath = this.myBasePath + (path = StringUtil.trimStart((String)path, (String)TestDataGuessByTestDiscoveryUtil.COMMUNITY_PREFIX));
            if (FileUtil.exists((String)fullPath)) {
                this.myTestData.add(fullPath);
            }
        }

        @NotNull
        List<TestDataFile> getTestData() {
            List list = ContainerUtil.mapNotNull(this.myTestData, f -> new TestDataFile.LazyResolved((String)f));
            if (list == null) {
                AffectedPathConsumer.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataGuessByTestDiscoveryUtil$AffectedPathConsumer", "getTestData"));
        }
    }
}

