/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PointersKt;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IntellijInternalApi
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R,\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/idea/devkit/util/QuickFixWithReferenceToElement;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "referencedElement", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "<set-?>", "Lcom/intellij/psi/SmartPsiElementPointer;", "getReferencedElement", "()Lcom/intellij/psi/SmartPsiElementPointer;", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "startElement", "endElement", "intellij.devkit.core"})
@ApiStatus.Internal
public abstract class QuickFixWithReferenceToElement<T extends PsiElement>
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private SmartPsiElementPointer<T> referencedElement;

    public QuickFixWithReferenceToElement(@NotNull PsiElement element, @NotNull T referencedElement) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(referencedElement, (String)"referencedElement");
        super(element);
        boolean bl = Intrinsics.areEqual((Object)element.getContainingFile(), (Object)referencedElement.getContainingFile());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.referencedElement = PointersKt.createSmartPointer$default(referencedElement, null, (int)1, null);
    }

    @NotNull
    public final SmartPsiElementPointer<T> getReferencedElement() {
        return this.referencedElement;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        return this.referencedElement.getElement() != null;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FileModifier clone = super.getFileModifierForPreview(target);
        if (!(clone instanceof QuickFixWithReferenceToElement)) {
            return clone;
        }
        PsiElement psiElement = this.referencedElement.getElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement element = psiElement;
        PsiElement callingMethodInCopy = PsiTreeUtil.findSameElementInCopy((PsiElement)element, (PsiFile)target);
        QuickFixWithReferenceToElement quickFixWithReferenceToElement = (QuickFixWithReferenceToElement)clone;
        Intrinsics.checkNotNullExpressionValue((Object)callingMethodInCopy, (String)"callingMethodInCopy");
        quickFixWithReferenceToElement.referencedElement = PointersKt.createSmartPointer$default((PsiElement)callingMethodInCopy, null, (int)1, null);
        return clone;
    }
}

