/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.InspectionUtils;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class HtmlRequiredSummaryAttributeInspection
extends HtmlLocalInspectionTool {
    private static final String TABLE = "table";
    private static final String SUMMARY = "summary";

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlRequiredSummaryAttributeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlRequiredSummaryAttributeInspection.$$$reportNull$$$0(1);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        String tagName = StringUtil.toLowerCase((String)tag.getName());
        if (!tagName.equalsIgnoreCase(TABLE)) {
            return;
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (tag.getAttribute(SUMMARY) != null) {
            return;
        }
        if (isOnTheFly) {
            fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, SUMMARY, new String[0]));
        }
        InspectionUtils.RegisterProblem(tag, holder, fixes, HtmlToolsBundle.message("html.inspections.check.required.summary", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @NotNull
    public String getShortName() {
        String string = super.getShortName();
        if (string == null) {
            HtmlRequiredSummaryAttributeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredSummaryAttributeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredSummaryAttributeInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkTag";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

