/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.containers.SLRUCache;
import com.intellij.util.io.AppendablePersistentMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.function.ObjIntConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.java.dependencyView.IntIntMultiMaplet;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;

public final class IntIntPersistentMultiMaplet
extends IntIntMultiMaplet {
    private static final IntSet NULL_COLLECTION = new IntOpenHashSet();
    private static final int CACHE_SIZE = 128;
    private final PersistentHashMap<Integer, IntSet> myMap;
    private final SLRUCache<Integer, IntSet> myCache;

    public IntIntPersistentMultiMaplet(File file, KeyDescriptor<Integer> keyExternalizer) throws IOException {
        this.myMap = new PersistentHashMap(file, keyExternalizer, (DataExternalizer)new IntSetExternalizer());
        this.myCache = new SLRUCache<Integer, IntSet>(128, 128){

            @NotNull
            public IntSet createValue(Integer key) {
                IntSet intSet;
                try {
                    IntSet collection = (IntSet)IntIntPersistentMultiMaplet.this.myMap.get((Object)key);
                    intSet = collection == null ? NULL_COLLECTION : collection;
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
                if (intSet == null) {
                    1.$$$reportNull$$$0(0);
                }
                return intSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$1", "createValue"));
            }
        };
    }

    @Override
    public boolean containsKey(int key) {
        try {
            return this.myMap.containsMapping((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public IntSet get(int key) {
        IntSet collection = (IntSet)this.myCache.get((Object)key);
        return collection == NULL_COLLECTION ? null : collection;
    }

    @Override
    public void replace(int key, IntSet value) {
        try {
            this.myCache.remove((Object)key);
            if (value == null || value.isEmpty()) {
                this.myMap.remove((Object)key);
            } else {
                this.myMap.put((Object)key, (Object)value);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, final IntSet value) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.appendData((Object)key, new AppendablePersistentMap.ValueDataAppender(){

                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    IntIterator iterator = value.iterator();
                    while (iterator.hasNext()) {
                        int value1 = iterator.nextInt();
                        DataInputOutputUtil.writeINT((DataOutput)out, (int)value1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$2", "append"));
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void put(int key, final int value) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.appendData((Object)key, new AppendablePersistentMap.ValueDataAppender(){

                public void append(@NotNull DataOutput out) throws IOException {
                    if (out == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$3", "append"));
                }
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeAll(int key, IntSet values) {
        try {
            IntSet collection = (IntSet)this.myCache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.removeAll((IntCollection)values)) {
                this.myCache.remove((Object)key);
                if (collection.isEmpty()) {
                    this.myMap.remove((Object)key);
                } else {
                    this.myMap.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void removeFrom(int key, int value) {
        try {
            IntSet collection = (IntSet)this.myCache.get((Object)key);
            if (collection != NULL_COLLECTION && collection.remove(value)) {
                this.myCache.remove((Object)key);
                if (collection.isEmpty()) {
                    this.myMap.remove((Object)key);
                } else {
                    this.myMap.put((Object)key, (Object)collection);
                }
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void remove(int key) {
        try {
            this.myCache.remove((Object)key);
            this.myMap.remove((Object)key);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void putAll(IntIntMultiMaplet m) {
        m.forEachEntry((integers, value) -> this.put(value, (IntSet)integers));
    }

    @Override
    public void replaceAll(IntIntMultiMaplet m) {
        m.forEachEntry((integers, value) -> this.replace(value, (IntSet)integers));
    }

    @Override
    public void close() {
        try {
            this.myCache.clear();
            this.myMap.close();
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void flush(boolean memoryCachesOnly) {
        if (memoryCachesOnly) {
            if (this.myMap.isDirty()) {
                this.myMap.dropMemoryCaches();
            }
        } else {
            this.myMap.force();
        }
    }

    @Override
    public void forEachEntry(ObjIntConsumer<? super IntSet> procedure) {
        try {
            this.myMap.processKeysWithExistingMapping(key -> {
                try {
                    procedure.accept((IntSet)this.myMap.get(key), (int)key);
                }
                catch (IOException e) {
                    throw new BuildDataCorruptedException(e);
                }
                return true;
            });
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static final class IntSetExternalizer
    implements DataExternalizer<IntSet> {
        private IntSetExternalizer() {
        }

        public void save(@NotNull DataOutput out, IntSet value) throws IOException {
            if (out == null) {
                IntSetExternalizer.$$$reportNull$$$0(0);
            }
            IntIterator iterator = value.iterator();
            while (iterator.hasNext()) {
                int elem = iterator.nextInt();
                DataInputOutputUtil.writeINT((DataOutput)out, (int)elem);
            }
        }

        public IntSet read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                IntSetExternalizer.$$$reportNull$$$0(1);
            }
            IntOpenHashSet result = new IntOpenHashSet();
            DataInputStream stream = (DataInputStream)in;
            while (stream.available() > 0) {
                result.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/jps/builders/java/dependencyView/IntIntPersistentMultiMaplet$IntSetExternalizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

