/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java.dependencyView;

import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.dependencyView.DependencyContext;
import org.jetbrains.jps.builders.java.dependencyView.Difference;
import org.jetbrains.jps.builders.java.dependencyView.DifferenceImpl;
import org.jetbrains.jps.builders.java.dependencyView.Proto;
import org.jetbrains.jps.builders.java.dependencyView.RW;
import org.jetbrains.jps.builders.java.dependencyView.TypeRepr;
import org.jetbrains.jps.builders.storage.BuildDataCorruptedException;
import org.jetbrains.org.objectweb.asm.Type;

abstract class ProtoMember
extends Proto {
    @NotNull
    public final TypeRepr.AbstractType myType;
    public final Object myValue;

    public boolean hasValue() {
        return this.myValue != null;
    }

    protected ProtoMember(int access, int signature, int name, @NotNull TypeRepr.AbstractType t, @NotNull Set<TypeRepr.ClassType> annotations, Object value) {
        if (t == null) {
            ProtoMember.$$$reportNull$$$0(0);
        }
        if (annotations == null) {
            ProtoMember.$$$reportNull$$$0(1);
        }
        super(access, signature, name, annotations);
        this.myType = t;
        this.myValue = value;
    }

    protected ProtoMember(DependencyContext context, DataInput in) {
        super(context, in);
        try {
            this.myType = (TypeRepr.AbstractType)TypeRepr.externalizer(context).read(in);
            this.myValue = ProtoMember.loadTyped(in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    private static Object loadTyped(DataInput in) {
        try {
            byte tag = in.readByte();
            if (tag < 0) {
                int length = DataInputOutputUtil.readINT((DataInput)in);
                DataDescriptor descriptor = DataDescriptor.findById(-tag);
                Object array = Array.newInstance(descriptor.getDataType(), length);
                for (int idx = 0; idx < length; ++idx) {
                    Array.set(array, idx, descriptor.load(in));
                }
                return array;
            }
            return DataDescriptor.findById(tag).load(in);
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
    }

    @Override
    public void save(DataOutput out) {
        super.save(out);
        this.myType.save(out);
        try {
            Class<?> valueType;
            Object val = this.myValue;
            Class<?> clazz = valueType = val != null ? val.getClass() : null;
            if (valueType != null && valueType.isArray()) {
                int length = Array.getLength(val);
                Class<?> dataType = length > 0 ? Array.get(val, 0).getClass() : valueType.getComponentType();
                DataDescriptor descriptor = DataDescriptor.findByValueType(dataType);
                out.writeByte(-descriptor.getId());
                if (descriptor != DataDescriptor.NONE) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)length);
                    for (int idx = 0; idx < length; ++idx) {
                        Object element = Array.get(val, idx);
                        descriptor.save(out, element);
                    }
                }
            } else {
                DataDescriptor descriptor = DataDescriptor.findByValueType(valueType);
                out.writeByte(descriptor.getId());
                descriptor.save(out, val);
            }
        }
        catch (IOException e) {
            throw new BuildDataCorruptedException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Difference difference(final Proto past) {
        ProtoMember m = (ProtoMember)past;
        Difference diff = super.difference(past);
        int base = diff.base();
        if (!m.myType.equals(this.myType)) {
            base |= 2;
        }
        switch ((this.myValue == null ? 0 : 1) + (m.myValue == null ? 0 : 2)) {
            case 3: {
                if (this.myValue.equals(m.myValue)) break;
                base |= 4;
                break;
            }
            case 2: {
                base |= 4;
                break;
            }
            case 1: {
                base |= 4;
                break;
            }
        }
        final int newBase = base;
        return new DifferenceImpl(diff){

            @Override
            public int base() {
                return newBase;
            }

            @Override
            public boolean no() {
                return newBase == 0 && super.no();
            }

            @Override
            public boolean hadValue() {
                return ((ProtoMember)past).hasValue();
            }
        };
    }

    @Override
    public void toStream(DependencyContext context, PrintStream stream) {
        super.toStream(context, stream);
        stream.print("          Type       : ");
        stream.println(this.myType.getDescr(context));
        stream.print("          Value      : ");
        stream.println(this.myValue == null ? "<null>" : this.myValue.toString());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "t";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "annotations";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/builders/java/dependencyView/ProtoMember";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class DataDescriptor<T> {
        public static final DataDescriptor NONE = new DataDescriptor(0, null){

            public Object load(DataInput out) {
                return null;
            }

            public void save(DataOutput out, Object value) throws IOException {
            }
        };
        public static final DataDescriptor<String> STRING = new DataDescriptor<String>(1, String.class){

            @Override
            public String load(DataInput in) throws IOException {
                return RW.readUTF(in);
            }

            @Override
            public void save(DataOutput out, String value) throws IOException {
                RW.writeUTF(out, value);
            }
        };
        public static final DataDescriptor<Integer> INTEGER = new DataDescriptor<Integer>(2, Integer.class){

            @Override
            public Integer load(DataInput in) throws IOException {
                return DataInputOutputUtil.readINT((DataInput)in);
            }

            @Override
            public void save(DataOutput out, Integer value) throws IOException {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value);
            }
        };
        public static final DataDescriptor<Long> LONG = new DataDescriptor<Long>(3, Long.class){

            @Override
            public Long load(DataInput in) throws IOException {
                return in.readLong();
            }

            @Override
            public void save(DataOutput out, Long value) throws IOException {
                out.writeLong(value);
            }
        };
        public static final DataDescriptor<Float> FLOAT = new DataDescriptor<Float>(4, Float.class){

            @Override
            public Float load(DataInput in) throws IOException {
                return Float.valueOf(in.readFloat());
            }

            @Override
            public void save(DataOutput out, Float value) throws IOException {
                out.writeFloat(value.floatValue());
            }
        };
        public static final DataDescriptor<Double> DOUBLE = new DataDescriptor<Double>(5, Double.class){

            @Override
            public Double load(DataInput in) throws IOException {
                return in.readDouble();
            }

            @Override
            public void save(DataOutput out, Double value) throws IOException {
                out.writeDouble(value);
            }
        };
        public static final DataDescriptor<Type> TYPE = new DataDescriptor<Type>(6, Type.class){

            @Override
            public Type load(DataInput in) throws IOException {
                return Type.getType((String)RW.readUTF(in));
            }

            @Override
            public void save(DataOutput out, Type value) throws IOException {
                RW.writeUTF(out, value.getDescriptor());
            }
        };
        private final byte myId;
        @Nullable
        private final Class<T> myDataType;

        private DataDescriptor(int id, Class<T> dataType) {
            this.myId = (byte)id;
            this.myDataType = dataType;
        }

        public byte getId() {
            return this.myId;
        }

        @Nullable
        public Class<T> getDataType() {
            return this.myDataType;
        }

        public abstract void save(DataOutput var1, T var2) throws IOException;

        public abstract T load(DataInput var1) throws IOException;

        @NotNull
        public static DataDescriptor findById(byte tag) {
            if (STRING.getId() == tag) {
                DataDescriptor<String> dataDescriptor = STRING;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(0);
                }
                return dataDescriptor;
            }
            if (INTEGER.getId() == tag) {
                DataDescriptor<Integer> dataDescriptor = INTEGER;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(1);
                }
                return dataDescriptor;
            }
            if (LONG.getId() == tag) {
                DataDescriptor<Long> dataDescriptor = LONG;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(2);
                }
                return dataDescriptor;
            }
            if (FLOAT.getId() == tag) {
                DataDescriptor<Float> dataDescriptor = FLOAT;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(3);
                }
                return dataDescriptor;
            }
            if (DOUBLE.getId() == tag) {
                DataDescriptor<Double> dataDescriptor = DOUBLE;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(4);
                }
                return dataDescriptor;
            }
            if (TYPE.getId() == tag) {
                DataDescriptor<Type> dataDescriptor = TYPE;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(5);
                }
                return dataDescriptor;
            }
            if (NONE.getId() == tag) {
                DataDescriptor dataDescriptor = NONE;
                if (dataDescriptor == null) {
                    DataDescriptor.$$$reportNull$$$0(6);
                }
                return dataDescriptor;
            }
            assert (false) : "Unknown descriptor tag: " + tag;
            DataDescriptor dataDescriptor = NONE;
            if (dataDescriptor == null) {
                DataDescriptor.$$$reportNull$$$0(7);
            }
            return dataDescriptor;
        }

        public static DataDescriptor findByValueType(@Nullable Class<?> dataType) {
            if (dataType != null) {
                if (dataType.equals(STRING.getDataType())) {
                    return STRING;
                }
                if (dataType.equals(INTEGER.getDataType())) {
                    return INTEGER;
                }
                if (dataType.equals(LONG.getDataType())) {
                    return LONG;
                }
                if (dataType.equals(FLOAT.getDataType())) {
                    return FLOAT;
                }
                if (dataType.equals(DOUBLE.getDataType())) {
                    return DOUBLE;
                }
                if (TYPE.getDataType().isAssignableFrom(dataType)) {
                    return TYPE;
                }
            }
            return NONE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/dependencyView/ProtoMember$DataDescriptor", "findById"));
        }
    }
}

