/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.incremental.storage.BuildTargetsState;
import org.jetbrains.jps.incremental.storage.FileStampStorage;
import org.jetbrains.jps.incremental.storage.FileTimestampStorage;
import org.jetbrains.jps.incremental.storage.StampsStorage;

public final class ProjectStamps {
    public static final String PORTABLE_CACHES_PROPERTY = "org.jetbrains.jps.portable.caches";
    public static final boolean PORTABLE_CACHES = Boolean.getBoolean("org.jetbrains.jps.portable.caches");
    private static final Logger LOG = Logger.getInstance(ProjectStamps.class);
    private final StampsStorage<? extends StampsStorage.Stamp> myStampsStorage;

    public ProjectStamps(File dataStorageRoot, BuildTargetsState targetsState, PathRelativizerService relativizer) throws IOException {
        this.myStampsStorage = PORTABLE_CACHES ? new FileStampStorage(dataStorageRoot, relativizer, targetsState) : new FileTimestampStorage(dataStorageRoot, targetsState);
    }

    public StampsStorage<? extends StampsStorage.Stamp> getStampStorage() {
        return this.myStampsStorage;
    }

    public void clean() {
        this.myStampsStorage.wipe();
    }

    public void close() {
        try {
            this.myStampsStorage.close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            FileUtil.delete((File)this.myStampsStorage.getStorageRoot());
        }
    }
}

