/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client;

import io.prometheus.client.Collector;
import io.prometheus.client.SimpleCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Info
extends SimpleCollector<Child>
implements Collector.Describable {
    Info(Builder b) {
        super(b);
    }

    public static Builder build(String name, String help) {
        return (Builder)((Builder)new Builder().name(name)).help(help);
    }

    public static Builder build() {
        return new Builder();
    }

    @Override
    protected Child newChild() {
        return new Child(this.labelNames);
    }

    public void info(String ... v) {
        ((Child)this.noLabelsChild).info(v);
    }

    public void info(Map<String, String> v) {
        ((Child)this.noLabelsChild).info(v);
    }

    public Map<String, String> get() {
        return ((Child)this.noLabelsChild).get();
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>();
        for (Map.Entry c : this.children.entrySet()) {
            Map<String, String> v = ((Child)c.getValue()).get();
            ArrayList<String> names = new ArrayList<String>(this.labelNames);
            ArrayList<String> values2 = new ArrayList<String>((Collection)c.getKey());
            for (Map.Entry<String, String> l : v.entrySet()) {
                names.add(l.getKey());
                values2.add(l.getValue());
            }
            samples.add(new Collector.MetricFamilySamples.Sample(this.fullname + "_info", names, values2, 1.0));
        }
        return this.familySamplesList(Collector.Type.INFO, samples);
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return Collections.singletonList(new Collector.MetricFamilySamples(this.fullname, Collector.Type.INFO, this.help, Collections.<Collector.MetricFamilySamples.Sample>emptyList()));
    }

    public static class Child {
        private Map<String, String> value = Collections.emptyMap();
        private List<String> labelNames;

        private Child(List<String> labelNames) {
            this.labelNames = labelNames;
        }

        public void info(Map<String, String> v) {
            for (String key : v.keySet()) {
                Collector.checkMetricLabelName(key);
            }
            for (String label : this.labelNames) {
                if (!v.containsKey(label)) continue;
                throw new IllegalArgumentException("Info and its value cannot have the same label name.");
            }
            this.value = v;
        }

        public void info(String ... v) {
            if (v.length % 2 != 0) {
                throw new IllegalArgumentException("An even number of arguments must be passed");
            }
            TreeMap<String, String> m = new TreeMap<String, String>();
            for (int i = 0; i < v.length; i += 2) {
                m.put(v[i], v[i + 1]);
            }
            this.info(m);
        }

        public Map<String, String> get() {
            return this.value;
        }
    }

    public static class Builder
    extends SimpleCollector.Builder<Builder, Info> {
        @Override
        public Info create() {
            if (!this.unit.isEmpty()) {
                throw new IllegalStateException("Info metrics cannot have a unit.");
            }
            return new Info(this);
        }
    }
}

