/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.NoContentException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.glassfish.jersey.message.internal.MessageBodyProcessingException;

@Produces(value={"text/plain"})
@Consumes(value={"text/plain"})
@Singleton
final class BasicTypesMessageProvider
extends AbstractMessageReaderWriterProvider<Object> {
    BasicTypesMessageProvider() {
    }

    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations2, MediaType mediaType) {
        return this.canProcess(type2);
    }

    @Override
    public Object readFrom(Class<Object> type2, Type genericType, Annotation[] annotations2, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        String entityString = BasicTypesMessageProvider.readFromAsString(entityStream, mediaType);
        if (entityString.isEmpty()) {
            throw new NoContentException(LocalizationMessages.ERROR_READING_ENTITY_MISSING());
        }
        PrimitiveTypes primitiveType = PrimitiveTypes.forType(type2);
        if (primitiveType != null) {
            return primitiveType.convert(entityString);
        }
        Constructor constructor = AccessController.doPrivileged(ReflectionHelper.getStringConstructorPA(type2));
        if (constructor != null) {
            try {
                return type2.cast(constructor.newInstance(entityString));
            }
            catch (Exception e) {
                throw new MessageBodyProcessingException(LocalizationMessages.ERROR_ENTITY_PROVIDER_BASICTYPES_CONSTRUCTOR(type2));
            }
        }
        if (AtomicInteger.class.isAssignableFrom(type2)) {
            return new AtomicInteger((Integer)PrimitiveTypes.INTEGER.convert(entityString));
        }
        if (AtomicLong.class.isAssignableFrom(type2)) {
            return new AtomicLong((Long)PrimitiveTypes.LONG.convert(entityString));
        }
        throw new MessageBodyProcessingException(LocalizationMessages.ERROR_ENTITY_PROVIDER_BASICTYPES_UNKWNOWN(type2));
    }

    @Override
    public boolean isWriteable(Class<?> type2, Type genericType, Annotation[] annotations2, MediaType mediaType) {
        return this.canProcess(type2);
    }

    private boolean canProcess(Class<?> type2) {
        if (PrimitiveTypes.forType(type2) != null) {
            return true;
        }
        if (Number.class.isAssignableFrom(type2)) {
            Constructor constructor = AccessController.doPrivileged(ReflectionHelper.getStringConstructorPA(type2));
            if (constructor != null) {
                return true;
            }
            if (AtomicInteger.class.isAssignableFrom(type2) || AtomicLong.class.isAssignableFrom(type2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public long getSize(Object t, Class<?> type2, Type genericType, Annotation[] annotations2, MediaType mediaType) {
        return t.toString().length();
    }

    @Override
    public void writeTo(Object o, Class<?> type2, Type genericType, Annotation[] annotations2, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        BasicTypesMessageProvider.writeToAsString(o.toString(), entityStream, mediaType);
    }

    private static enum PrimitiveTypes {
        BYTE((Class)Byte.class, (Class)Byte.TYPE){

            @Override
            public Object convert(String s2) {
                return Byte.valueOf(s2);
            }
        }
        ,
        SHORT((Class)Short.class, (Class)Short.TYPE){

            @Override
            public Object convert(String s2) {
                return Short.valueOf(s2);
            }
        }
        ,
        INTEGER((Class)Integer.class, (Class)Integer.TYPE){

            @Override
            public Object convert(String s2) {
                return Integer.valueOf(s2);
            }
        }
        ,
        LONG((Class)Long.class, (Class)Long.TYPE){

            @Override
            public Object convert(String s2) {
                return Long.valueOf(s2);
            }
        }
        ,
        FLOAT((Class)Float.class, (Class)Float.TYPE){

            @Override
            public Object convert(String s2) {
                return Float.valueOf(s2);
            }
        }
        ,
        DOUBLE((Class)Double.class, (Class)Double.TYPE){

            @Override
            public Object convert(String s2) {
                return Double.valueOf(s2);
            }
        }
        ,
        BOOLEAN((Class)Boolean.class, (Class)Boolean.TYPE){

            @Override
            public Object convert(String s2) {
                return Boolean.valueOf(s2);
            }
        }
        ,
        CHAR((Class)Character.class, (Class)Character.TYPE){

            @Override
            public Object convert(String s2) {
                if (s2.length() != 1) {
                    throw new MessageBodyProcessingException(LocalizationMessages.ERROR_ENTITY_PROVIDER_BASICTYPES_CHARACTER_MORECHARS());
                }
                return Character.valueOf(s2.charAt(0));
            }
        };

        private final Class<?> wrapper;
        private final Class<?> primitive;

        public static PrimitiveTypes forType(Class<?> type2) {
            for (PrimitiveTypes primitive : PrimitiveTypes.values()) {
                if (!primitive.supports(type2)) continue;
                return primitive;
            }
            return null;
        }

        private PrimitiveTypes(Class<?> wrapper, Class<?> primitive) {
            this.wrapper = wrapper;
            this.primitive = primitive;
        }

        public abstract Object convert(String var1);

        public boolean supports(Class<?> type2) {
            return type2 == this.wrapper || type2 == this.primitive;
        }
    }
}

