/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.bouncycastle.tls.CombinedHash;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.util.Integers;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable hashes;
    private boolean forceBuffering;
    private boolean sealed;

    DeferredHash(TlsContext tlsContext) {
        this.context = tlsContext;
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.forceBuffering = false;
        this.sealed = false;
    }

    private DeferredHash(TlsContext tlsContext, Hashtable hashtable) {
        this.context = tlsContext;
        this.buf = null;
        this.hashes = hashtable;
        this.forceBuffering = false;
        this.sealed = true;
    }

    public void copyBufferTo(OutputStream outputStream) throws IOException {
        if (this.buf == null) {
            throw new IllegalStateException("Not buffering");
        }
        this.buf.copyTo(outputStream);
    }

    public void forceBuffering() {
        if (this.sealed) {
            throw new IllegalStateException("Too late to force buffering");
        }
        this.forceBuffering = true;
    }

    public void notifyPRFDetermined() {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                this.checkTrackingHash(1);
                this.checkTrackingHash(2);
                break;
            }
            default: {
                this.checkTrackingHash(securityParameters.getPRFCryptoHashAlgorithm());
            }
        }
    }

    public void trackHashAlgorithm(int n) {
        if (this.sealed) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(n);
    }

    public void sealHashAlgorithms() {
        if (this.sealed) {
            throw new IllegalStateException("Already sealed");
        }
        this.sealed = true;
        this.checkStopBuffering();
    }

    public TlsHandshakeHash stopTracking() {
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        Hashtable hashtable = new Hashtable();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                this.cloneHash(hashtable, 1);
                this.cloneHash(hashtable, 2);
                break;
            }
            default: {
                this.cloneHash(hashtable, securityParameters.getPRFCryptoHashAlgorithm());
            }
        }
        return new DeferredHash(this.context, hashtable);
    }

    public TlsHash forkPRFHash() {
        TlsHash tlsHash;
        this.checkStopBuffering();
        SecurityParameters securityParameters = this.context.getSecurityParametersHandshake();
        switch (securityParameters.getPRFAlgorithm()) {
            case 0: 
            case 1: {
                tlsHash = new CombinedHash(this.context, this.cloneHash(1), this.cloneHash(2));
                break;
            }
            default: {
                tlsHash = this.cloneHash(securityParameters.getPRFCryptoHashAlgorithm());
            }
        }
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        return tlsHash;
    }

    public byte[] getFinalHash(int n) {
        TlsHash tlsHash = (TlsHash)this.hashes.get(this.box(n));
        if (tlsHash == null) {
            throw new IllegalStateException("CryptoHashAlgorithm." + n + " is not being tracked");
        }
        this.checkStopBuffering();
        tlsHash = tlsHash.cloneHash();
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        return tlsHash.calculateHash();
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.buf != null) {
            this.buf.write(byArray, n, n2);
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            TlsHash tlsHash = (TlsHash)enumeration.nextElement();
            tlsHash.update(byArray, n, n2);
        }
    }

    public byte[] calculateHash() {
        throw new IllegalStateException("Use 'forkPRFHash' to get a definite hash");
    }

    public TlsHash cloneHash() {
        throw new IllegalStateException("attempt to clone a DeferredHash");
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            TlsHash tlsHash = (TlsHash)enumeration.nextElement();
            tlsHash.reset();
        }
    }

    protected Integer box(int n) {
        return Integers.valueOf(n);
    }

    protected void checkStopBuffering() {
        if (!this.forceBuffering && this.sealed && this.buf != null && this.hashes.size() <= 4) {
            Enumeration enumeration = this.hashes.elements();
            while (enumeration.hasMoreElements()) {
                TlsHash tlsHash = (TlsHash)enumeration.nextElement();
                this.buf.updateDigest(tlsHash);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(int n) {
        this.checkTrackingHash(this.box(n));
    }

    protected void checkTrackingHash(Integer n) {
        if (!this.hashes.containsKey(n)) {
            TlsHash tlsHash = this.context.getCrypto().createHash(n);
            this.hashes.put(n, tlsHash);
        }
    }

    protected TlsHash cloneHash(int n) {
        return this.cloneHash(this.box(n));
    }

    protected TlsHash cloneHash(Integer n) {
        return ((TlsHash)this.hashes.get(n)).cloneHash();
    }

    protected void cloneHash(Hashtable hashtable, int n) {
        this.cloneHash(hashtable, this.box(n));
    }

    protected void cloneHash(Hashtable hashtable, Integer n) {
        TlsHash tlsHash = this.cloneHash(n);
        if (this.buf != null) {
            this.buf.updateDigest(tlsHash);
        }
        hashtable.put(n, tlsHash);
    }
}

