/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice;

import java.net.DatagramSocket;
import java.net.Socket;
import java.util.Comparator;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Candidate;
import org.ice4j.ice.CandidatePairState;
import org.ice4j.ice.Component;
import org.ice4j.ice.LocalCandidate;
import org.ice4j.ice.RemoteCandidate;
import org.ice4j.socket.IceSocketWrapper;
import org.ice4j.stack.TransactionID;

public class CandidatePair
implements Comparable<CandidatePair> {
    public static final long CONSENT_FRESHNESS_UNKNOWN = -1L;
    private static final long MATH_POW_2_32 = 0x100000000L;
    public static final PairComparator comparator = new PairComparator();
    private LocalCandidate localCandidate;
    private RemoteCandidate remoteCandidate;
    private long priority;
    private boolean useCandidate = false;
    private boolean useCandidateSent = false;
    private boolean isValid = false;
    private boolean isNominated = false;
    private CandidatePairState state = CandidatePairState.FROZEN;
    private TransactionID connCheckTranID = null;
    private long consentFreshness = -1L;

    public CandidatePair(LocalCandidate localCandidate, RemoteCandidate remoteCandidate) {
        this.localCandidate = localCandidate;
        this.remoteCandidate = remoteCandidate;
        this.computePriority();
    }

    public String getFoundation() {
        return this.localCandidate.getFoundation() + this.remoteCandidate.getFoundation();
    }

    public LocalCandidate getLocalCandidate() {
        return this.localCandidate;
    }

    protected void setLocalCandidate(LocalCandidate localCnd) {
        this.localCandidate = localCnd;
    }

    public RemoteCandidate getRemoteCandidate() {
        return this.remoteCandidate;
    }

    protected void setRemoteCandidate(RemoteCandidate remoteCnd) {
        this.remoteCandidate = remoteCnd;
    }

    public CandidatePairState getState() {
        return this.state;
    }

    public void setStateFailed() {
        this.setState(CandidatePairState.FAILED, null);
    }

    public void setStateFrozen() {
        this.setState(CandidatePairState.FROZEN, null);
    }

    public void setStateInProgress(TransactionID tranID) {
        this.setState(CandidatePairState.IN_PROGRESS, tranID);
    }

    public void setStateSucceeded() {
        this.setState(CandidatePairState.SUCCEEDED, null);
    }

    public void setStateWaiting() {
        this.setState(CandidatePairState.WAITING, null);
    }

    private synchronized void setState(CandidatePairState newState, TransactionID tranID) throws IllegalArgumentException {
        CandidatePairState oldState = this.state;
        this.state = newState;
        if (newState == CandidatePairState.IN_PROGRESS) {
            if (tranID == null) {
                throw new IllegalArgumentException("Putting a pair into the In-Progress state MUST be accompanied with the TransactionID of the connectivity check.");
            }
        } else if (tranID != null) {
            throw new IllegalArgumentException("How could you have a transaction for a pair that's not in the In-Progress state?");
        }
        this.connCheckTranID = tranID;
        this.getParentComponent().getParentStream().firePairPropertyChange(this, "PairStateChanged", (Object)oldState, (Object)newState);
    }

    public boolean isFrozen() {
        return this.getState().equals((Object)CandidatePairState.FROZEN);
    }

    public Candidate<?> getControllingAgentCandidate() {
        return this.getLocalCandidate().getParentComponent().getParentStream().getParentAgent().isControlling() ? this.getLocalCandidate() : this.getRemoteCandidate();
    }

    public Candidate<?> getControlledAgentCandidate() {
        return this.getLocalCandidate().getParentComponent().getParentStream().getParentAgent().isControlling() ? this.getRemoteCandidate() : this.getLocalCandidate();
    }

    protected void computePriority() {
        long expr;
        long max;
        long min2;
        long d;
        long g2 = this.getControllingAgentCandidate().getPriority();
        if (g2 > (d = this.getControlledAgentCandidate().getPriority())) {
            min2 = d;
            max = g2;
            expr = 1L;
        } else {
            min2 = g2;
            max = d;
            expr = 0L;
        }
        this.priority = 0x100000000L * min2 + 2L * max + expr;
    }

    public long getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(CandidatePair candidatePair) {
        long otherPri;
        long thisPri = this.getPriority();
        return thisPri < (otherPri = candidatePair.getPriority()) ? 1 : (thisPri == otherPri ? 0 : -1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CandidatePair)) {
            return false;
        }
        CandidatePair candidatePair = (CandidatePair)obj;
        return this.localCandidate.equals(candidatePair.localCandidate) && this.remoteCandidate.equals(candidatePair.remoteCandidate);
    }

    public int hashCode() {
        return this.getLocalCandidate().getParentComponent().hashCode();
    }

    public String toString() {
        return "CandidatePair (State=" + (Object)((Object)this.getState()) + " Priority=" + this.getPriority() + "):\n\tLocalCandidate=" + this.getLocalCandidate() + "\n\tRemoteCandidate=" + this.getRemoteCandidate();
    }

    public String toShortString() {
        return this.getLocalCandidate().toShortString() + " -> " + this.getRemoteCandidate().toShortString() + " (" + this.getParentComponent().toShortString() + ")";
    }

    public Component getParentComponent() {
        return this.getLocalCandidate().getParentComponent();
    }

    public TransactionID getConnectivityCheckTransaction() {
        return this.connCheckTranID;
    }

    public void setUseCandidateSent() {
        this.useCandidateSent = true;
    }

    public boolean useCandidateSent() {
        return this.useCandidateSent;
    }

    public void setUseCandidateReceived() {
        this.useCandidate = true;
    }

    public boolean useCandidateReceived() {
        return this.useCandidate;
    }

    public void nominate() {
        this.isNominated = true;
        this.getParentComponent().getParentStream().firePairPropertyChange(this, "PairNominated", false, true);
    }

    public boolean isNominated() {
        return this.isNominated;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void validate() {
        this.isValid = true;
        this.getParentComponent().getParentStream().firePairPropertyChange(this, "PairValidated", false, true);
    }

    public long getConsentFreshness() {
        return this.consentFreshness;
    }

    void setConsentFreshness() {
        this.setConsentFreshness(System.currentTimeMillis());
    }

    void setConsentFreshness(long consentFreshness) {
        if (this.consentFreshness != consentFreshness) {
            long oldValue = this.consentFreshness;
            long newValue = this.consentFreshness = consentFreshness;
            this.getParentComponent().getParentStream().firePairPropertyChange(this, "PairConsentFreshnessChanged", oldValue, newValue);
        }
    }

    @Deprecated
    public DatagramSocket getDatagramSocket() {
        IceSocketWrapper wrapper = this.getIceSocketWrapper();
        return wrapper == null ? null : wrapper.getUDPSocket();
    }

    @Deprecated
    public Socket getSocket() {
        return null;
    }

    @Deprecated
    public IceSocketWrapper getIceSocketWrapper() {
        TransportAddress remoteAddress;
        RemoteCandidate remoteCandidate;
        IceSocketWrapper componentSocket = this.getParentComponent().getSocketWrapper();
        if (componentSocket != null) {
            return this.getParentComponent().getSocketWrapper();
        }
        LocalCandidate localCandidate = this.getLocalCandidate();
        if (localCandidate == null) {
            return null;
        }
        LocalCandidate base = (LocalCandidate)localCandidate.getBase();
        if (base != null) {
            localCandidate = base;
        }
        if ((remoteCandidate = this.getRemoteCandidate()) != null && (remoteAddress = remoteCandidate.getTransportAddress()) != null) {
            return localCandidate.getCandidateIceSocketWrapper(remoteAddress);
        }
        return localCandidate.getCandidateIceSocketWrapper();
    }

    public static class PairComparator
    implements Comparator<CandidatePair> {
        @Override
        public int compare(CandidatePair pair1, CandidatePair pair2) {
            return pair1.compareTo(pair2);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof PairComparator;
        }
    }
}

