/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqBuilder;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;

public class DiscoverInfoBuilder
extends IqBuilder<DiscoverInfoBuilder, DiscoverInfo>
implements DiscoverInfoView {
    private final List<DiscoverInfo.Feature> features = new ArrayList<DiscoverInfo.Feature>();
    private final List<DiscoverInfo.Identity> identities = new ArrayList<DiscoverInfo.Identity>();
    private String node;

    DiscoverInfoBuilder(IqData iqCommon) {
        super(iqCommon);
    }

    DiscoverInfoBuilder(XMPPConnection connection) {
        super(connection);
    }

    DiscoverInfoBuilder(String stanzaId) {
        super(stanzaId);
    }

    public DiscoverInfoBuilder(DiscoverInfo discoverInfo, String stanzaId) {
        super(discoverInfo, stanzaId);
        this.features.addAll(discoverInfo.getFeatures());
        this.identities.addAll(discoverInfo.getIdentities());
        this.node = discoverInfo.getNode();
    }

    @Override
    public DiscoverInfoBuilder getThis() {
        return this;
    }

    public DiscoverInfoBuilder addFeatures(Collection<String> features) {
        for (String feature : features) {
            this.addFeature(feature);
        }
        return this.getThis();
    }

    public DiscoverInfoBuilder addFeature(String feature) {
        return this.addFeature(new DiscoverInfo.Feature(feature));
    }

    public DiscoverInfoBuilder addFeature(DiscoverInfo.Feature feature) {
        this.features.add(feature);
        return this.getThis();
    }

    public DiscoverInfoBuilder addIdentities(Collection<DiscoverInfo.Identity> identities) {
        this.identities.addAll(identities);
        return this.getThis();
    }

    public DiscoverInfoBuilder addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        return this.getThis();
    }

    public DiscoverInfoBuilder setNode(String node2) {
        this.node = node2;
        return this.getThis();
    }

    @Override
    public DiscoverInfo build() {
        return new DiscoverInfo(this, true);
    }

    public DiscoverInfo buildWithoutValidiation() {
        return new DiscoverInfo(this, false);
    }

    @Override
    public List<DiscoverInfo.Feature> getFeatures() {
        return this.features;
    }

    @Override
    public List<DiscoverInfo.Identity> getIdentities() {
        return this.identities;
    }

    @Override
    public String getNode() {
        return this.node;
    }

    public static DiscoverInfoBuilder buildResponseFor(DiscoverInfo request, IQ.ResponseType responseType) {
        DiscoverInfoBuilder builder2 = new DiscoverInfoBuilder(DiscoverInfoBuilder.createResponse(request, responseType));
        builder2.setNode(request.getNode());
        return builder2;
    }
}

