/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.TagModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionList;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletionManager;

public class TagCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    protected AutoCompletingTextField editor = new AutoCompletingTextField(0, false);
    protected transient TagModel currentTag;
    protected transient AutoCompletionManager autocomplete;
    protected AutoCompletionList autoCompletionList;

    public TagCellEditor(int maxCharacters) {
        if (maxCharacters > 0) {
            this.editor.setMaxChars(maxCharacters);
        }
        this.editor.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    protected void initAutoCompletionListForKeys(TagEditorModel model, TagModel currentTag) {
        if (this.autoCompletionList == null) {
            return;
        }
        this.autoCompletionList.clear();
        this.autocomplete.populateWithKeys(this.autoCompletionList);
        for (String key : model.getKeys()) {
            if (key.equals(currentTag.getName())) continue;
            this.autoCompletionList.remove(key);
        }
        this.autoCompletionList.fireTableDataChanged();
    }

    protected void initAutoCompletionListForValues(String forKey) {
        if (this.autoCompletionList == null) {
            return;
        }
        this.autoCompletionList.clear();
        this.autocomplete.populateWithTagValues(this.autoCompletionList, forKey);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentTag = (TagModel)value;
        if (this.autoCompletionList != null) {
            this.autoCompletionList.clear();
        }
        if (column == 0) {
            this.editor.setText(this.currentTag.getName());
            TagEditorModel model = (TagEditorModel)table.getModel();
            this.initAutoCompletionListForKeys(model, this.currentTag);
            return this.editor;
        }
        if (column == 1) {
            if (this.currentTag.getValueCount() == 0) {
                this.editor.setText("");
            } else if (this.currentTag.getValueCount() == 1) {
                this.editor.setText(this.currentTag.getValues().get(0));
            } else {
                this.editor.setText("");
            }
            this.initAutoCompletionListForValues(this.currentTag.getName());
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getText();
    }

    public AutoCompletionList getAutoCompletionList() {
        return this.autoCompletionList;
    }

    public void setAutoCompletionList(AutoCompletionList autoCompletionList) {
        this.autoCompletionList = autoCompletionList;
        this.editor.setAutoCompletionList(autoCompletionList);
    }

    public void setAutoCompletionManager(AutoCompletionManager autocomplete) {
        this.autocomplete = autocomplete;
    }

    public void autoCompletionItemSelected(String item) {
        this.editor.setText(item);
        this.editor.selectAll();
        this.editor.requestFocus();
    }

    public AutoCompletingTextField getEditor() {
        return this.editor;
    }
}

