/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.client.MapProtocolMapperUtils;
import org.keycloak.models.map.clientscope.AbstractClientScopeModel;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;

public class MapClientScopeAdapter
extends AbstractClientScopeModel<MapClientScopeEntity>
implements ClientScopeModel {
    private static final Logger LOG = Logger.getLogger(MapClientScopeAdapter.class);
    private final MapProtocolMapperUtils pmUtils = MapProtocolMapperUtils.instanceFor(this.safeGetProtocol());

    public MapClientScopeAdapter(KeycloakSession session, RealmModel realm, MapClientScopeEntity entity) {
        super(session, realm, entity);
    }

    public String getId() {
        return ((MapClientScopeEntity)this.entity).getId();
    }

    public String getName() {
        return ((MapClientScopeEntity)this.entity).getName();
    }

    public void setName(String name) {
        ((MapClientScopeEntity)this.entity).setName(KeycloakModelUtils.convertClientScopeName((String)name));
    }

    public String getDescription() {
        return ((MapClientScopeEntity)this.entity).getDescription();
    }

    public void setDescription(String description) {
        ((MapClientScopeEntity)this.entity).setDescription(description);
    }

    public String getProtocol() {
        return ((MapClientScopeEntity)this.entity).getProtocol();
    }

    public void setProtocol(String protocol) {
        ((MapClientScopeEntity)this.entity).setProtocol(protocol);
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public void setAttribute(String name, String value) {
        ((MapClientScopeEntity)this.entity).setAttribute(name, Collections.singletonList(value));
    }

    public void removeAttribute(String name) {
        ((MapClientScopeEntity)this.entity).removeAttribute(name);
    }

    public String getAttribute(String name) {
        List<String> attribute = ((MapClientScopeEntity)this.entity).getAttribute(name);
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        return attribute.get(0);
    }

    public Map<String, String> getAttributes() {
        Map<String, List<String>> attributes = ((MapClientScopeEntity)this.entity).getAttributes();
        Map<Object, Object> a = attributes == null ? Collections.emptyMap() : attributes;
        return a.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (((List)entry.getValue()).isEmpty()) {
                return null;
            }
            if (((List)entry.getValue()).size() > 1) {
                LOG.warnf("ClientScope '%s' realm '%s' has attribute '%s' with %d values, retrieving only the first", new Object[]{this.getName(), this.getRealm().getName(), entry.getKey(), ((List)entry.getValue()).size()});
            }
            return (String)((List)entry.getValue()).get(0);
        }));
    }

    private String safeGetProtocol() {
        return ((MapClientScopeEntity)this.entity).getProtocol() == null ? "openid-connect" : ((MapClientScopeEntity)this.entity).getProtocol();
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        Set<MapProtocolMapperEntity> protocolMappers = ((MapClientScopeEntity)this.entity).getProtocolMappers();
        return protocolMappers == null ? Stream.empty() : protocolMappers.stream().distinct().map(this.pmUtils::toModel);
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (model == null) {
            return null;
        }
        MapProtocolMapperEntity pm = MapProtocolMapperUtils.fromModel(model);
        if (pm.getId() == null) {
            String id = KeycloakModelUtils.generateId();
            pm.setId(id);
        }
        if (model.getConfig() == null) {
            pm.setConfig(new HashMap<String, String>());
        }
        ((MapClientScopeEntity)this.entity).addProtocolMapper(pm);
        return this.pmUtils.toModel(pm);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        String id;
        String string = id = mapping == null ? null : mapping.getId();
        if (id != null) {
            ((MapClientScopeEntity)this.entity).removeProtocolMapper(id);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        String id;
        String string = id = mapping == null ? null : mapping.getId();
        if (id != null) {
            ((MapClientScopeEntity)this.entity).getProtocolMapper(id).ifPresent(pmEntity -> {
                ((MapClientScopeEntity)this.entity).removeProtocolMapper(id);
                this.addProtocolMapper(mapping);
            });
        }
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return ((MapClientScopeEntity)this.entity).getProtocolMapper(id).map(this.pmUtils::toModel).orElse(null);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        Set<MapProtocolMapperEntity> protocolMappers = ((MapClientScopeEntity)this.entity).getProtocolMappers();
        if (!Objects.equals(protocol, this.safeGetProtocol())) {
            return null;
        }
        return protocolMappers == null ? null : (ProtocolMapperModel)protocolMappers.stream().filter(pm -> Objects.equals(pm.getName(), name)).map(this.pmUtils::toModel).findAny().orElse(null);
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        Collection<String> scopeMappings = ((MapClientScopeEntity)this.entity).getScopeMappings();
        return scopeMappings == null ? Stream.empty() : scopeMappings.stream().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0)).filter(Objects::nonNull);
    }

    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return this.getScopeMappingsStream().filter(r -> RoleUtils.isRealmRole((RoleModel)r, (RealmModel)this.realm));
    }

    public void addScopeMapping(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null) {
            ((MapClientScopeEntity)this.entity).addScopeMapping(id);
        }
    }

    public void deleteScopeMapping(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null) {
            ((MapClientScopeEntity)this.entity).removeScopeMapping(id);
        }
    }

    public boolean hasScope(RoleModel role) {
        return RoleUtils.hasRole(this.getScopeMappingsStream(), (RoleModel)role);
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }
}

