/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.userSession;

import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.common.TimeAdapter;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.models.utils.SessionExpirationUtils;

public class SessionExpiration {
    private static long getTimestampNote(MapAuthenticatedClientSessionEntity entity, String name) {
        String value = entity.getNote(name);
        if (value == null) {
            return entity.getTimestamp();
        }
        return TimeAdapter.fromSecondsToMilliseconds(Integer.parseInt(value));
    }

    public static void setClientSessionExpiration(MapAuthenticatedClientSessionEntity entity, RealmModel realm, ClientModel client) {
        long timestampMillis = entity.getTimestamp() != null ? entity.getTimestamp() : 0L;
        long clientSessionStartedAtMillis = SessionExpiration.getTimestampNote(entity, "startedAt");
        long userSessionStartedAtMillis = SessionExpiration.getTimestampNote(entity, "userSessionStartedAt");
        boolean isRememberMe = Boolean.parseBoolean(entity.getNote("userSessionRememberMe"));
        boolean isOffline = Boolean.TRUE.equals(entity.isOffline());
        long expiresbyLifespan = SessionExpirationUtils.calculateClientSessionMaxLifespanTimestamp((boolean)isOffline, (boolean)isRememberMe, (long)clientSessionStartedAtMillis, (long)userSessionStartedAtMillis, (RealmModel)realm, (ClientModel)client);
        long expiresByIdle = SessionExpirationUtils.calculateClientSessionIdleTimestamp((boolean)isOffline, (boolean)isRememberMe, (long)timestampMillis, (RealmModel)realm, (ClientModel)client);
        if (expiresbyLifespan > 0L) {
            entity.setExpiration(Math.min(expiresbyLifespan, expiresByIdle));
        } else {
            entity.setExpiration(expiresByIdle);
        }
    }

    public static void setUserSessionExpiration(MapUserSessionEntity entity, RealmModel realm) {
        long timestampMillis = entity.getTimestamp() != null ? entity.getTimestamp() : 0L;
        long lastSessionRefreshMillis = entity.getLastSessionRefresh() != null ? entity.getLastSessionRefresh() : 0L;
        boolean isRememberMe = Boolean.TRUE.equals(entity.isRememberMe());
        boolean isOffline = Boolean.TRUE.equals(entity.isOffline());
        long expiresByLifespan = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp((boolean)isOffline, (boolean)isRememberMe, (long)timestampMillis, (RealmModel)realm);
        long expiresByIdle = SessionExpirationUtils.calculateUserSessionIdleTimestamp((boolean)isOffline, (boolean)isRememberMe, (long)lastSessionRefreshMillis, (RealmModel)realm);
        if (expiresByLifespan > 0L) {
            entity.setExpiration(Math.min(expiresByLifespan, expiresByIdle));
        } else {
            entity.setExpiration(expiresByIdle);
        }
    }
}

