/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.client;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientEntityDelegate;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaMapStorage;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.models.map.storage.jpa.client.JpaClientModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.client.delegate.JpaClientDelegateProvider;
import org.keycloak.models.map.storage.jpa.client.entity.JpaClientEntity;

public class JpaClientMapStorage
extends JpaMapStorage<JpaClientEntity, MapClientEntity, ClientModel> {
    public JpaClientMapStorage(KeycloakSession session, EntityManager em) {
        super(session, JpaClientEntity.class, ClientModel.class, em);
    }

    @Override
    public Selection<JpaClientEntity> selectCbConstruct(CriteriaBuilder cb, Root<JpaClientEntity> root) {
        return cb.construct(JpaClientEntity.class, new Selection[]{root.get("id"), root.get("version"), root.get("entityVersion"), root.get("realmId"), root.get("clientId"), root.get("protocol"), root.get("enabled")});
    }

    @Override
    public void setEntityVersion(JpaRootEntity entity) {
        entity.setEntityVersion(Constants.CURRENT_SCHEMA_VERSION_CLIENT);
    }

    @Override
    public JpaModelCriteriaBuilder createJpaModelCriteriaBuilder() {
        return new JpaClientModelCriteriaBuilder();
    }

    @Override
    protected MapClientEntity mapToEntityDelegate(JpaClientEntity original) {
        return new MapClientEntityDelegate((DelegateProvider)new JpaClientDelegateProvider(original, this.em));
    }
}

