/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.user.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaChildEntity;
import org.keycloak.models.map.storage.jpa.JpaRootEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserConsentMetadata;
import org.keycloak.models.map.storage.jpa.user.entity.JpaUserEntity;
import org.keycloak.models.map.user.MapUserConsentEntity;

@Entity
@Table(name="kc_user_consent", uniqueConstraints={@UniqueConstraint(columnNames={"clientId"})})
@EnhancementInfo(version="6.2.7.Final")
public class JpaUserConsentEntity
extends UpdatableEntity.Impl
implements MapUserConsentEntity,
JpaRootEntity,
JpaChildEntity<JpaUserEntity>,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    @GeneratedValue
    UUID id;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String clientId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaUserConsentMetadata metadata;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fk_root")
    JpaUserEntity root;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaUserConsentEntity() {
        this.metadata = new JpaUserConsentMetadata();
    }

    public JpaUserConsentEntity(DeepCloner cloner) {
        this.metadata = new JpaUserConsentMetadata(cloner);
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer version) {
        this.$$_hibernate_read_metadata().setEntityVersion(version);
    }

    @Override
    public JpaUserEntity getParent() {
        return this.$$_hibernate_read_root();
    }

    public void setParent(JpaUserEntity root) {
        this.$$_hibernate_write_root(root);
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id == null ? null : UUID.fromString(id));
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_USER_CONSENT;
    }

    public String getClientId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getClientId();
        }
        return this.$$_hibernate_read_clientId();
    }

    public void setClientId(String clientId) {
        this.$$_hibernate_read_metadata().setClientId(clientId);
    }

    public Set<String> getGrantedClientScopesIds() {
        return this.$$_hibernate_read_metadata().getGrantedClientScopesIds();
    }

    public void addGrantedClientScopesId(String scope) {
        this.$$_hibernate_read_metadata().addGrantedClientScopesId(scope);
    }

    public void setGrantedClientScopesIds(Set<String> scopesIds) {
        this.$$_hibernate_read_metadata().setGrantedClientScopesIds(scopesIds);
    }

    public void removeGrantedClientScopesId(String scopes) {
        this.$$_hibernate_read_metadata().removeGrantedClientScopesId(scopes);
    }

    public Long getCreatedDate() {
        return this.$$_hibernate_read_metadata().getCreatedDate();
    }

    public void setCreatedDate(Long createdDate) {
        this.$$_hibernate_read_metadata().setCreatedDate(createdDate);
    }

    public Long getLastUpdatedDate() {
        return this.$$_hibernate_read_metadata().getLastUpdatedDate();
    }

    public void setLastUpdatedDate(Long lastUpdatedDate) {
        this.$$_hibernate_read_metadata().setLastUpdatedDate(lastUpdatedDate);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaUserConsentEntity)) {
            return false;
        }
        return Objects.equals(this.$$_hibernate_read_id(), ((JpaUserConsentEntity)obj).$$_hibernate_read_id());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public JpaUserConsentMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaUserConsentMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public JpaUserEntity $$_hibernate_read_root() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.root = (JpaUserEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "root", (Object)this.root);
        }
        return this.root;
    }

    public void $$_hibernate_write_root(JpaUserEntity jpaUserEntity) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.root = (JpaUserEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "root", (Object)this.root, (Object)jpaUserEntity);
            return;
        }
        this.root = jpaUserEntity;
    }
}

