/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.actiontoken.updateemail;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.keycloak.authentication.actiontoken.DefaultActionToken;

public class UpdateEmailActionToken
extends DefaultActionToken {
    public static final String TOKEN_TYPE = "update-email";
    @JsonProperty(value="oldEmail")
    private String oldEmail;
    @JsonProperty(value="newEmail")
    private String newEmail;
    @JsonProperty(value="logoutSessions")
    private Boolean logoutSessions;

    public UpdateEmailActionToken(String userId, int absoluteExpirationInSecs, String oldEmail, String newEmail, String clientId) {
        this(userId, absoluteExpirationInSecs, oldEmail, newEmail, clientId, null);
    }

    public UpdateEmailActionToken(String userId, int absoluteExpirationInSecs, String oldEmail, String newEmail, String clientId, Boolean logoutSessions) {
        super(userId, TOKEN_TYPE, absoluteExpirationInSecs, null);
        this.oldEmail = oldEmail;
        this.newEmail = newEmail;
        this.issuedFor = clientId;
        this.logoutSessions = Boolean.TRUE.equals(logoutSessions) ? Boolean.valueOf(true) : null;
    }

    private UpdateEmailActionToken() {
    }

    public String getOldEmail() {
        return this.oldEmail;
    }

    public void setOldEmail(String oldEmail) {
        this.oldEmail = oldEmail;
    }

    public String getNewEmail() {
        return this.newEmail;
    }

    public void setNewEmail(String newEmail) {
        this.newEmail = newEmail;
    }

    public Boolean getLogoutSessions() {
        return this.logoutSessions;
    }

    public void setLogoutSessions(Boolean logoutSessions) {
        this.logoutSessions = Boolean.TRUE.equals(logoutSessions) ? Boolean.valueOf(true) : null;
    }
}

