/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.transaction;

import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import org.keycloak.models.KeycloakTransaction;

public class HotRodRemoteTransactionWrapper
implements KeycloakTransaction {
    private final TransactionManager transactionManager;

    public HotRodRemoteTransactionWrapper(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void begin() {
        try {
            if (this.transactionManager.getStatus() == 6) {
                this.transactionManager.begin();
            }
        }
        catch (NotSupportedException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void commit() {
        try {
            if (this.transactionManager.getStatus() == 0) {
                this.transactionManager.commit();
            }
        }
        catch (HeuristicMixedException | HeuristicRollbackException | RollbackException | SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void rollback() {
        try {
            if (this.transactionManager.getStatus() == 0) {
                this.transactionManager.rollback();
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public void setRollbackOnly() {
        try {
            if (this.transactionManager.getStatus() == 0) {
                this.transactionManager.setRollbackOnly();
            }
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean getRollbackOnly() {
        try {
            return this.transactionManager.getStatus() == 1;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isActive() {
        try {
            return this.transactionManager.getStatus() == 0;
        }
        catch (SystemException e) {
            throw new RuntimeException(e);
        }
    }
}

