/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.runtime.config.ConfigDescriptionBean;
import io.quarkus.devui.runtime.config.ConfigDevUiRecorder;
import io.quarkus.devui.runtime.config.ConfigJsonRPCService;
import io.quarkus.devui.spi.JsonRPCProvidersBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.vertx.http.deployment.devmode.console.ConfigEditorProcessor;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ConfigurationProcessor {
    private static final Pattern codePattern = Pattern.compile("(\\{@code )([^}]+)(\\})");
    private static final Pattern linkPattern = Pattern.compile("(\\{@link )([^}]+)(\\})");

    @BuildStep(onlyIf={IsDevelopment.class})
    InternalPageBuildItem createConfigurationPages(List<ConfigDescriptionBuildItem> configDescriptionBuildItems, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig) {
        InternalPageBuildItem configurationPages = new InternalPageBuildItem("Configuration", 20);
        configurationPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace("devui-configuration")).title("Form Editor")).icon("font-awesome-solid:sliders")).componentLink("qwc-configuration.js"));
        configurationPages.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().namespace("devui-configuration")).title("Source Editor")).icon("font-awesome-solid:code")).componentLink("qwc-configuration-editor.js"));
        configurationPages.addBuildTimeData("allConfiguration", new ArrayList());
        return configurationPages;
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void registerConfigs(List<ConfigDescriptionBuildItem> configDescriptionBuildItems, Optional<DevServicesLauncherConfigResultBuildItem> devServicesLauncherConfig, ConfigDevUiRecorder recorder) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>();
        for (ConfigDescriptionBuildItem item : configDescriptionBuildItems) {
            configDescriptions.add(new ConfigDescription(item.getPropertyName(), ConfigurationProcessor.formatJavadoc(ConfigEditorProcessor.cleanUpAsciiDocIfNecessary(item.getDocs())), item.getDefaultValue(), ConfigEditorProcessor.isSetByDevServices(devServicesLauncherConfig, item.getPropertyName()), item.getValueTypeName(), item.getAllowedValues(), item.getConfigPhase().name()));
        }
        HashSet devServicesConfig = new HashSet();
        if (devServicesLauncherConfig.isPresent()) {
            devServicesConfig.addAll(devServicesLauncherConfig.get().getConfig().keySet());
        }
        recorder.registerConfigs(configDescriptions, devServicesConfig);
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerJsonRpcService(BuildProducer<JsonRPCProvidersBuildItem> jsonRPCProvidersProducer, BuildProducer<SyntheticBeanBuildItem> syntheticBeanProducer, ConfigDevUiRecorder recorder) {
        DevConsoleManager.register((String)"config-update-property", map -> {
            Map<String, String> values = Collections.singletonMap((String)map.get("name"), (String)map.get("value"));
            ConfigEditorProcessor.updateConfig(values, false);
            return null;
        });
        DevConsoleManager.register((String)"config-set-properties", value -> {
            String content = (String)value.get("content");
            ConfigEditorProcessor.setConfig(content, false);
            return null;
        });
        syntheticBeanProducer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(ConfigDescriptionBean.class).unremovable()).supplier(recorder.configDescriptionBean()).scope(Singleton.class)).setRuntimeInit().done());
        jsonRPCProvidersProducer.produce((BuildItem)new JsonRPCProvidersBuildItem("devui-configuration", ConfigJsonRPCService.class));
    }

    private static String formatJavadoc(String val) {
        if (val == null) {
            return val;
        }
        val = codePattern.matcher(val).replaceAll("<code>$2</code>");
        val = linkPattern.matcher(val).replaceAll("<code>$2</code>");
        val = val.lines().filter(s -> !s.startsWith("@see")).collect(Collectors.joining("\n"));
        val = val.replace("@deprecated", "<br><strong>Deprecated</strong>");
        return val;
    }
}

