/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.persistence.remote.RemoteStore;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserLoginFailureProviderFactory;
import org.keycloak.models.UserModel;
import org.keycloak.models.sessions.infinispan.InfinispanUserLoginFailureProvider;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.events.AbstractUserSessionClusterListener;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveAllUserLoginFailuresEvent;
import org.keycloak.models.sessions.infinispan.initializer.InfinispanCacheInitializer;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionListener;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheSessionsLoader;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;

public class InfinispanUserLoginFailureProviderFactory
implements UserLoginFailureProviderFactory {
    private static final Logger log = Logger.getLogger(InfinispanUserLoginFailureProviderFactory.class);
    public static final String PROVIDER_ID = "infinispan";
    public static final String REALM_REMOVED_SESSION_EVENT = "REALM_REMOVED_EVENT_SESSIONS";
    public static final String REMOVE_ALL_LOGIN_FAILURES_EVENT = "REMOVE_ALL_LOGIN_FAILURES_EVENT";
    private Config.Scope config;
    private RemoteCacheInvoker remoteCacheInvoker;

    public UserLoginFailureProvider create(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache loginFailures = connections.getCache("loginFailures");
        return new InfinispanUserLoginFailureProvider(session, this.remoteCacheInvoker, loginFailures);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    public void postInit(KeycloakSessionFactory factory) {
        this.remoteCacheInvoker = new RemoteCacheInvoker();
        factory.register(event -> {
            if (event instanceof PostMigrationEvent) {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, session -> {
                    this.checkRemoteCaches(session);
                    this.registerClusterListeners(session);
                    this.loadLoginFailuresFromRemoteCaches(session);
                });
            } else if (event instanceof UserModel.UserRemovedEvent) {
                UserModel.UserRemovedEvent userRemovedEvent = (UserModel.UserRemovedEvent)event;
                UserLoginFailureProvider provider = (UserLoginFailureProvider)userRemovedEvent.getKeycloakSession().getProvider(UserLoginFailureProvider.class, this.getId());
                provider.removeUserLoginFailure(userRemovedEvent.getRealm(), userRemovedEvent.getUser().getId());
            }
        });
    }

    protected void registerClusterListeners(KeycloakSession session) {
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
        cluster.registerListener(REALM_REMOVED_SESSION_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RealmRemovedSessionEvent, UserLoginFailureProvider>(sessionFactory, UserLoginFailureProvider.class){

            @Override
            protected void eventReceived(KeycloakSession session, UserLoginFailureProvider provider, RealmRemovedSessionEvent sessionEvent) {
                if (provider instanceof InfinispanUserLoginFailureProvider) {
                    ((InfinispanUserLoginFailureProvider)provider).removeAllLocalUserLoginFailuresEvent(sessionEvent.getRealmId());
                }
            }
        });
        cluster.registerListener(REMOVE_ALL_LOGIN_FAILURES_EVENT, (ClusterListener)new AbstractUserSessionClusterListener<RemoveAllUserLoginFailuresEvent, UserLoginFailureProvider>(sessionFactory, UserLoginFailureProvider.class){

            @Override
            protected void eventReceived(KeycloakSession session, UserLoginFailureProvider provider, RemoveAllUserLoginFailuresEvent sessionEvent) {
                if (provider instanceof InfinispanUserLoginFailureProvider) {
                    ((InfinispanUserLoginFailureProvider)provider).removeAllLocalUserLoginFailuresEvent(sessionEvent.getRealmId());
                }
            }
        });
        log.debug((Object)"Registered cluster listeners");
    }

    protected void checkRemoteCaches(KeycloakSession session) {
        InfinispanConnectionProvider ispn = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache loginFailuresCache = ispn.getCache("loginFailures");
        this.checkRemoteCache(session, loginFailuresCache, realm -> Time.toMillis((long)realm.getMaxDeltaTimeSeconds()), SessionTimeouts::getLoginFailuresLifespanMs, SessionTimeouts::getLoginFailuresMaxIdleMs);
    }

    private <K, V extends SessionEntity> RemoteCache checkRemoteCache(KeycloakSession session, Cache<K, SessionEntityWrapper<V>> ispnCache, RemoteCacheInvoker.MaxIdleTimeLoader maxIdleLoader, SessionFunction<V> lifespanMsLoader, SessionFunction<V> maxIdleTimeMsLoader) {
        Set<RemoteStore> remoteStores = InfinispanUtil.getRemoteStores(ispnCache);
        if (remoteStores.isEmpty()) {
            log.debugf("No remote store configured for cache '%s'", (Object)ispnCache.getName());
            return null;
        }
        log.infof("Remote store configured for cache '%s'", (Object)ispnCache.getName());
        RemoteCache remoteCache = remoteStores.iterator().next().getRemoteCache();
        if (remoteCache == null) {
            throw new IllegalStateException("No remote cache available for the infinispan cache: " + ispnCache.getName());
        }
        this.remoteCacheInvoker.addRemoteCache(ispnCache.getName(), remoteCache, maxIdleLoader);
        RemoteCacheSessionListener hotrodListener = RemoteCacheSessionListener.createListener(session, ispnCache, remoteCache, lifespanMsLoader, maxIdleTimeMsLoader);
        remoteCache.addClientListener((Object)hotrodListener);
        return remoteCache;
    }

    private int getMaxErrors() {
        return this.config.getInt("maxErrors", Integer.valueOf(20));
    }

    private int getSessionsPerSegment() {
        return this.config.getInt("sessionsPerSegment", Integer.valueOf(64));
    }

    private void loadLoginFailuresFromRemoteCaches(KeycloakSession session) {
        for (String cacheName : this.remoteCacheInvoker.getRemoteCacheNames()) {
            this.loadLoginFailuresFromRemoteCaches(session.getKeycloakSessionFactory(), cacheName, this.getSessionsPerSegment(), this.getMaxErrors());
        }
    }

    private int getStalledTimeoutInSeconds(int defaultTimeout) {
        return this.config.getInt("stalledTimeoutInSeconds", Integer.valueOf(defaultTimeout));
    }

    private void loadLoginFailuresFromRemoteCaches(final KeycloakSessionFactory sessionFactory, final String cacheName, final int sessionsPerSegment, final int maxErrors) {
        log.debugf("Check pre-loading sessions from remote cache '%s'", (Object)cacheName);
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
                Cache workCache = connections.getCache("work");
                int defaultStateTransferTimeout = (int)(connections.getCache("loginFailures").getCacheConfiguration().clustering().stateTransfer().timeout() / 1000L);
                InfinispanCacheInitializer initializer = new InfinispanCacheInitializer(sessionFactory, workCache, new RemoteCacheSessionsLoader(cacheName, sessionsPerSegment), "remoteCacheLoad::" + cacheName, sessionsPerSegment, maxErrors, InfinispanUserLoginFailureProviderFactory.this.getStalledTimeoutInSeconds(defaultStateTransferTimeout));
                initializer.initCache();
                initializer.loadSessions();
            }
        });
        log.debugf("Pre-loading login failures from remote cache '%s' finished", (Object)cacheName);
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public int order() {
        return 1;
    }
}

