/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.util.concurrent.BlockingRunnable;

public class NonTxPerCacheInboundInvocationHandler
extends BasePerCacheInboundInvocationHandler {
    @Override
    public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
        try {
            BlockingRunnable runnable;
            int commandTopologyId = NonTxPerCacheInboundInvocationHandler.extractCommandTopologyId(command);
            boolean onExecutorService = NonTxPerCacheInboundInvocationHandler.executeOnExecutorService(order, command);
            boolean sync = order.preserveOrder();
            boolean waitForTransactionalData = true;
            switch (command.getCommandId()) {
                case 1: {
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, onExecutorService ? TopologyMode.READY_TX_DATA : TopologyMode.WAIT_TX_DATA, sync);
                    break;
                }
                case 112: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    waitForTransactionalData = false;
                }
                default: {
                    runnable = this.createDefaultRunnable(command, reply, commandTopologyId, waitForTransactionalData, onExecutorService, sync);
                }
            }
            this.handleRunnable(runnable, onExecutorService);
        }
        catch (Throwable throwable) {
            reply.reply(NonTxPerCacheInboundInvocationHandler.exceptionHandlingCommand(command, throwable));
        }
    }
}

