/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.DelegatingTableGroup;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class MappedByTableGroup
extends DelegatingTableGroup
implements VirtualTableGroup {
    private final NavigablePath navigablePath;
    private final TableGroupProducer producer;
    private final TableGroup underlyingTableGroup;
    private final boolean fetched;
    private final TableGroup parentTableGroup;
    private final LazyTableGroup.ParentTableGroupUseChecker parentTableGroupUseChecker;

    public MappedByTableGroup(NavigablePath navigablePath, TableGroupProducer producer, TableGroup underlyingTableGroup, boolean fetched, TableGroup parentTableGroup, LazyTableGroup.ParentTableGroupUseChecker parentTableGroupUseChecker) {
        this.navigablePath = navigablePath;
        this.producer = producer;
        this.underlyingTableGroup = underlyingTableGroup;
        this.fetched = fetched;
        this.parentTableGroup = parentTableGroup;
        this.parentTableGroupUseChecker = parentTableGroupUseChecker;
    }

    @Override
    protected TableGroup getTableGroup() {
        return this.underlyingTableGroup;
    }

    @Override
    public TableGroup getUnderlyingTableGroup() {
        return this.underlyingTableGroup;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ModelPartContainer getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getGroupAlias() {
        return null;
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    @Override
    public ModelPartContainer getModelPart() {
        return this.producer;
    }

    @Override
    public boolean isRealTableGroup() {
        return false;
    }

    @Override
    public boolean isLateral() {
        return false;
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return Collections.emptyList();
    }

    @Override
    public List<TableGroupJoin> getNestedTableGroupJoins() {
        return Collections.emptyList();
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
    }

    @Override
    public void visitNestedTableGroupJoins(Consumer<TableGroupJoin> consumer) {
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression) {
        TableReference tableReference = this.getTableReference(navigablePath, tableExpression, true);
        if (tableReference == null) {
            throw new UnknownTableReferenceException(tableExpression, String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", tableExpression, navigablePath));
        }
        return tableReference;
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, ValuedModelPart modelPart, String tableExpression) {
        assert (modelPart != null);
        TableReference tableReference = this.getTableReference(navigablePath, modelPart, tableExpression, true);
        if (tableReference == null) {
            throw new UnknownTableReferenceException(tableExpression, String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", tableExpression, navigablePath));
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
        return this.getTableGroup().getTableReference(navigablePath, tableExpression, resolve);
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, ValuedModelPart modelPart, String tableExpression, boolean resolve) {
        TableReference reference;
        if (this.parentTableGroupUseChecker.canUseParentTableGroup(this.producer, navigablePath, modelPart) && (reference = this.parentTableGroup.getTableReference(navigablePath, (ValuedModelPart)((Object)this.producer), tableExpression, resolve)) != null) {
            return reference;
        }
        return this.getTableGroup().getTableReference(navigablePath, modelPart, tableExpression, resolve);
    }
}

