/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.hibernate.orm.runtime.integration.HibernateOrmIntegrationRuntimeInitListener;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import liquibase.Scope;
import liquibase.servicelocator.ServiceLocator;
import org.infinispan.manager.DefaultCacheManager;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.common.crypto.CryptoProvider;
import org.keycloak.common.crypto.FipsMode;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.MicroProfileConfigProvider;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.integration.web.QuarkusRequestFilter;
import org.keycloak.quarkus.runtime.storage.database.liquibase.FastServiceLocator;
import org.keycloak.quarkus.runtime.storage.legacy.infinispan.CacheManagerFactory;
import org.keycloak.theme.ClasspathThemeProviderFactory;

@Recorder
public class KeycloakRecorder {
    public static final String DEFAULT_HEALTH_ENDPOINT = "/health";
    public static final String DEFAULT_METRICS_ENDPOINT = "/metrics";

    public void initConfig() {
        Config.init((Config.ConfigProvider)new MicroProfileConfigProvider());
    }

    public void configureProfile(Profile.ProfileName profileName, Map<Profile.Feature, Boolean> features) {
        Profile.init((Profile.ProfileName)profileName, features);
    }

    public void configureLiquibase(Map<String, List<String>> services) {
        ServiceLocator locator = Scope.getCurrentScope().getServiceLocator();
        if (locator instanceof FastServiceLocator) {
            ((FastServiceLocator)locator).initServices(services);
        }
    }

    public void configSessionFactory(Map<Spi, Map<Class<? extends Provider>, Map<String, Class<? extends ProviderFactory>>>> factories, Map<Class<? extends Provider>, String> defaultProviders, Map<String, ProviderFactory> preConfiguredProviders, List<ClasspathThemeProviderFactory.ThemesRepresentation> themes, boolean reaugmented) {
        QuarkusKeycloakSessionFactory.setInstance(new QuarkusKeycloakSessionFactory(factories, defaultProviders, preConfiguredProviders, themes, reaugmented));
    }

    public RuntimeValue<CacheManagerFactory> createCacheInitializer(String config, boolean metricsEnabled, ShutdownContext shutdownContext) {
        try {
            final CacheManagerFactory cacheManagerFactory = new CacheManagerFactory(config, metricsEnabled);
            shutdownContext.addShutdownTask(new Runnable(){

                @Override
                public void run() {
                    DefaultCacheManager cacheManager = cacheManagerFactory.getOrCreate();
                    if (cacheManager != null) {
                        cacheManager.stop();
                    }
                }
            });
            return new RuntimeValue((Object)cacheManagerFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void registerShutdownHook(ShutdownContext shutdownContext) {
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                QuarkusKeycloakSessionFactory.getInstance().close();
            }
        });
    }

    public HibernateOrmIntegrationRuntimeInitListener createUserDefinedUnitListener(final String name) {
        return new HibernateOrmIntegrationRuntimeInitListener(){

            public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
                InstanceHandle instance = Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource(){

                    public Class<? extends Annotation> annotationType() {
                        return DataSource.class;
                    }

                    public String value() {
                        return name;
                    }
                }});
                propertyCollector.accept("hibernate.connection.datasource", instance.get());
            }
        };
    }

    public HibernateOrmIntegrationRuntimeInitListener createDefaultUnitListener() {
        return new HibernateOrmIntegrationRuntimeInitListener(){

            public void contributeRuntimeProperties(BiConsumer<String, Object> propertyCollector) {
                propertyCollector.accept("hibernate.default_schema", Configuration.getRawValue("kc.db-schema"));
            }
        };
    }

    public QuarkusRequestFilter createRequestFilter(List<String> ignoredPaths, ExecutorService executor) {
        return new QuarkusRequestFilter(this.createIgnoredHttpPathsPredicate(ignoredPaths), executor);
    }

    private Predicate<RoutingContext> createIgnoredHttpPathsPredicate(final List<String> ignoredPaths) {
        if (ignoredPaths == null || ignoredPaths.isEmpty()) {
            return null;
        }
        return new Predicate<RoutingContext>(){

            @Override
            public boolean test(RoutingContext context) {
                for (String ignoredPath : ignoredPaths) {
                    if (!context.request().uri().startsWith(ignoredPath)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public void setCryptoProvider(FipsMode fipsMode) {
        String cryptoProvider = fipsMode.getProviderClassName();
        try {
            CryptoIntegration.setProvider((CryptoProvider)((CryptoProvider)Thread.currentThread().getContextClassLoader().loadClass(cryptoProvider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
        }
        catch (ClassNotFoundException | NoClassDefFoundError cause) {
            if (fipsMode.isFipsEnabled()) {
                throw new RuntimeException("Failed to configure FIPS. Make sure you have added the Bouncy Castle FIPS dependencies to the 'providers' directory.");
            }
            throw new RuntimeException("Unexpected error when configuring the crypto provider: " + cryptoProvider, cause);
        }
        catch (Exception cause) {
            throw new RuntimeException("Unexpected error when configuring the crypto provider: " + cryptoProvider, cause);
        }
    }
}

