/**
 *
 * Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
 * Requires jQuery and raphael.js
 *
 * Map of Wales by county
 * Equirectangular projection

 * @author Pinkal V.
 */
(function ($) {
    $.extend(true, $.fn.mapael,
        {
            maps: {
                wales_county: {
                    width: 250,
                    height: 250,
                    elems: {
                        "Newport": "M163.226 207.337c0.7562,0.2183 0.7816,0.1916 1.3012,0.7434 0.1535,0.1631 0.8961,0.6458 1.1188,0.5118 0,-0.5156 -0.3191,-0.9229 -0.073,-1.5111 0.1306,-0.3121 0.8118,0.3192 0.9851,0.4265 0.3586,0.2219 0.914,0.2737 1.3255,0.1706 0.6254,-0.1568 0.7315,-0.8698 1.4107,-1.0968 0.4637,-0.155 0.9913,-0.0328 1.4593,0.061l0.3283 -0.4631 0 0c0.3002,0.1499 0.7063,0.0531 0.8999,0.3899 0.175,0.3046 -0.1035,0.6473 0.377,0.7434 0.7641,0.1527 1.1345,-0.9289 1.7633,-0.8409 0.2684,0.0376 0.7878,-0.1466 0.9972,-0.3046 0.4849,-0.3657 0.6828,-0.9273 1.2404,-1.2065 0.8163,-0.4086 1.8552,0.057 2.6754,-0.7921 0.1729,-0.1791 1.5085,1.9361 1.7877,2.2667 0.6041,0.7151 0.3498,0.7337 -0.45,0.9627 -0.9234,0.2643 -0.9484,1.0175 -1.2647,1.8036 -0.1865,0.4633 -0.5611,0.6296 -0.8148,0.9871 -0.1039,0.1463 -0.0171,0.8068 -0.0608,1.0603 -0.0325,0.1885 -0.2463,0.5864 -0.0166,0.7572 0.2028,0.1507 0.8348,0.069 1.0529,0.3082 0.4573,0.5013 0.7455,1.3137 0.9965,1.6678l0 0c-2.0648,1.5086 -4.6796,2.8767 -7.1647,2.1048 -0.962,0 -2.7278,0.3661 -3.3321,-0.5605 -0.3053,-0.4681 0.2433,-1.448 0.2433,-2.084 -0.1508,0.2011 -0.8513,1.3393 -0.8513,1.5599 0,1.2561 -0.6963,1.2476 -1.5688,1.8768l-1.9943 1.438c-0.4246,0.3061 -1.3996,1.0278 -2.1954,1.4559l0 0 -0.3706 -0.81c0.146,-0.2227 0.379,-0.6013 0.5959,-0.7434 0.1354,-0.0888 0.4986,-0.3463 0.4986,-0.524 -0.3843,-0.0964 -0.5222,-0.3651 -0.5716,-0.719 -0.0896,-0.6407 -0.5551,-0.643 -0.985,-1.0115 -0.4392,-0.3763 -0.9437,-0.6108 -1.2404,-1.1212l0 0c0.1333,-0.2004 0.1214,-0.4403 0.2554,-0.6581 0.2035,-0.3309 0.4665,-0.6157 0.681,-0.9383 0.3813,-0.5731 0.2106,-0.8095 -0.3648,-1.1943 -0.6061,-0.4053 -1.2402,-0.4615 -1.2891,-1.3405 0.2326,-0.2746 0.6482,-1.214 1.131,-0.7312 0.3656,0.3656 0.5971,-0.196 0.9607,-0.3413 0.2873,-0.1149 0.7022,-0.1794 0.9485,-0.3412 0.1446,-0.0951 0.3743,-0.1795 0.3892,-0.3778 0.0057,-0.0756 -0.462,-0.4064 -0.5594,-0.5118 -0.243,-0.2631 -0.578,-0.7086 -0.2554,-1.0724l0 0z",

                        "Torfaen": "M160.867 200.183c0,-0.6223 0.3749,-1.0276 0.5716,-1.5965 0.1293,-0.3743 0.0261,-0.801 0.0243,-1.1821l-0.0122 -2.3885c-0.0034,-0.6887 -0.1824,-1.2954 -0.1824,-1.9621 0.108,-0.1652 0.4641,-0.7731 0.2067,-0.9018 -0.571,-0.2854 -1.2247,-0.7982 -1.6052,-1.3283 -0.1747,-0.2435 -0.4174,-0.5102 -0.4013,-0.8287 0.0128,-0.2527 0.2793,-0.6689 0.4013,-0.914l0 0c0.821,-0.0392 1.7007,-0.1937 2.4443,0.2194 0.4945,0.2748 1.134,0.3491 1.6539,0.6093 0.3144,0.1573 1.631,0.9597 1.6052,1.3283 -0.0205,0.2921 -0.2704,0.5152 -0.2189,0.8653 0.0613,0.4173 0.2605,0.758 0.6081,1.0115 0.107,0.1608 0.1792,0.2501 0.304,0.3656 0.3049,0.2825 0.5111,0.4077 0.377,0.914 -0.1537,0.5798 -0.2668,1.7192 -0.0243,2.2545 0.5212,0.2996 0.7037,0.1957 1.2647,0.1218 0.2922,-0.0384 1.4209,0.1172 1.5809,0.3778 0.1511,0.2462 -0.9526,1.503 -0.9729,1.9986 -0.035,0.8554 1.3505,0.3407 1.8363,0.4631 0,0.2502 -0.1411,0.5992 -0.2189,0.8531 -0.0495,0.1613 -0.0114,1.3976 -0.4986,0.9627 -0.3462,-0.3089 -0.8181,-0.4884 -1.1552,-0.0244 -0.1806,1.1733 1.0783,1.182 1.2525,2.2302 0.0749,0.4508 0.0773,0.896 0.3041,1.3039 0.1729,0.3111 0.5863,0.5565 0.8755,0.7678l0.1946 0.4753 0 0 -0.3283 0.4631c-0.468,-0.0938 -0.9956,-0.216 -1.4593,-0.061 -0.6792,0.227 -0.7853,0.94 -1.4107,1.0968 -0.4115,0.1031 -0.9669,0.0513 -1.3255,-0.1706 -0.1733,-0.1073 -0.8545,-0.7386 -0.9851,-0.4265 -0.2461,0.5882 0.073,0.9955 0.073,1.5111 -0.2227,0.134 -0.9653,-0.3487 -1.1188,-0.5118 -0.5196,-0.5518 -0.545,-0.5251 -1.3012,-0.7434l0 0c-0.1626,-0.6846 -0.262,-0.7657 -0.8634,-1.0237 -0.2102,-0.0901 -0.3895,-0.1184 -0.5229,-0.3046 -0.1177,-0.1641 0.5625,-0.4514 0.7174,-0.6216 0.3338,-0.3665 0.9561,-1.0551 1.058,-1.5355 0.0691,-0.326 0.1511,-0.6395 0.1703,-0.9749 0.0244,-0.425 -0.1095,-0.8256 -0.1095,-1.2552 -0.0797,-0.5073 -0.2774,-1.0083 -0.3769,-1.5111 -0.1296,0 -0.2294,0.2513 -0.3041,0.3412 -0.5195,0.626 -1.6586,0.2613 -2.1281,-0.2681l0 0z",

                        "Blaenau_Gwent": "M158.654 186.815c0.1669,0.2262 0.3413,0.502 0.2311,0.7922 -0.1109,0.2924 -0.3763,0.5738 -0.3892,0.9018 -0.0226,0.5765 0.4851,0.4021 0.8878,0.4021l0.4864 0.1706 0 0c-0.122,0.2451 -0.3885,0.6613 -0.4013,0.914 -0.0161,0.3185 0.2266,0.5852 0.4013,0.8287 0.3805,0.5301 1.0342,1.0429 1.6052,1.3283 0.2574,0.1287 -0.0987,0.7366 -0.2067,0.9018 0,0.6667 0.179,1.2734 0.1824,1.9621l0.0122 2.3885c0.0018,0.3811 0.105,0.8078 -0.0243,1.1821 -0.1967,0.5689 -0.5716,0.9742 -0.5716,1.5965l0 0 -0.4986 0.5362c-1.0403,0.9119 -0.4132,-0.5891 -0.2432,-1.0359 0.3559,-0.9358 -0.9034,-0.6946 -1.0945,-1.5111 -0.1333,-0.57 -0.5679,-0.4631 -1.058,-0.4631 -0.5474,0 -1.0607,-1.1765 -1.3255,-1.6208 -0.1926,-0.323 -1.6688,-2.4251 -1.8363,-2.4251 -0.3559,0.7148 -0.6057,0.4539 -0.2676,1.4014 0.1424,0.3989 0.4487,1.1374 -0.4377,0.914 -0.2818,-1.1274 -1.6564,-1.4117 -2.2133,-2.352 -0.0389,-0.5051 -0.5724,-0.9231 -0.6689,-1.4746 -0.1076,-0.6153 -0.4152,-0.8975 -0.7539,-1.4014 -0.2573,-0.3826 -0.3786,-0.5875 -0.5108,-1.0359 -0.164,-0.5566 -0.899,-0.7401 -1.3863,-0.914l0 0c0,-0.9722 0.3909,-1.2462 0.9485,-1.9498 0.4166,-0.5255 0.552,-1.2064 1.2039,-0.6459 1.0797,0.9285 2.1808,1.4522 3.624,1.2308 1.1943,-0.1833 2.2873,-0.524 3.5145,-0.524l0.7904 -0.0975 0 0z",

                        "Caerphilly": "M148.572 188.801c0.4873,0.1739 1.2223,0.3574 1.3863,0.914 0.1322,0.4484 0.2535,0.6533 0.5108,1.0359 0.3387,0.5039 0.6463,0.7861 0.7539,1.4014 0.0965,0.5515 0.63,0.9695 0.6689,1.4746 0.5569,0.9403 1.9315,1.2246 2.2133,2.352 0.8864,0.2234 0.5801,-0.5151 0.4377,-0.914 -0.3381,-0.9475 -0.0883,-0.6866 0.2676,-1.4014 0.1675,0 1.6437,2.1021 1.8363,2.4251 0.2648,0.4443 0.7781,1.6208 1.3255,1.6208 0.4901,0 0.9247,-0.1069 1.058,0.4631 0.1911,0.8165 1.4504,0.5753 1.0945,1.5111 -0.17,0.4468 -0.7971,1.9478 0.2432,1.0359l0.4986 -0.5362 0 0c0.4695,0.5294 1.6086,0.8941 2.1281,0.2681 0.0747,-0.0899 0.1745,-0.3412 0.3041,-0.3412 0.0995,0.5028 0.2972,1.0038 0.3769,1.5111 0,0.4296 0.1339,0.8302 0.1095,1.2552 -0.0192,0.3354 -0.1012,0.6489 -0.1703,0.9749 -0.1019,0.4804 -0.7242,1.169 -1.058,1.5355 -0.1549,0.1702 -0.8351,0.4575 -0.7174,0.6216 0.1334,0.1862 0.3127,0.2145 0.5229,0.3046 0.6014,0.258 0.7008,0.3391 0.8634,1.0237l0 0c-0.3226,0.3638 0.0124,0.8093 0.2554,1.0724 0.0974,0.1054 0.5651,0.4362 0.5594,0.5118 -0.0149,0.1983 -0.2446,0.2827 -0.3892,0.3778 -0.2463,0.1618 -0.6612,0.2263 -0.9485,0.3412 -0.3636,0.1453 -0.5951,0.7069 -0.9607,0.3413 -0.4828,-0.4828 -0.8984,0.4566 -1.131,0.7312 0.0489,0.879 0.683,0.9352 1.2891,1.3405 0.5754,0.3848 0.7461,0.6212 0.3648,1.1943 -0.2145,0.3226 -0.4775,0.6074 -0.681,0.9383 -0.134,0.2178 -0.1221,0.4577 -0.2554,0.6581l0 0 -0.4986 -0.0731c-0.1614,0 -0.3698,-0.1184 -0.5229,-0.1828 -0.1396,-0.0586 -0.3553,-0.1218 -0.4743,-0.195 -0.3244,-0.1994 -0.8676,0.0676 -1.0945,-0.3168 -0.217,-0.3674 -0.449,-0.2947 -0.8512,-0.3656 -0.8197,0 -1.7389,0.0913 -2.4808,0.4752 -0.7072,0.3658 -1.2634,0.9351 -1.8606,0.1463l0 0 -0.146 -0.4144c-0.2352,-0.5316 -0.4369,-1.2064 -1.1309,-1.2064 -0.161,0 -0.4358,0.0922 -0.5716,0.0243 -0.3321,-0.1663 -0.3618,-0.6719 -0.3705,-0.9987l0.0057 0.0604c-0.0549,-0.6042 -0.1096,-0.5183 -0.6445,-0.6215 -0.5689,-0.1097 -0.6693,-0.61 -0.8635,-1.0968 -0.3431,-0.8603 -1.0218,-2.573 -0.8877,-3.4854 0.0392,-0.2669 0.0333,-0.7026 -0.0608,-0.9505 -0.1167,-0.3077 -0.4791,-0.3458 -0.5959,-0.7556l0 0c1.0285,-0.6016 1.1674,-0.8738 1.1674,-2.0108 0.3442,-0.086 0.466,0.6848 0.6932,0.6215 0.225,-0.0628 0.2139,-0.5801 0.2067,-0.7799 -0.0236,-0.6518 -0.1053,-1.5641 0.3892,-2.0595 0.4051,-0.406 -1.2948,-3.8979 -1.4715,-4.6797 -0.0318,-0.3555 -0.2611,-0.6711 -0.6202,-0.4631 -0.5518,0.3198 -0.3813,-0.4263 -0.3648,-0.719 0.0205,-0.3621 -0.2743,-0.5696 -0.5108,-0.7921 -0.4537,-0.4266 -0.4599,-1.1313 -0.5837,-1.7061 -0.1999,-0.9284 0.1661,-1.8482 0.0122,-2.7054l0 0 1.3742 -0.7922 0 0z",

                        "Merthyr_Tydfil": "M147.198 189.593c0.1539,0.8572 -0.2121,1.777 -0.0122,2.7054 0.1238,0.5748 0.13,1.2795 0.5837,1.7061 0.2365,0.2225 0.5313,0.43 0.5108,0.7921 -0.0165,0.2927 -0.187,1.0388 0.3648,0.719 0.3591,-0.208 0.5884,0.1076 0.6202,0.4631 0.1767,0.7818 1.8766,4.2737 1.4715,4.6797 -0.4945,0.4954 -0.4128,1.4077 -0.3892,2.0595 0.0072,0.1998 0.0183,0.7171 -0.2067,0.7799 -0.2272,0.0633 -0.349,-0.7075 -0.6932,-0.6215 0,1.137 -0.1389,1.4092 -1.1674,2.0108l0 0 -0.0486 -0.914c-0.4055,-0.6496 -0.6984,0.1413 -1.1553,-0.3169 -0.5499,-0.5513 -0.7807,-1.4026 -1.1553,-2.0595 -0.8303,-1.4556 -1.0466,-3.3032 -2.5781,-4.3262 -0.3202,-0.2139 -0.8597,-0.2591 -1.0337,-0.6215l-0.6202 -1.2918c-0.4415,-0.4424 -0.8399,-1.0991 -1.2282,-1.6086 -0.1532,-0.2009 -1.2923,-0.9567 -1.1188,-1.0724 0.2185,-0.1456 0.497,-0.1554 0.7418,-0.0975 0.2972,0.0702 0.7216,0.3023 1.0093,0.2193 1.4331,-0.4139 -1.0773,-3.715 -1.2282,-4.4724l-0.1216 -1.5721 0 0c0.469,0.0403 1.0034,-0.5365 1.2039,-0.9384 0.0672,-0.1346 0.4039,-0.9875 0.4864,-0.853 0.1802,0.2935 0.4796,0.4688 0.7662,0.6459 0.2846,0.176 -0.3078,1.2124 0.3648,1.3161 0.6325,0.0976 2.3519,0.6368 2.493,1.3283 0.2857,1.3993 0.3239,1.3284 1.6538,1.3284l0.4865 0.0122 0 0z",

                        "Rhondda_Cynon_Taf": "M139.744 186.754l0.1216 1.5721c0.1509,0.7574 2.6613,4.0585 1.2282,4.4724 -0.2877,0.083 -0.7121,-0.1491 -1.0093,-0.2193 -0.2448,-0.0579 -0.5233,-0.0481 -0.7418,0.0975 -0.1735,0.1157 0.9656,0.8715 1.1188,1.0724 0.3883,0.5095 0.7867,1.1662 1.2282,1.6086l0.6202 1.2918c0.174,0.3624 0.7135,0.4076 1.0337,0.6215 1.5315,1.023 1.7478,2.8706 2.5781,4.3262 0.3746,0.6569 0.6054,1.5082 1.1553,2.0595 0.4569,0.4582 0.7498,-0.3327 1.1553,0.3169l0.0486 0.914 0 0c0.1168,0.4098 0.4792,0.4479 0.5959,0.7556 0.0941,0.2479 0.1,0.6836 0.0608,0.9505 -0.1341,0.9124 0.5446,2.6251 0.8877,3.4854 0.1942,0.4868 0.2946,0.9871 0.8635,1.0968 0.5349,0.1032 0.5896,0.0173 0.6445,0.6215l-0.0057 -0.0604c0.0087,0.3268 0.0384,0.8324 0.3705,0.9987 0.1358,0.0679 0.4106,-0.0243 0.5716,-0.0243 0.694,0 0.8957,0.6748 1.1309,1.2064l0.146 0.4144 0 0c-0.6035,0.3348 -1.0833,1.5477 -1.7634,1.5477 -0.6352,0 -0.646,-1.1456 -1.0823,-1.1456 -0.5725,0 -0.9808,0.1656 -1.5079,0.3412 -0.8184,0.2728 -0.8603,0.7604 -1.4958,1.2309 -0.3128,0.2317 -0.9395,-0.0083 -1.0945,0.134 -0.3101,0.2845 0.4603,1.8697 0.2432,2.4861l0 0 -0.7418 0.1097c-0.9993,0 -2.1637,-0.7448 -2.9916,0.2925 -0.0786,0.0986 -0.5236,0.7433 -0.608,0.7433 -0.1286,-0.5124 -1.113,-0.6634 -1.5201,-0.7312 -0.8968,-0.1493 -1.4237,-0.1037 -2.189,-0.6458 -0.5362,-0.3799 -1.1229,-0.0975 -1.7511,-0.0975l0 0 0.0973 -0.8531c0,-0.5076 0.1475,-0.9757 0.3891,-1.4136 0.2251,-0.4082 0.8196,-0.5085 0.9364,-0.8897 0.2714,-0.886 -0.8819,-1.4661 -0.9242,-2.4007 -0.0282,-0.6217 -0.619,-0.9798 -0.2189,-1.3162 0.579,-0.4866 0.8214,-1.4904 0.5958,-2.2057 -0.3136,-0.9474 -0.7297,-0.8649 -1.5565,-1.1821 -0.634,-0.2433 -1.1362,-1.222 -1.3985,-1.7914 -0.2332,-0.506 -0.5409,-0.6413 -0.8391,-1.0725 -0.4582,-0.6628 -1.1116,-0.4764 -1.8242,-0.524l0 0 -0.1824 -0.719c-0.1309,-0.484 -0.3634,-0.9405 -0.6323,-1.3771 -0.2899,-0.4708 -0.7006,-0.9955 -0.827,-1.5355 -0.0823,-0.3515 0.1273,-0.6492 0.0973,-0.9993 0.2185,-0.8758 0.1251,-1.8756 0.304,-2.7785 0.1716,-0.866 0.202,-1.8113 -0.1946,-2.6201 -0.2369,-0.4829 -0.6057,-0.9705 -0.5715,-1.5355l0 0c1.1631,-0.5633 1.3686,-0.6407 1.7633,-1.8646 0.2658,-0.8245 0.3494,-0.6642 1.1188,-0.5362 0.3646,0.0607 0.8915,0.1374 0.5837,-0.4021 -0.2699,-0.4733 1.0781,-0.7564 1.3985,-1.1943 0.4997,-0.6827 1.1559,-0.8171 1.6904,-1.3527 0.5383,-0.2627 0.9334,-0.2557 1.0458,-0.9628 0.0997,-0.6276 0.0974,-1.4014 0.9486,-1.4014 0.5654,0 0.5265,0.8166 0.8999,1.0846l0 0z",

                        "Bridgend": "M132.301 204.948c0.7126,0.0476 1.366,-0.1388 1.8242,0.524 0.2982,0.4312 0.6059,0.5665 0.8391,1.0725 0.2623,0.5694 0.7645,1.5481 1.3985,1.7914 0.8268,0.3172 1.2429,0.2347 1.5565,1.1821 0.2256,0.7153 -0.0168,1.7191 -0.5958,2.2057 -0.4001,0.3364 0.1907,0.6945 0.2189,1.3162 0.0423,0.9346 1.1956,1.5147 0.9242,2.4007 -0.1168,0.3812 -0.7113,0.4815 -0.9364,0.8897 -0.2416,0.4379 -0.3891,0.906 -0.3891,1.4136l-0.0973 0.8531 0 0c-0.8409,0.279 -1.5866,1.5684 -2.4322,1.4136 -1.2138,-0.2221 -0.2567,1.4858 -0.3648,1.9255 -0.3051,0 -0.6611,-0.3538 -0.8513,-0.5606 -0.3078,-0.3345 -0.5774,-0.4013 -0.985,-0.5971 -1.2797,-0.6145 -2.0734,0.756 -2.9551,1.2674l-2.1925 1.2657 0 0c-0.2614,-0.5865 -0.6718,-1.0815 -1.3828,-1.1073 -1.0432,-0.038 -1.8165,0.6536 -2.8456,-0.0488 -0.5443,-0.3716 -2.3499,-2.3907 -2.4809,-3.0466 -0.4943,-0.8056 -0.8014,-1.7039 -1.0878,-2.6122l0 0 1.7202 0.2602c0.3549,0.0344 0.6133,-0.0943 0.9972,-0.0122 0.9737,0.2081 0.83,0.4004 1.6539,-0.3778 0.7777,-0.7347 2.6053,0.2675 2.7362,-1.3161 0.0289,-0.3499 -0.6574,-2.2095 -0.9607,-2.4251 -0.5285,-0.3759 -0.933,-0.797 -1.1675,-1.4137 -0.1545,-0.4061 -0.1264,-0.8809 -0.304,-1.2674 -0.4831,-1.0515 1.0542,-0.1779 0.6324,-1.0724 -0.3662,-0.7764 0.0364,-1.4148 0.0972,-2.218 0.4559,-0.3653 0.4671,-1.5282 1.0945,-1.6208 0.4935,-0.0728 1.1374,0.3169 1.6904,0.3169 0.5766,0 0.8416,0.0986 1.362,0.3046 0.7875,0.3119 1.0755,-0.3093 1.7512,-0.4752 0.4549,-0.1116 1.1388,0.0755 1.5322,-0.2316l0 0z",


                        "Cardiff": "M163.402 219.773l-0.3706 -0.81c0.146,-0.2227 0.379,-0.6013 0.5959,-0.7434 0.1354,-0.0888 0.4986,-0.3463 0.4986,-0.524 -0.3843,-0.0964 -0.5222,-0.3651 -0.5716,-0.719 -0.0896,-0.6407 -0.5551,-0.643 -0.985,-1.0115 -0.4392,-0.3763 -0.9437,-0.6108 -1.2404,-1.1212l0 0 -0.4986 -0.0731c-0.1614,0 -0.3698,-0.1184 -0.5229,-0.1828 -0.1396,-0.0586 -0.3553,-0.1218 -0.4743,-0.195 -0.3244,-0.1994 -0.8676,0.0676 -1.0945,-0.3168 -0.217,-0.3674 -0.449,-0.2947 -0.8512,-0.3656 -0.8197,0 -1.7389,0.0913 -2.4808,0.4752 -0.7072,0.3658 -1.2634,0.9351 -1.8606,0.1463l0 0c-0.6035,0.3348 -1.0833,1.5477 -1.7634,1.5477 -0.6352,0 -0.646,-1.1456 -1.0823,-1.1456 -0.5725,0 -0.9808,0.1656 -1.5079,0.3412 -0.8184,0.2728 -0.8603,0.7604 -1.4958,1.2309 -0.3128,0.2317 -0.9395,-0.0083 -1.0945,0.134 -0.3101,0.2845 0.4603,1.8697 0.2432,2.4861l0 0c0.602,0.1887 1.7984,0.3401 2.2376,0.7799 0.6383,0.6394 0.9562,1.5488 1.3256,2.352 0.1964,0.4269 0.2108,1.1849 0.5107,1.5355 0.2868,0.3351 1.6815,-0.0027 2.043,-0.1462 0.678,-0.2693 1.0002,-1.1825 1.7755,-0.9871 0.1372,0.549 0.4859,0.8427 0.6932,1.3405 0.2804,0.6736 0.7787,0.8448 1.0945,1.499l1.0215 0.2071 0 0c-0.3671,-0.368 -0.7607,-1.7497 0.0608,-0.9261 0.6423,0.6438 0.9826,0.3829 1.3377,-0.256 0.2389,-0.4297 0.6179,-0.6675 0.9607,-1.0114 0.4007,-0.4018 0.1547,-1.4447 0.5594,-1.9986 0.3628,-0.4964 1.4664,-0.6401 2.0308,-1.2065 0.2192,-0.0068 0.544,-0.1409 0.9057,-0.3355l0 0z",

                        "Vale_of_Glamorgan": "M137.044 218.597c0.6282,0 1.2149,-0.2824 1.7511,0.0975 0.7653,0.5421 1.2922,0.4965 2.189,0.6458 0.4071,0.0678 1.3915,0.2188 1.5201,0.7312 0.0844,0 0.5294,-0.6447 0.608,-0.7433 0.8279,-1.0373 1.9923,-0.2925 2.9916,-0.2925l0.7418 -0.1097 0 0c0.602,0.1887 1.7984,0.3401 2.2376,0.7799 0.6383,0.6394 0.9562,1.5488 1.3256,2.352 0.1964,0.4269 0.2108,1.1849 0.5107,1.5355 0.2868,0.3351 1.6815,-0.0027 2.043,-0.1462 0.678,-0.2693 1.0002,-1.1825 1.7755,-0.9871 0.1372,0.549 0.4859,0.8427 0.6932,1.3405 0.2804,0.6736 0.7787,0.8448 1.0945,1.499l1.0215 0.2071 0 0c0.7033,0.7048 0.243,2.0019 0.2189,2.8517 -0.0257,0.909 0.031,1.2636 -0.7905,1.7183 -0.4901,0.2153 -1.3814,0.8131 -1.9214,0.4631 -0.507,-0.3285 -0.827,-0.5565 -1.435,-0.1828 -1.5481,0.9518 -2.4423,1.5739 -4.2076,0.7068 -0.9905,-0.4866 -1.6822,0.8709 -2.6389,1.0846 -0.6557,0.1464 -3.1112,0.2217 -3.7091,-0.0244 -0.5589,-0.1637 -1.1137,-0.4591 -1.666,-0.5849 -0.6651,-0.1516 -1.3966,0.0484 -2.0552,-0.1341 -1.2339,-0.3421 -2.6707,-1.1309 -3.9645,-1.0236 -0.7884,0.0653 -1.8321,0.4065 -2.4808,-0.2438 -0.6536,-0.6553 -0.9782,-1.3215 -1.4106,-2.1204 -0.5568,-0.9568 -1.1254,-1.7402 -1.9823,-2.4617 -0.8863,-0.7462 -1.7199,-0.9077 -2.1646,-2.0595 -0.024,-0.0622 -0.0495,-0.124 -0.0765,-0.1845l0 0 2.1925 -1.2657c0.8817,-0.5114 1.6754,-1.8819 2.9551,-1.2674 0.4076,0.1958 0.6772,0.2626 0.985,0.5971 0.1902,0.2068 0.5462,0.5606 0.8513,0.5606 0.1081,-0.4397 -0.849,-2.1476 0.3648,-1.9255 0.8456,0.1548 1.5913,-1.1346 2.4322,-1.4136l0 0z",

                        "Neath_Port_Talbot": "M130.295 193.383c-0.0342,0.565 0.3346,1.0526 0.5715,1.5355 0.3966,0.8088 0.3662,1.7541 0.1946,2.6201 -0.1789,0.9029 -0.0855,1.9027 -0.304,2.7785 0.03,0.3501 -0.1796,0.6478 -0.0973,0.9993 0.1264,0.54 0.5371,1.0647 0.827,1.5355 0.2689,0.4366 0.5014,0.8931 0.6323,1.3771l0.1824 0.719 0 0c-0.3934,0.3071 -1.0773,0.12 -1.5322,0.2316 -0.6757,0.1659 -0.9637,0.7871 -1.7512,0.4752 -0.5204,-0.206 -0.7854,-0.3046 -1.362,-0.3046 -0.553,0 -1.1969,-0.3897 -1.6904,-0.3169 -0.6274,0.0926 -0.6386,1.2555 -1.0945,1.6208 -0.0608,0.8032 -0.4634,1.4416 -0.0972,2.218 0.4218,0.8945 -1.1155,0.0209 -0.6324,1.0724 0.1776,0.3865 0.1495,0.8613 0.304,1.2674 0.2345,0.6167 0.639,1.0378 1.1675,1.4137 0.3033,0.2156 0.9896,2.0752 0.9607,2.4251 -0.1309,1.5836 -1.9585,0.5814 -2.7362,1.3161 -0.8239,0.7782 -0.6802,0.5859 -1.6539,0.3778 -0.3839,-0.0821 -0.6423,0.0466 -0.9972,0.0122l-1.7202 -0.2602 0 0c-0.2299,-0.7293 -0.4467,-1.4651 -0.7363,-2.1649 -0.484,-1.1691 -1.3603,-3.0333 -2.3592,-3.8266 -0.7791,-0.5208 -1.9208,-2.4898 -2.6389,-2.5957 -0.994,-0.1467 -1.7206,-0.1233 -2.5011,0.0523l0 0 0.1541 -1.795c0.2078,-0.7302 0.535,-1.0208 0.535,-1.8402 0,-0.9184 0.9372,-1.824 1.4593,-2.4617 0.4191,-0.512 0.6567,-1.8947 0.6567,-2.5713 -0.421,0 -1.5812,-0.2341 -1.8484,-0.585 -0.2467,-0.3242 -0.864,-2.1867 -0.7175,-2.5226 -0.1182,-0.9493 -0.5138,-1.3453 -1.131,-1.9986 -0.5016,-0.5308 -1.416,-1.1855 -1.6417,-1.9011l-0.3648 -0.5972 0 0c0.8245,-0.3462 0.7087,-0.3824 1.5201,0.0244 0.35,0.1755 0.8822,0.1463 1.2769,0.1463 0.5038,0 0.3647,-0.4757 0.3526,-0.8531 -0.0173,-0.5353 0.1009,-1.0256 -0.231,-1.4624 -0.1972,-0.2597 -0.5837,-1.0492 -0.5837,-1.3649 0.6234,0 0.7897,0.056 1.4106,-0.195 0.8739,-0.3532 1.2625,-0.2388 2.1525,-0.1828 0.8427,0.0531 1.0439,0.3619 1.5444,0.9262l0.4013 0.8165 0 0c-0.0271,0.4512 1.0425,1.2433 1.4229,1.4015 0.8871,0.3688 0.4893,1.6241 1.216,2.352 0.6761,0.6771 1.5445,0.5437 2.0309,-0.2803 0.4825,-0.8176 0.0339,-1.4763 1.1796,-1.8036 0.8753,-0.25 2.5248,-1.0359 3.3442,-1.0359 1.1773,0 1.9656,0.9215 3.0524,1.1943 0.3128,-0.0153 0.7888,0.0278 1.0945,0.0975 0.2188,0.0498 0.3094,0.0454 0.3648,0.2681 0.0355,0.1424 0.0335,0.2834 0.0608,0.4265 0.0285,0.1499 0.1186,0.4287 0.1824,0.5606 0.1108,0.2294 0.1106,0.4196 0.1703,0.6581l0 0z",

                        "Swansea": "M111.23 207.962c-0.4089,0.0919 -0.8326,0.2257 -1.3174,0.3986 -0.8815,0.3143 -1.6604,0.3029 -2.5903,0.4021 -1.2044,0.1284 -2.2804,0.4062 -2.7483,1.6818 -0.5115,1.3946 0.821,1.9974 1.7511,2.5591 -1.13,0.2848 -2.3006,0.2546 -3.4537,0.1463 -1.4242,-0.1101 -2.006,1.1675 -2.8942,0.8043 -1.1689,-0.4781 -2.6798,-1.391 -3.9645,-0.9628 -0.667,0.2222 -1.8204,0.6692 -1.4471,1.5477 0.1085,0.2553 0.7682,0.8498 0.7418,0.8653 -0.2813,0.1662 -1.0277,0.2767 -1.3499,0.1828 -1.1865,-0.3457 -2.5294,-1.2315 -2.5294,0.7068 -0.4141,0 -1.0189,-0.5746 -1.5201,-0.6581 -0.8743,-0.1456 -1.5094,-0.4313 -2.116,-1.1089 -0.9636,-0.4836 -1.152,-0.9711 -2.2984,-0.8653 -0.8005,0.0739 -1.3581,-0.2803 -2.0552,-0.2803 0.0589,-0.2359 1.113,-0.0627 1.3134,-0.0244 0.4461,0.0853 0.5933,-0.2122 0.8391,-0.4996 0.7383,-0.8629 -0.1489,-2.4338 -0.5351,-3.2416 -0.5222,-1.0924 -1.5027,-0.8593 0.1216,-1.2065 0.8067,-0.1725 2.005,-1.0599 2.5538,-1.6817 0.568,-0.3423 1.5006,-1.7029 2.0065,-1.3406 0.9247,0.6621 2.3501,1.1044 3.478,1.0237 0.6052,-0.0433 4.3415,-2.3582 4.3415,-2.8638l-0.0122 -0.0122 1.0823 -0.5606c0.2373,-0.1188 1.0247,-0.573 0.7053,-0.914 -0.2463,-0.2631 -0.6445,-0.7221 -0.6445,-1.109 0,-0.0536 0.7024,-0.2246 0.8634,-0.4387 0.3911,-0.5197 0.3729,-1.264 0.9486,-1.7305 1.031,-0.8352 -0.2243,-2.7475 0.7661,-3.205 0.5577,-0.2577 0.669,-0.8044 1.0094,-1.2309 0.378,-0.4738 0.9209,-0.8211 1.2282,-1.3527 0.181,-0.3928 0.2621,-1.127 0.3162,-1.5599 0.2158,-0.0541 0.7788,0.5465 0.9242,0.719 0.1703,0.2019 0.6611,0.4116 0.9121,0.5241 0.5596,0.2507 1.0473,-0.2203 1.4715,-0.4875 0.4528,-0.2851 0.6731,-0.3999 1.2039,-0.4997l0 0 0.3648 0.5972c0.2257,0.7156 1.1401,1.3703 1.6417,1.9011 0.6172,0.6533 1.0128,1.0493 1.131,1.9986 -0.1465,0.3359 0.4708,2.1984 0.7175,2.5226 0.2672,0.3509 1.4274,0.585 1.8484,0.585 0,0.6766 -0.2376,2.0593 -0.6567,2.5713 -0.5221,0.6377 -1.4593,1.5433 -1.4593,2.4617 0,0.8194 -0.3272,1.11 -0.535,1.8402l-0.1541 1.795 0 0z",

                        "Pembrokeshire": "M19.2903 182.793c-0.0405,-0.2158 -0.0122,-0.5516 -0.0122,-0.78 0,-0.1937 -0.0122,-0.3817 -0.0122,-0.5727 0,-0.1122 0.0734,-0.4795 -0.0121,-0.5484 -0.2079,-0.1674 -0.743,-0.047 -0.8878,0.1706 -0.2011,0.3024 -0.0605,0.8924 0.0122,1.2064 0.0512,0.2216 -0.0148,0.4642 0.0608,0.6825 0.1099,0.3176 0.4118,0.3188 0.681,0.2193l0.1703 -0.3777zm41.4928 22.3501c-0.2761,0.2559 -0.5816,0.2182 -0.9364,0.195 -0.1355,-0.0089 -0.3775,-0.1113 -0.5107,-0.1584 -0.2309,-0.0816 -0.3424,-0.0547 -0.5594,0 0.0362,0.1466 0.6178,0.293 0.7053,0.524 0.0672,0.1777 0.1809,0.3568 0.3405,0.4631 0.202,0.1347 0.6012,0.0712 0.8513,0.1218 0.0927,0.0188 0.3205,-0.0071 0.377,-0.0853 0.072,-0.0999 0.0477,-0.4731 -0.0122,-0.5727l-0.2554 -0.4875zm-37.8324 -6.203c-0.1361,0.0682 -0.2265,0.0893 -0.3162,0.2194 -0.0546,0.0793 -0.0549,0.1681 -0.1095,0.2437 -0.1117,0.1549 -0.5017,0.2112 -0.5472,0.4022 -0.0482,0.2028 0.1614,0.2559 0.3162,0.2559 0.1298,0 0.2763,-0.0613 0.3648,-0.1584 0.169,-0.1857 0.1736,-0.2964 0.4378,-0.3778 0.1053,-0.0325 0.1529,-0.0583 0.1946,-0.1584 0.0194,-0.0468 0.0522,-0.2155 -0.0122,-0.2316l-0.3283 -0.195zm-0.5351 -4.0459c-0.2644,0.1837 -1.1026,-0.5655 -1.3012,-0.2437 -0.0987,0.1601 -0.2191,0.3082 -0.4013,0.3778 -0.4146,0.1586 -0.0503,0.5016 0.2067,0.5727 0.2856,0.0789 0.4475,0.107 0.6081,0.3534 0.2942,0.4511 0.3678,-0.278 0.6688,-0.3899 0.3183,-0.1182 0.6526,0.1687 0.9364,0.0975 0.0646,-0.3232 -0.351,-0.4141 -0.4135,-0.6337l-0.304 -0.1341zm40.7321 0.9374c-1.1923,0.3972 -2.3367,1.1058 -2.8024,2.0605 -0.7352,1.5075 1.1492,1.5529 -0.2797,2.8882 -0.2739,0.2559 -0.3345,1.3775 -0.0243,1.6086 0,0.2363 -0.6762,0.7206 -0.8756,0.8044 -0.6267,0.501 -0.3743,1.4789 -1.5809,1.0358 -0.6626,-0.2434 -1.4699,-0.1921 -1.8849,0.4509 -1.2292,1.9047 -2.1968,0.5991 -3.7821,0.2681 -0.5233,-0.1093 -2.3352,-0.2486 -2.6632,0.1584 -0.2288,0.2841 -0.6615,0.968 -0.9728,1.109 -1.4181,0.6422 -1.3738,1.2595 -1.0702,2.4739 -0.2107,-0.1268 -0.6894,-0.2028 -0.9364,-0.1828 -0.4375,0.2196 -0.8914,1.3216 -1.0458,1.2918 -0.3927,-0.0757 -1.7427,-0.1064 -1.9214,-0.3413 -0.3097,-0.4068 -0.647,-0.3831 -1.0702,-0.5605 -0.642,-0.269 -0.6496,-0.7615 -1.5201,-0.4509 -1.1531,0.4116 -1.2952,-0.2875 -2.3349,-0.6337 -0.9869,-0.3285 -2.2086,-0.2653 -1.8606,-1.6574 0.4504,0 0.9968,0.0638 0.7783,-0.7434 -0.1652,-0.6101 -0.4595,-1.0885 -0.7905,-1.6452 -0.5098,-0.6562 -1.3275,-0.8462 -2.1281,-0.9871 -1.0481,-0.1846 -1.0908,-0.8155 -1.6052,-1.5111 -0.6284,-0.85 2.4221,-1.3275 2.5416,-0.8165l0.231 0.9871c0.077,0.3294 0.9558,-0.0853 1.3012,-0.0853 0.3263,0 1.0426,0.4967 0.827,-0.2559 -0.1068,-0.3732 -0.7694,-0.853 -0.4378,-1.0237 0.5466,-0.2813 4.5006,0.3702 4.6698,0.6093 0.1552,0.2195 0.1204,0.7678 0.3526,0.7678 0.136,0 0.9945,-0.138 1.0094,-0.1828l0.0243 0c0,-0.1827 -0.6665,-0.6997 -0.8269,-0.78 -0.2625,-0.1313 0.5958,-0.5305 0.8269,-0.6946 0.7055,-0.5008 1.5238,-1.0115 2.3957,-1.0115l0 -0.0243c-0.3823,0 -0.7941,-0.2194 -1.1796,-0.2194 -0.5308,0 -0.9267,0.5885 -1.4228,0.2803 -0.3068,-0.1907 -0.7195,0.0205 -0.9972,0.2072 -0.5043,0.3389 -1.2508,0.2912 -1.7998,0.0853 -0.7467,-0.2799 -1.3476,-0.7556 -2.1647,-0.7556 -1.2745,0 -1.9545,0.3439 -3.2348,0.0244 -0.5007,-0.3593 -0.4914,-0.9505 -0.7783,-1.4502 -0.1627,0 -0.7827,0.731 -1.0336,0.9261 -0.729,0.5666 -0.4242,-0.372 -1.0702,-0.2193 -0.3756,0.0888 -0.7324,0.3853 -1.1188,0.4387 -0.4295,0.0593 -1.0894,-0.5245 -1.1188,-0.4875 -0.3016,0.3782 0.3756,1.2317 0.5108,1.633 0.3028,0.8989 -0.2367,1.0559 -0.7054,1.7549 -0.4254,0.6346 -1.1723,-1.3439 -1.0823,-1.8889 0.1639,-0.9928 -0.3204,-0.8464 -1.0823,-1.1821 -0.5404,-0.2382 -0.3828,-1.1949 -1.3742,-1.0359 -0.7539,0.121 -1.2157,-0.8064 -1.8241,-1.243 0,-0.4681 2.0893,-0.1051 2.4322,-0.0122 1.2291,0.333 0.5753,-2.1326 1.3863,-2.1326 0.7581,0 1.5834,-0.9807 1.9579,-1.5965 1.3406,-0.8925 2.9165,1.2387 3.4902,-0.3899 0.3505,-0.9953 0.3637,-2.6443 0.2432,-3.7047 -0.1106,-0.9724 -0.6212,-1.8564 -0.7418,-2.7786 -0.0665,-0.7969 -0.7721,-2.0606 -1.508,-2.3885 -0.8154,-0.3632 -2.2761,0.0355 -2.8578,-0.4875 -0.4939,-0.4442 -1.3604,-0.0163 -1.8849,-0.3169 -1.0502,-0.6018 -1.8256,-0.4906 -3.0159,-0.2193 -0.4258,0.0971 -3.2382,1.5089 -3.4902,1.109 -0.1788,-0.2836 0.2166,-0.99 0.2433,-1.3284 0.114,-0.4302 -0.289,-1.0583 -0.073,-1.1943 0.7032,-0.4426 0.96,-0.2676 0.9121,-1.2552 -0.0223,-0.4618 -0.8756,-0.6761 -0.8756,-0.7434 0.6107,-0.1514 1.1586,-0.8234 1.8241,-0.9261 0.9376,-0.1446 1.8753,-0.1703 2.6024,-0.8653 0.285,-0.2723 0.6829,-0.8612 0.9851,-1.0358 0.2055,-0.1186 0.5437,-0.0031 0.7904,-0.1219 0.58,-0.2791 1.1441,-1.7619 1.5444,-1.8767 0.3429,-0.0984 0.7516,0.2055 1.1553,0.0487 1.8738,0 1.3872,-0.2998 2.3957,-1.3892 0.3411,-0.3686 2.0906,0.6376 2.4444,-0.2316 0.3406,-0.8371 0.757,-0.1535 0.9363,-0.5606 0.1019,-0.2312 -0.0622,-0.6574 -0.0486,-0.9262 0.0126,-0.2476 0.2033,-0.6259 0.0973,-0.8165 -0.1061,-0.191 -0.7231,-0.5999 -0.6202,-0.8165 0.3419,-0.719 2.0295,-0.3818 0.754,-1.6573 -0.5779,-0.5779 -0.6711,-0.4487 0.0364,-1.0968 0.5449,-0.499 0.604,-0.8618 1.3499,-0.9018 0.5311,-0.0285 1.3297,0.5615 2.0917,0.4996 0.7844,0.1573 1.556,0.1341 2.347,0.1341 0.4379,0 0.3244,0.7256 0.4013,1.0358 0.053,0.0133 0.1663,0.0182 0.2067,0.0488 -0.0874,0.3557 -0.8026,0.9576 -0.8026,1.1577 0.9871,0.329 1.8756,0.1485 2.9065,-0.195 0.6667,-0.2222 2.5844,-1.1032 2.3592,-2.0229 -0.1196,-0.4882 -0.2413,-1.1399 0.6567,-0.8287 0.5953,0.2062 0.6522,1.0934 1.3741,1.3161 0.7683,0.2369 2.7484,-0.507 2.7484,-1.4624 -0.8248,-0.207 -0.6664,-0.2723 -0.5716,-1.0602 0.7013,-0.9355 1.4579,-0.9492 2.5295,-1.1943 0.9671,-0.2213 1.2073,-0.5525 1.7876,-1.2796 0.7699,-0.9649 1.934,-2.204 2.262,-3.4 0.2016,-0.7349 0.7661,-0.9977 0.7661,-1.8889l0.0122 -0.0122c0.1179,-0.0297 0.2814,0.1994 0.3769,0.2803 0.1205,0.1927 0.5195,0.5023 0.9539,0.7414l0 0 -0.4917 1.0256c0.0376,0.3883 0.3168,0.8896 0.7661,0.8896 0.1524,0 0.2835,-0.095 0.3891,-0.1949 0.1295,-0.1227 0.3863,-0.1657 0.5594,-0.1828l0.3071 0.0356 0.1728 0.4245c-0.2118,0.3666 -1.1599,0.4979 -1.55,0.7585 -0.2972,0.1984 -1.357,0.1235 -0.7053,0.4753 0.4105,0.2215 0.7128,0.3263 1.1674,0.39 0.2596,0.0363 0.6549,0.0298 0.8269,0.2559 0.8448,1.1098 1.1537,0.1686 1.6539,-0.6337l0.3551 -0.5714c0.1111,0.0232 0.2229,0.0572 0.3377,0.1083 0.6531,0.2911 0.2474,0.9631 0.8026,1.2918 1.1488,0.6803 2.6428,0.0374 3.7213,1.2674 0.4993,0.5695 0.799,0.879 1.3039,0.9621l0 0 0.0466 0.7315c0.3146,1.1836 0.4044,1.2198 1.3985,1.9133 0.7591,0.5297 0.5522,1.4545 1.0458,2.1692 0.3396,0.4919 0.896,0.4312 1.3985,0.5605 0.3269,0.084 0.0317,1.7811 0.073,2.1692 0.1172,1.1018 -1.4366,0.5798 -1.9944,0.6337 -0.6108,0.0591 -1.0278,0.5666 -1.5687,0.7677 -0.4665,0.3642 -1.022,0.6651 -1.2404,1.2674 -0.1533,0.4226 -0.5,1.0778 -0.9972,1.1821 -1.1786,0.2472 -0.8328,-1.381 -1.8484,-0.5728l-1.2404 0.9871c-0.2566,0.2042 -0.3062,0.7638 -0.6202,0.8409 -0.5114,0.1255 -2.0277,-0.7102 -2.189,-1.1943 -0.0223,-0.0056 -0.0188,-0.0021 -0.0243,-0.0244l-0.0121 -0.0121c-0.0246,0 -0.0182,-0.0065 -0.0244,0.0121 -0.1317,0 -1.0557,0.7752 -1.4593,0.8531 -0.8833,0.1704 -1.0038,0.9014 -1.6781,1.1333 -0.4705,0.5571 -0.0178,0.7722 -0.7905,1.1333 -0.4817,0.2252 -0.3819,0.6403 -0.7661,0.9262 -0.3295,0.2451 -0.2311,0.3034 -0.2311,0.6703 0,0.2574 -0.3529,0.7294 -0.1824,0.853 0.2915,0.2115 1.0374,0.1916 1.3863,0.1219 0.9054,-0.181 0.399,1.0921 0.5108,1.6817 0.0543,0.2868 0.4743,0.6787 0.4743,0.853 -0.5139,0 -1.1334,-0.034 -1.6174,0.0975 -0.3741,0.1017 -1.3107,1.0485 -1.5809,0.4753 -0.1304,-0.2765 0.1596,-0.5815 0.0851,-0.8774 -0.5482,0 -1.5826,1.3502 -1.3863,1.8645 0.3618,0.9483 1.6562,0.1 2.1641,-0.0482 0.6907,0.2595 0.1954,0.9872 0.5473,0.9872 0.5497,0 1.0715,-0.5845 1.4836,-0.4875 0.4405,0.1038 0.7878,0.486 1.2891,0.3168 0.4032,-0.1362 0.8557,-0.9473 1.1796,-0.853 0.6925,0.2018 1.2143,0.5633 1.9822,0.6702 0.2225,0.031 1.1081,1.49 1.4836,1.7671 1.5581,1.1495 -1.0945,1.1775 -1.0945,1.7914 0,0.6868 0.6819,1.097 0.1824,1.7305 -0.8642,1.0963 0.8512,0.9993 0.9243,1.2187l0.0243 0c0,0.5519 -0.2849,0.969 -0.4743,1.4624 -0.139,0.3624 0.1392,1.0949 -0.1216,1.4867l-0.0919 1.3883 0 0z",

                        "Carmarthenshire": "M97.5576 203.547l-0.0122 -0.0122c-0.8717,0 -1.8503,0.6507 -2.7362,0.3656 -1.1326,-0.3644 -1.4555,-1.4444 -2.2133,-2.2423 -1.6552,-1.743 -6.1502,1.799 -6.7857,1.2308l-3.3929 -3.0345c-0.7973,-0.8974 -1.8971,-1.8333 -1.8971,-3.1563 0,-1.2256 1.2701,-0.9209 0.1824,-1.8036 -0.5787,-0.4695 -0.7269,-0.7598 -0.4378,-1.4867 0.3964,-0.9969 0.4864,-1.4483 0.4864,-2.4861 -0.1158,0.039 -0.247,0.8402 -0.3648,1.0115 -0.198,0.2881 -0.5847,0.4889 -0.8634,0.6946 -1.504,1.1096 -1.2415,0.4033 -2.7848,0.1219 -0.3904,-0.0711 0.1058,0.7755 0.1459,0.8409 0.1544,0.2521 0.5047,0.4463 0.7175,0.6702 0.2697,0.2836 -1.577,1.2658 -1.9336,1.4137 -1.1379,0.4723 -3.4104,-0.1231 -4.5846,-0.39 -2.0188,-0.5061 -3.8712,0.1828 -5.8737,0.1828 -0.6139,0 -1.3466,0.1263 -2.062,0.3646l0 0 0.0919 -1.3883c0.2608,-0.3918 -0.0174,-1.1243 0.1216,-1.4867 0.1894,-0.4934 0.4743,-0.9105 0.4743,-1.4624l-0.0243 0c-0.0731,-0.2194 -1.7885,-0.1224 -0.9243,-1.2187 0.4995,-0.6335 -0.1824,-1.0437 -0.1824,-1.7305 0,-0.6139 2.6526,-0.6419 1.0945,-1.7914 -0.3755,-0.2771 -1.2611,-1.7361 -1.4836,-1.7671 -0.7679,-0.1069 -1.2897,-0.4684 -1.9822,-0.6702 -0.3239,-0.0943 -0.7764,0.7168 -1.1796,0.853 -0.5013,0.1692 -0.8486,-0.213 -1.2891,-0.3168 -0.4121,-0.097 -0.9339,0.4875 -1.4836,0.4875 -0.3519,0 0.1434,-0.7277 -0.5473,-0.9872 -0.5079,0.1482 -1.8023,0.9965 -2.1641,0.0482 -0.1963,-0.5143 0.8381,-1.8645 1.3863,-1.8645 0.0745,0.2959 -0.2155,0.6009 -0.0851,0.8774 0.2702,0.5732 1.2068,-0.3736 1.5809,-0.4753 0.484,-0.1315 1.1035,-0.0975 1.6174,-0.0975 0,-0.1743 -0.42,-0.5662 -0.4743,-0.853 -0.1118,-0.5896 0.3946,-1.8627 -0.5108,-1.6817 -0.3489,0.0697 -1.0948,0.0896 -1.3863,-0.1219 -0.1705,-0.1236 0.1824,-0.5956 0.1824,-0.853 0,-0.3669 -0.0984,-0.4252 0.2311,-0.6703 0.3842,-0.2859 0.2844,-0.701 0.7661,-0.9262 0.7727,-0.3611 0.32,-0.5762 0.7905,-1.1333 0.6743,-0.2319 0.7948,-0.9629 1.6781,-1.1333 0.4036,-0.0779 1.3276,-0.8531 1.4593,-0.8531 0.0062,-0.0186 -0.0002,-0.0121 0.0244,-0.0121l0.0121 0.0121c0.0055,0.0223 0.002,0.0188 0.0243,0.0244 0.1613,0.4841 1.6776,1.3198 2.189,1.1943 0.314,-0.0771 0.3636,-0.6367 0.6202,-0.8409l1.2404 -0.9871c1.0156,-0.8082 0.6698,0.82 1.8484,0.5728 0.4972,-0.1043 0.8439,-0.7595 0.9972,-1.1821 0.2184,-0.6023 0.7739,-0.9032 1.2404,-1.2674 0.5409,-0.2011 0.9579,-0.7086 1.5687,-0.7677 0.5578,-0.0539 2.1116,0.4681 1.9944,-0.6337 -0.0413,-0.3881 0.2539,-2.0852 -0.073,-2.1692 -0.5025,-0.1293 -1.0589,-0.0686 -1.3985,-0.5605 -0.4936,-0.7147 -0.2867,-1.6395 -1.0458,-2.1692 -0.9941,-0.6935 -1.0839,-0.7297 -1.3985,-1.9133l-0.0466 -0.7315 0 0c0.2464,0.0406 0.5422,0.0273 0.9337,-0.036 0.681,-0.11 1.388,0.6456 1.8971,0.2925 1.0275,-0.7129 1.8041,0.4387 2.8457,0.4387 0.6403,0 1.2266,-0.3732 1.9214,-0.3412 0.7363,0.0339 1.4161,0.4169 2.1647,0.39 0.3177,-0.0114 0.8884,0.0653 1.2647,0.3168 0.7524,0.5028 0.8755,1.4739 2.3106,0.1463 0.5961,-0.5514 1.6187,-1.1824 2.3592,-1.4624 1.284,-0.4856 2.1156,1.5781 3.7699,1.1699 1.391,-0.3432 1.698,-2.1692 2.9673,-2.1692 1.5577,0 3.4552,-2.0146 4.7671,-2.9248 1.5712,-1.0901 4.2482,-1.7978 5.3995,-3.1441l0.8999 1.2429c0.866,0.0748 0.7703,0.5115 1.5566,-0.3046 0.7596,-0.7882 1.5691,-1.0175 2.2984,-1.8036 0.3464,-0.3735 1.4452,-1.7248 1.9092,-1.7914 0.3745,0.749 1.9806,2.0027 2.7119,1.3162l1.9214 -1.8037c0.304,-0.2854 1.1443,0.592 1.4472,0.7434 0.4678,0.2679 0.8647,0.4685 1.289,0.8043 0.2543,0.2013 0.3441,0.5152 0.6081,0.6947 0.4025,0.2738 0.8726,0.4702 1.2769,0.7312 0.244,0.1574 0.4278,0.5061 0.6567,0.7068l0.5757 0.3249c0.4697,-0.7692 1.2586,-1.6081 1.6565,-2.4555l0 0 1.0755 0.8023c0.6906,0.3813 1.0434,0.2949 1.0945,1.1942 0.0267,0.4714 -0.4656,0.6396 -0.6081,1.0115 -0.0665,0.1738 0.1698,0.7632 0.2068,0.9871 0.0786,0.4764 1.3215,0.6551 1.7511,1.0603 0.3284,0.3096 1.2877,0.4265 1.739,0.4265l0.0122 0.0122c0,0.3434 -0.6764,0.8269 -0.7418,1.2552 -0.0831,0.5449 0.6155,0.5931 0.8512,0.9262 0.1735,0.2454 0.2306,0.5601 0.4257,0.8165 0.1831,0.2405 0.9633,0.5846 0.7175,0.9018l-0.8026 1.0358c-0.0906,0.3131 -0.7905,0.6499 -0.7905,0.9018 1.2817,0.2572 -0.4609,1.9705 -0.7783,2.4983l-0.5351 0.8896c-0.2268,0.3771 -0.055,0.6971 -0.1702,1.0724 -0.2308,0.7515 -0.779,0.7272 -0.5716,1.7183 0.1624,0.7766 0.0064,1.176 -0.7175,1.499 -0.9713,0.4333 -0.1305,1.1436 -0.1824,1.8523 -0.139,0.4433 -0.2209,0.7756 -0.4378,1.1943 -0.4288,0.828 0.5229,0.6305 0.5229,1.5233 0,0.5524 0.1606,0.9293 0.2068,1.438 0.0545,0.6006 -0.7132,1.5906 -1.0702,2.0596 -0.6844,0.8993 -1.6924,1.4051 -2.493,2.2057 -0.3221,0.4845 -0.3713,0.9558 -0.5958,1.4624 -0.1933,0.4364 -0.0688,0.8879 -0.1581,1.3284 -0.0974,0.48 -0.5606,1.1911 -0.8635,1.5964 -0.3714,0.4967 -0.7384,1.0436 -1.0215,1.6086l0 0 -0.4013 -0.8165c-0.5005,-0.5643 -0.7017,-0.8731 -1.5444,-0.9262 -0.89,-0.056 -1.2786,-0.1704 -2.1525,0.1828 -0.6209,0.251 -0.7872,0.195 -1.4106,0.195 0,0.3157 0.3865,1.1052 0.5837,1.3649 0.3319,0.4368 0.2137,0.9271 0.231,1.4624 0.0121,0.3774 0.1512,0.8531 -0.3526,0.8531 -0.3947,0 -0.9269,0.0292 -1.2769,-0.1463 -0.8114,-0.4068 -0.6956,-0.3706 -1.5201,-0.0244l0 0c-0.5308,0.0998 -0.7511,0.2146 -1.2039,0.4997 -0.4242,0.2672 -0.9119,0.7382 -1.4715,0.4875 -0.251,-0.1125 -0.7418,-0.3222 -0.9121,-0.5241 -0.1454,-0.1725 -0.7084,-0.7731 -0.9242,-0.719 -0.0541,0.4329 -0.1352,1.1671 -0.3162,1.5599 -0.3073,0.5316 -0.8502,0.8789 -1.2282,1.3527 -0.3404,0.4265 -0.4517,0.9732 -1.0094,1.2309 -0.9904,0.4575 0.2649,2.3698 -0.7661,3.205 -0.5757,0.4665 -0.5575,1.2108 -0.9486,1.7305 -0.161,0.2141 -0.8634,0.3851 -0.8634,0.4387 0,0.3869 0.3982,0.8459 0.6445,1.109 0.3194,0.341 -0.468,0.7952 -0.7053,0.914l-1.0823 0.5606 0.0122 0.0122z",

                        "Powys": "M137.202 76.8065l-0.6081 0.2803c-0.0331,0.3672 -0.321,1.6062 -0.5351,1.9011 -0.4612,0.6349 -0.8309,0.9365 -1.593,0.6093 -0.7868,-0.3379 -2.054,0.4648 -2.493,1.0603 -0.5382,0.7298 -1.0872,-0.0551 -1.7025,0.1462 -0.1858,0.0607 -0.4701,1.389 -0.5594,1.633 -0.3095,0.8461 -1.1851,1.4243 -0.6446,2.3398 0.6464,1.0947 0.589,1.4279 0.8878,2.6201 -0.0828,0.9655 0.6526,1.8336 0.2067,2.7298 -0.3117,0.6263 -0.7245,1.1863 -0.8269,1.8889 -0.0659,0.4519 0.0905,1.1396 -0.2432,1.4746 -0.241,0.2418 -0.5976,0.3948 -0.8635,0.6459 -0.251,0.2372 -0.6548,0.0218 -0.9485,0.134 -0.485,0.1852 -0.7547,0.646 -1.2526,0.7678 -0.4626,0.1131 -1.2271,-0.1529 -1.6539,-0.3291 -0.9043,0.1556 -1.0113,1.2744 -1.3863,1.9012 -0.6035,1.0084 -0.2558,-0.2957 -1.0701,-0.195 -0.506,0.0626 -1.1368,-0.4474 -1.3621,-0.3534 -0.5179,0.2159 -0.6492,0.8959 -1.289,1.1089 -0.3075,0.1023 -1.2444,0.1155 -1.5566,0.0366 -0.2296,-0.0581 -1.7409,-1.0779 -1.9093,-0.2681 -0.1961,0.9435 -2.4232,2.4555 -1.5809,3.5463 0.5767,0.7469 0.2311,0.2669 -0.2553,1.243 -0.1933,0.3881 -0.2804,1.7294 -0.1338,2.1205 0.1459,0.3384 0.5204,0.5362 -0.073,0.5362 -0.7759,0 -0.5535,0.4084 -0.9972,0.8043 -0.1417,0.1265 -0.4269,0.1 -0.4986,0.2315 -0.2167,0.3969 -0.1959,0.8023 -0.6688,1.109 -0.5477,0.3551 -1.1612,0.1868 -1.739,0.4997 -0.5061,0.2742 -1.1675,0.6486 -1.1675,1.3283l0.1703 0.6093 0 0c1.6161,-0.0705 3.8436,-0.7101 5.2413,0.4753 0.8853,0.7507 0.1883,3.1843 0.1095,4.1434 0.1325,0.5318 0.1834,1.0464 0.4864,1.5112 0.3604,0.5526 0.5902,1.2519 0.9729,1.7548 0.397,0.5215 0.8325,-0.1829 1.3863,-0.3046 0.4037,-0.0886 0.9862,-0.0281 1.2769,-0.3778 0.7173,-0.8625 1.5611,-2.0232 2.8943,-1.694 0.0841,0.342 -0.1997,0.645 -0.304,0.9628 -0.2394,0.7296 0.0219,1.6716 -0.5838,2.2789 -0.2251,0.2256 -1.3203,0.6117 -1.3133,0.7433 0.0248,0.4646 0.1702,0.7679 0,1.2796 -0.7676,2.308 1.2373,1.4865 1.9579,2.9248 0.1182,0.5423 0.1549,0.8115 0.6445,1.0968 0.4602,0.2683 0.63,0.1201 0.7418,0.7068 0.1397,0.7336 0.78,4.5611 1.3377,4.5822 0.8749,0.033 1.1512,0.4857 1.7025,1.1089 0.8384,0.9475 0.4111,0.8904 -0.5715,1.3527 -0.2548,0.7429 -1.434,-0.1227 -1.8728,0.2072 -0.584,0.4389 -1.0724,1.1027 -1.6782,1.5477 -0.5683,0.4176 -1.1512,0.9804 -0.3527,1.438 0.8084,0.4634 0.4568,0.5489 0.2068,1.2918 -0.2029,0.6033 0.8188,1.5371 1.1188,2.0717 0.0812,0.1446 0.8527,0.8769 0.3283,0.9018 -0.3949,0.0188 -1.4198,0.2661 -1.739,0.4631 -0.1444,0.089 -0.2841,0.6508 -0.4864,0.8531 -0.4386,0.4386 -0.3927,0.5725 -0.2068,1.1333l0.3164 0.8409c-0.1595,1.9124 0.0589,3.919 -0.1703,5.8739 -0.0829,0.7078 -0.3176,1.4106 -0.2432,2.1448 0.0971,0.9587 0.1947,1.9175 0.2918,2.8761 0.0285,0.282 -0.1316,0.8251 -0.2365,1.111l0 0 1.0755 0.8023c0.6906,0.3813 1.0434,0.2949 1.0945,1.1942 0.0267,0.4714 -0.4656,0.6396 -0.6081,1.0115 -0.0665,0.1738 0.1698,0.7632 0.2068,0.9871 0.0786,0.4764 1.3215,0.6551 1.7511,1.0603 0.3284,0.3096 1.2877,0.4265 1.739,0.4265l0.0122 0.0122c0,0.3434 -0.6764,0.8269 -0.7418,1.2552 -0.0831,0.5449 0.6155,0.5931 0.8512,0.9262 0.1735,0.2454 0.2306,0.5601 0.4257,0.8165 0.1831,0.2405 0.9633,0.5846 0.7175,0.9018l-0.8026 1.0358c-0.0906,0.3131 -0.7905,0.6499 -0.7905,0.9018 1.2817,0.2572 -0.4609,1.9705 -0.7783,2.4983l-0.5351 0.8896c-0.2268,0.3771 -0.055,0.6971 -0.1702,1.0724 -0.2308,0.7515 -0.779,0.7272 -0.5716,1.7183 0.1624,0.7766 0.0064,1.176 -0.7175,1.499 -0.9713,0.4333 -0.1305,1.1436 -0.1824,1.8523 -0.139,0.4433 -0.2209,0.7756 -0.4378,1.1943 -0.4288,0.828 0.5229,0.6305 0.5229,1.5233 0,0.5524 0.1606,0.9293 0.2068,1.438 0.0545,0.6006 -0.7132,1.5906 -1.0702,2.0596 -0.6844,0.8993 -1.6924,1.4051 -2.493,2.2057 -0.3221,0.4845 -0.3713,0.9558 -0.5958,1.4624 -0.1933,0.4364 -0.0688,0.8879 -0.1581,1.3284 -0.0974,0.48 -0.5606,1.1911 -0.8635,1.5964 -0.3714,0.4967 -0.7384,1.0436 -1.0215,1.6086l0 0c-0.0271,0.4512 1.0425,1.2433 1.4229,1.4015 0.8871,0.3688 0.4893,1.6241 1.216,2.352 0.6761,0.6771 1.5445,0.5437 2.0309,-0.2803 0.4825,-0.8176 0.0339,-1.4763 1.1796,-1.8036 0.8753,-0.25 2.5248,-1.0359 3.3442,-1.0359 1.1773,0 1.9656,0.9215 3.0524,1.1943 0.3128,-0.0153 0.7888,0.0278 1.0945,0.0975 0.2188,0.0498 0.3094,0.0454 0.3648,0.2681 0.0355,0.1424 0.0335,0.2834 0.0608,0.4265 0.0285,0.1499 0.1186,0.4287 0.1824,0.5606 0.1108,0.2294 0.1106,0.4196 0.1703,0.6581l0 0c1.1631,-0.5633 1.3686,-0.6407 1.7633,-1.8646 0.2658,-0.8245 0.3494,-0.6642 1.1188,-0.5362 0.3646,0.0607 0.8915,0.1374 0.5837,-0.4021 -0.2699,-0.4733 1.0781,-0.7564 1.3985,-1.1943 0.4997,-0.6827 1.1559,-0.8171 1.6904,-1.3527 0.5383,-0.2627 0.9334,-0.2557 1.0458,-0.9628 0.0997,-0.6276 0.0974,-1.4014 0.9486,-1.4014 0.5654,0 0.5265,0.8166 0.8999,1.0846l0 0c0.469,0.0403 1.0034,-0.5365 1.2039,-0.9384 0.0672,-0.1346 0.4039,-0.9875 0.4864,-0.853 0.1802,0.2935 0.4796,0.4688 0.7662,0.6459 0.2846,0.176 -0.3078,1.2124 0.3648,1.3161 0.6325,0.0976 2.3519,0.6368 2.493,1.3283 0.2857,1.3993 0.3239,1.3284 1.6538,1.3284l0.4865 0.0122 0 0 1.3742 -0.7922 0 0c0,-0.9722 0.3909,-1.2462 0.9485,-1.9498 0.4166,-0.5255 0.552,-1.2064 1.2039,-0.6459 1.0797,0.9285 2.1808,1.4522 3.624,1.2308 1.1943,-0.1833 2.2873,-0.524 3.5145,-0.524l0.7904 -0.0975 0 0c0.4031,-0.4538 1.6215,-2.3708 2.189,-2.2789 0.2006,0.0324 0.9008,0.7425 0.9485,0.5484 0.2306,-0.0569 0.3734,-1.2577 0.8756,-1.5477 0.4741,-0.2739 0.9362,-1.2816 1.3499,-1.7304 0.3968,-0.4303 -0.3406,-0.9358 -0.3406,-1.304 0.4856,-0.2086 2.2107,-0.5598 2.0552,-1.0968 0.3246,-1.0539 0.0162,-1.6854 -0.6323,-2.4982 -0.4768,-0.5975 -1.8097,-1.5249 -1.9823,-2.2302 -0.1326,-0.5416 -0.0309,-1.0749 -0.2188,-1.6086 -0.2454,-0.6966 0.1853,-1.4825 -0.5594,-1.9499 -0.0248,-0.1983 0.2646,-0.3673 0.3526,-0.5605l0.9152 -0.9817 0 0c-0.2123,-0.2505 -0.4061,-0.4998 -0.5625,-0.7366 -0.2457,-0.3719 -0.3384,-1.1665 -0.4621,-1.6087 -0.1535,-0.4588 -0.3679,-1.0415 -0.2919,-1.5355 0.0738,-0.4791 0.3443,-0.8882 0.4013,-1.3527 0.1522,-1.2411 -0.489,-1.7428 -1.3255,-2.486 -0.4998,-0.4442 -0.9024,-0.9878 -1.1918,-1.6087 -0.2517,-0.5398 0.3633,-1.6575 0.1946,-2.3763 0.0931,-0.7448 1.1405,-1.3781 0.9607,-2.1327 -0.1826,-0.7667 -2.1204,-1.1185 -1.9579,-1.6208 0.1298,-0.4011 1.3239,-0.5386 1.739,-0.6824 0.4248,-0.1471 1.7998,-0.6839 1.7998,-1.2309 -0.644,0 -1.4849,-0.3913 -2.0065,-0.7677 -1.013,-0.7308 -0.4112,-0.845 0.3891,-1.5965 0.5697,-0.5348 0.5229,-0.9412 0.5229,-1.6817 0,-1.2658 0.9429,-2.2582 1.6053,-3.2538 0.7332,-1.1022 -0.257,-1.722 1.5079,-1.7915 1.0172,-0.0401 -0.1585,-0.8537 -0.1338,-1.2064 0.0128,-0.182 0.811,-0.2372 0.9729,-0.2681 0.9386,-0.1792 2.1849,-1.1933 3.1254,-0.9506 0.6889,0.1778 1.1566,0.3136 1.6538,-0.2803 0.078,-0.0933 0.4721,-0.4154 0.45,-0.4265 0.0461,-0.0232 -0.3262,-0.0748 -0.3527,-0.0853 -0.1477,-0.0585 -0.3626,-0.0906 -0.5229,-0.0975l-1.1188 -0.0487c-1.1043,-0.048 -1.6479,-0.2296 -1.7268,-1.4259 0,-0.6753 0.8732,-0.8695 0.7175,-1.7305 -0.1152,-0.6366 -0.7551,-1.207 -0.0973,-1.7914 0.9229,-0.8201 2.4335,-1.191 2.7848,-2.5592 0.183,-0.7126 -1.2406,-1.0082 -1.7268,-0.9871 -0.3606,0.0156 -1.0669,0.2923 -1.3621,0.1341 -0.8147,0.1534 -1.9542,0.8165 -2.6632,0.8165 -0.5552,0 -1.3665,-1.09 -1.9214,-1.3893 -1.3237,-0.7142 -2.1763,-2.6747 -3.5996,-3.1441 -0.4183,-0.138 -1.1312,-0.2449 -1.3499,-0.6581 -0.2485,-0.4697 -0.4833,-0.7686 -0.8026,-1.2065 -1.2348,-1.3898 -3.022,-1.0269 -3.5266,-3.1807 -0.4058,-1.7324 0.3886,-2.705 1.5809,-3.8997 0.3871,-0.3878 0.2883,-0.2375 0.8148,-0.1462 1.11,0.1924 2.2042,-0.875 2.8699,-1.6574 0.4821,-0.3005 1.9039,-0.4295 2.5416,-0.5849 0.939,-0.2287 1.7744,-0.3641 2.7484,-0.2559 1.8371,0.204 2.0309,-1.3195 2.0309,-2.7908 0.6225,-0.1543 1.3982,0.8819 2.0551,0.7191 0.1526,-0.6107 -0.3283,-1.5994 -0.3283,-2.2667 -0.0997,-0.8979 -0.1235,-1.4187 0.1216,-2.3155 0.2193,-0.802 -0.8648,-1.1859 -1.2404,-1.6574 -0.2338,0 -1.871,1.6298 -2.2254,1.9011 -0.7435,0.569 -2.1176,0.7685 -2.0674,1.8768 0.0312,0.6879 -0.6713,0.6128 -1.1917,0.853 -0.5529,0.2551 -0.9146,0.1594 -1.0702,-0.4631 0.0155,-0.0206 0.0122,-0.0229 0.0122,-0.0487 0.1201,-0.0809 0.2331,-0.5947 0.3283,-0.6581 0,-1.015 -0.0445,-2.1935 -0.9121,-2.9126 -0.5174,-0.4287 -0.2497,-0.501 -0.2918,-1.0358 -0.0533,-0.6772 -0.1102,-0.524 0.7175,-0.524 0.1701,0 1.5408,-0.6983 1.7025,-0.8287 0.4509,-0.3639 0.2049,-0.6155 0.3526,-1.0725 0.3734,-0.5571 0.6115,-1.3829 0.9608,-1.9864 0.3699,-0.6393 0.4515,-1.3889 -0.0852,-1.962 -0.3253,-0.3475 0.6231,-0.4269 0.8148,-0.5118 0.4616,-0.2044 1.0556,-0.604 1.1796,-1.1334 0.1121,-0.479 0.413,-1.8989 0.3405,-2.352 -0.0718,-0.4481 -0.3971,-0.7679 -0.5351,-1.1943 0.492,-0.3074 1.4338,-1.1709 1.6053,-1.7548 0.136,-0.4627 -0.0531,-1.0749 0.1337,-1.4746 0.209,-0.4475 2.6713,-0.1954 3.0403,0.0366 0.1858,0.1167 0.5009,0.3387 0.681,0.134 0.3622,-0.4114 -0.7175,-0.8779 -0.7175,-1.1212 -0.112,-0.0373 -0.3566,-0.3979 -0.4383,-0.5067l-0.6546 -0.2995 -0.9841 -0.9278 -0.6224 -0.1774 -0.6692 -1.3424c-0.6498,-1.1413 -2.3139,-0.9749 -3.3685,-0.9749 -0.494,0 -0.3346,-2.061 -0.45,-2.5226 -0.711,0 -1.3338,0.5488 -2.0065,0.719 -0.9002,0.2279 -0.8985,-0.4014 -1.6296,-0.5728 -0.4124,-0.0967 -0.5585,-0.2943 -0.6932,-0.6946 -0.1817,-0.5404 0.1981,-1.0899 0.0973,-1.4502 -0.1633,-0.584 -0.7251,0.0104 -0.377,-1.0724 0.1711,-0.5984 0.6446,-1.5054 0.6446,-2.1205 0,-0.5418 -1.1974,-0.8075 -0.0365,-1.1943 0.4965,-0.1655 0.8119,-0.5032 1.2404,-0.7433 0.736,-0.4123 0.6358,-0.1834 0.0122,-0.8897 -0.2989,-0.3384 -1.3169,-1.2123 -0.8513,-1.6451 0.154,-0.1431 0.3517,-0.5105 0.5067,-0.7159l0 0 -1.2607 -0.8318c-0.406,-0.3648 -0.9935,-0.8645 -1.4958,-0.39 -0.5062,0.4781 -1.2026,0.5185 -1.8606,0.5484 -0.455,0.0206 -0.5781,0.8035 -0.7418,1.1455 -0.2678,0.5598 -1.3573,1.4697 -2.0309,1.4137l-2.2011 -0.1828c-0.9153,-0.076 -0.4864,-0.5331 -1.0093,-0.9506 -0.6659,-0.5315 -1.4068,-0.1693 -2.2133,-0.9384 -0.6936,-0.6613 -1.9773,0.0822 -2.797,-0.329l0 0 -0.2189 0.7556c-0.4364,1.0001 -1.6026,1.4745 -2.6267,1.7305 -1.1205,0.28 -2.6564,0.8311 -3.7577,0.4265l0 0z",

                        "Ceredegion": "M59.0859 156.882c0.4922,0.271 1.03,0.4518 1.2594,0.2701 0.1579,-0.1252 0.2054,-2.1169 0.2919,-2.4617 0.4391,0 0.6297,0.2268 1.1796,0.1218 0.5958,-0.1137 1.1623,-0.4977 1.7512,-0.6946 1.4036,-0.4692 2.5885,-0.073 3.9157,-0.2437 0.4695,-0.0604 1.0789,-0.8778 1.4107,-0.3413 0.4948,0.8003 1.4788,0.8082 2.3957,0.6459 1.1574,-0.129 1.1982,-0.9834 1.739,-1.6939 0.4865,-0.639 1.3089,-0.8759 1.7633,-1.5721 0.2,-0.3066 0.4598,0.2393 0.7662,0.0488 1.9037,-1.1832 3.7665,-3.5762 5.2778,-5.2646 0.1263,-0.141 0.802,-0.282 0.8391,-0.1706 0.2214,0 0.0227,0.8275 0.681,0.7921 0.6073,-0.0326 1.3761,-0.5029 1.8728,-0.8287 1.1235,-0.589 2.0133,-1.2966 2.9186,-2.157 0.9442,-0.8972 0.8189,-0.9202 2.1038,-1.2065 1.6247,-0.3619 2.6851,-2.9805 3.4658,-4.2409 0.2884,-0.4655 0.8008,-0.2232 1.0459,-0.719l0.6688 -1.3527c1.5168,-1.6715 2.1159,-3.643 2.5173,-5.8617 0.1419,-0.7843 0.5894,-1.1875 0.8999,-1.8402 0.4379,-0.9207 0.65,-1.2734 0.8756,-2.2789 0.1981,-0.7913 0.2038,-1.6471 0.3891,-2.4617l0.5351 -2.352c0.2981,-1.3107 1.3194,-2.7389 1.2283,-4.0581 0.0936,-1.1408 0.2159,-2.7756 -0.2676,-3.8266 -0.6102,-1.3267 0.8379,-0.1559 1.1796,0.0244 1.3251,0.699 5.667,-2.0537 5.667,-3.4366l0 0 0.8877 0.0609 0.5108 -0.8165 0 0c1.6161,-0.0705 3.8436,-0.7101 5.2413,0.4753 0.8853,0.7507 0.1883,3.1843 0.1095,4.1434 0.1325,0.5318 0.1834,1.0464 0.4864,1.5112 0.3604,0.5526 0.5902,1.2519 0.9729,1.7548 0.397,0.5215 0.8325,-0.1829 1.3863,-0.3046 0.4037,-0.0886 0.9862,-0.0281 1.2769,-0.3778 0.7173,-0.8625 1.5611,-2.0232 2.8943,-1.694 0.0841,0.342 -0.1997,0.645 -0.304,0.9628 -0.2394,0.7296 0.0219,1.6716 -0.5838,2.2789 -0.2251,0.2256 -1.3203,0.6117 -1.3133,0.7433 0.0248,0.4646 0.1702,0.7679 0,1.2796 -0.7676,2.308 1.2373,1.4865 1.9579,2.9248 0.1182,0.5423 0.1549,0.8115 0.6445,1.0968 0.4602,0.2683 0.63,0.1201 0.7418,0.7068 0.1397,0.7336 0.78,4.5611 1.3377,4.5822 0.8749,0.033 1.1512,0.4857 1.7025,1.1089 0.8384,0.9475 0.4111,0.8904 -0.5715,1.3527 -0.2548,0.7429 -1.434,-0.1227 -1.8728,0.2072 -0.584,0.4389 -1.0724,1.1027 -1.6782,1.5477 -0.5683,0.4176 -1.1512,0.9804 -0.3527,1.438 0.8084,0.4634 0.4568,0.5489 0.2068,1.2918 -0.2029,0.6033 0.8188,1.5371 1.1188,2.0717 0.0812,0.1446 0.8527,0.8769 0.3283,0.9018 -0.3949,0.0188 -1.4198,0.2661 -1.739,0.4631 -0.1444,0.089 -0.2841,0.6508 -0.4864,0.8531 -0.4386,0.4386 -0.3927,0.5725 -0.2068,1.1333l0.3164 0.8409c-0.1595,1.9124 0.0589,3.919 -0.1703,5.8739 -0.0829,0.7078 -0.3176,1.4106 -0.2432,2.1448 0.0971,0.9587 0.1947,1.9175 0.2918,2.8761 0.0285,0.282 -0.1316,0.8251 -0.2365,1.111l0 0c-0.3979,0.8474 -1.1868,1.6863 -1.6565,2.4555l-0.5757 -0.3249c-0.2289,-0.2007 -0.4127,-0.5494 -0.6567,-0.7068 -0.4043,-0.261 -0.8744,-0.4574 -1.2769,-0.7312 -0.264,-0.1795 -0.3538,-0.4934 -0.6081,-0.6947 -0.4243,-0.3358 -0.8212,-0.5364 -1.289,-0.8043 -0.3029,-0.1514 -1.1432,-1.0288 -1.4472,-0.7434l-1.9214 1.8037c-0.7313,0.6865 -2.3374,-0.5672 -2.7119,-1.3162 -0.464,0.0666 -1.5628,1.4179 -1.9092,1.7914 -0.7293,0.7861 -1.5388,1.0154 -2.2984,1.8036 -0.7863,0.8161 -0.6906,0.3794 -1.5566,0.3046l-0.8999 -1.2429c-1.1513,1.3463 -3.8283,2.054 -5.3995,3.1441 -1.3119,0.9102 -3.2094,2.9248 -4.7671,2.9248 -1.2693,0 -1.5763,1.826 -2.9673,2.1692 -1.6543,0.4082 -2.4859,-1.6555 -3.7699,-1.1699 -0.7405,0.28 -1.7631,0.911 -2.3592,1.4624 -1.4351,1.3276 -1.5582,0.3565 -2.3106,-0.1463 -0.3763,-0.2515 -0.947,-0.3282 -1.2647,-0.3168 -0.7486,0.0269 -1.4284,-0.3561 -2.1647,-0.39 -0.6948,-0.032 -1.2811,0.3412 -1.9214,0.3412 -1.0416,0 -1.8182,-1.1516 -2.8457,-0.4387 -0.5091,0.3531 -1.2161,-0.4025 -1.8971,-0.2925 -0.3915,0.0633 -0.6873,0.0766 -0.9337,0.036l0 0c-0.5049,-0.0831 -0.8046,-0.3926 -1.3039,-0.9621 -1.0785,-1.23 -2.5725,-0.5871 -3.7213,-1.2674 -0.5552,-0.3287 -0.1495,-1.0007 -0.8026,-1.2918 -0.1148,-0.0511 -0.2266,-0.0851 -0.3377,-0.1083l-0.3551 0.5714c-0.5002,0.8023 -0.8091,1.7435 -1.6539,0.6337 -0.172,-0.2261 -0.5673,-0.2196 -0.8269,-0.2559 -0.4546,-0.0637 -0.7569,-0.1685 -1.1674,-0.39 -0.6517,-0.3518 0.4081,-0.2769 0.7053,-0.4753 0.3901,-0.2606 1.3382,-0.3919 1.55,-0.7585l-0.1728 -0.4245 -0.3071 -0.0356c-0.1731,0.0171 -0.4299,0.0601 -0.5594,0.1828 -0.1056,0.0999 -0.2367,0.1949 -0.3891,0.1949 -0.4493,0 -0.7285,-0.5013 -0.7661,-0.8896l0.4917 -1.0256 0 0z",

                        "Conwy": "M103.909 36.2538l1.0663 0.7514c1.2314,1.326 1.7975,2.1514 3.6726,2.6201 0.149,0.6063 0.196,1.572 -0.2554,2.0961 -0.3366,0.391 -0.9677,0.5628 -1.2039,1.0359 -0.4415,0.8846 -0.3351,1.7537 -0.6081,2.6444 -0.2975,0.971 -1.7763,1.0816 -2.2254,2.0474 0.0193,0.3416 -0.482,0.8774 -0.6324,1.2186 -0.2895,0.6571 0.5837,0.4929 0.5837,0.8165 0,0.0726 -0.3533,0.158 -0.4378,0.2072 -0.4101,0.2387 -1.0378,1.3411 -1.1188,1.7914 -0.067,0.372 0.7459,0.1747 0.8756,0.8287 0.2223,1.12 0.8894,1.2224 1.5688,2.0352 0.6127,0.7328 1.03,1.0707 0.6202,2.0595 -0.1886,0.6808 -0.7278,0.5159 -0.681,1.5477 0.041,0.9033 -0.4581,3.1186 0.535,3.5585 1.8131,0.803 3.7109,-2.1524 5.6184,-0.3534 0.5941,0.5602 -0.5019,1.3253 0.2797,2.1082 0.649,0.6499 2.1738,1.259 2.5173,2.0839 0.1189,0.8136 1.6365,2.819 2.6024,2.4495 0.8483,-0.3244 2.2587,-0.521 2.7605,-1.2796 1.2405,-1.8749 2.639,-2.2006 4.7063,-2.4007 0.7283,-0.0704 0.5062,-1.09 1.4957,-0.9627 0.9395,0.1208 1.3949,-1.0122 2.1647,-1.2674l1.0336 -0.2681c0.4905,-0.1272 1.0774,-0.4533 0.7297,0.3777 -0.4124,0.9854 0.1634,1.855 0.4135,2.8761 0.5087,2.0774 3.1452,0.3696 4.3171,0.7433 0.7501,0.2391 1.6623,0.8908 2.4686,0.4022 0.5809,-0.3521 1.6158,-1.5917 1.9458,-2.1692l0 0 -0.0852 -0.7799c-0.17,-0.2561 -0.1999,-0.6859 -0.2675,-0.9872 -0.0752,-0.3357 -0.226,-0.4183 -0.4256,-0.6702 -0.1976,-0.2492 -0.2824,-0.4771 -0.4135,-0.7678 -0.1868,-0.5635 -1.167,-2.5196 -0.073,-2.6932 0.1393,-0.0221 0.9459,-0.1661 0.8756,-0.3778 -0.118,-0.3549 -0.5367,-0.7323 -0.8026,-0.9993 -0.5232,-0.5251 -0.683,-1.1895 -0.6567,-1.9133 0.0559,-1.5333 -0.6986,-0.2559 -1.5931,-0.2559 -0.0998,-0.2507 -0.1126,-1.2326 -0.3769,-1.2308l-1.7634 0.0122c-1.5062,0.0104 -1.3316,-0.2304 -2.3835,1.0967 -0.6193,0.7815 -1.0689,-1.2236 -1.0215,-1.2552 0.3078,-0.2052 2.5952,-1.531 2.5173,-1.767 -0.1074,-0.325 -0.3583,-0.0974 -0.1581,-0.585 0.2165,-0.7048 0.3226,-0.6012 0.681,-1.1577 0.3235,-0.5025 0.2074,-0.9309 0.7661,-1.3161l3.4294 -2.3642c0.3051,-0.2103 1.1884,-0.6432 1.1066,-0.9262 -0.0901,-0.3113 -0.2822,-0.6316 -0.4134,-0.9262 -0.2776,-0.6229 -0.0038,-1.9669 0.1702,-2.6323 0.1162,-0.2621 0.2954,-1.3207 0.2554,-1.6208 -0.064,-0.4805 -0.5752,-0.6484 -0.9485,-0.9018 -0.8253,-0.5604 -1.6548,-1.8347 -2.6633,-1.633 -0.539,0.1077 -0.6301,-1.212 -0.4256,-1.3771 1.1035,-0.8915 0.0652,-0.8285 0.2067,-1.9742 0.1464,-1.1848 1.3926,-1.9054 1.6539,-2.9004l-0.4782 -1.4584 0 0c-0.1776,-0.0315 -0.3511,-0.03 -0.6406,0.1422 -1.7066,0.6426 -3.8164,2.7153 -5.7399,2.4495 -0.4133,-0.0571 -1.1031,-0.524 -1.3377,-0.524 -0.7159,0 -1.4635,0.2925 -2.2376,0.2925 -1.3802,0 -2.32,-0.2415 -3.551,-0.7434 -0.2245,-0.3953 -0.6547,-0.431 -0.754,-0.9505 -0.0598,-0.3134 0.1517,-0.9748 -0.2553,-0.9993 -0.6777,-0.0408 -1.643,-0.0268 -1.9579,-0.7312 -0.3014,-0.674 -0.5427,-0.4553 -1.131,-0.2194 -0.2852,0.1144 -0.6838,0.2681 -0.9972,0.2681 -1.0362,0 -1.3372,-0.2997 -1.5444,-1.2918 -0.0893,-0.428 -0.6551,-0.2502 -1.0337,-0.2681 -0.2461,-0.0117 -1.6446,-0.3859 -1.7147,-0.3046 -1.2205,1.4135 1.6281,1.681 1.7512,2.6688 0.1554,0.4144 0.4009,1.3036 0.4378,1.7549 0.0501,0.6111 -0.4365,0.2666 -0.8999,0.4143 -0.9517,0.3033 -2.2901,0.6992 -3.101,1.304 -0.8175,0.6096 -1.7024,1.3387 -2.6389,1.7549 -0.4915,0.2185 -1.05,-0.063 -1.5323,0.0731 -1.0397,0.3465 -1.7964,1.1081 -2.6472,1.6737l0 0z",

                        "Denbighshire": "M138.722 63.8522c0.2361,0.2282 0.5556,0.4098 0.7418,0.6581 -0.5243,0.6559 0.2132,1.7265 -0.5229,2.3763 -0.3932,0.3472 -0.86,0.5498 -1.2404,0.914 -0.5179,0.496 -0.6674,0.8781 -0.9486,1.5234 0.0602,0.8228 0.5896,0.9368 1.2891,1.1699 0,0.2513 0.0402,0.5574 0.0851,0.8043 0.0656,0.3609 -0.4707,0.7245 -0.6689,1.0115 -0.6327,0.9166 -0.5806,1.4093 -0.0973,2.3885 0.4807,0.9737 0.3813,1.2581 -0.158,2.1083l0 0c1.1013,0.4046 2.6372,-0.1465 3.7577,-0.4265 1.0241,-0.256 2.1903,-0.7304 2.6267,-1.7305l0.2189 -0.7556 0 0 0.3527 -1.0968c1.2266,-0.3891 0.9485,-0.6237 0.9485,-1.6817 0.5392,-0.387 0.9592,-0.6278 1.4593,-1.1456 0.4283,-0.4436 0.4996,-1.3774 0.7905,-1.6695 0.8767,0 1.842,0.2872 2.724,0.2072 0.7977,-0.0724 1.5629,-0.5508 2.3714,-0.6581 1.1442,-0.152 2.0859,0.6629 3.2348,0.3656l3.7212 -0.9628c0.8925,-0.1187 2.4618,0.1543 2.9672,-0.719 0.1826,-0.3154 0.0652,-0.4499 -0.1094,-0.7555 -0.3077,-0.5388 -0.2021,-0.877 -0.6932,-1.3771 -0.706,-0.7191 -1.9077,-0.371 -2.7483,-0.78 -1.2071,-0.5872 -0.8214,-2.3109 -0.2189,-3.1806 0.2789,-0.1771 0.6188,-0.8302 0.4986,-1.17 -0.169,-0.4775 -1.5089,-0.8479 -1.0215,-1.377 0.6846,-0.7434 0.8848,-1.4312 0.9363,-2.4252l0.1825 -0.6337 0 0 -0.6932 -0.658c-0.2391,-0.6603 -0.3892,-1.2379 -0.3892,-1.9499 0,-0.9084 -0.6757,-0.7517 -1.3741,-0.8287 -1.3709,-0.1511 -1.2575,-3.4899 -1.1188,-4.4968 0.1363,-0.9887 -1.2513,-1.09 -1.9336,-0.6825 -0.8118,0.4847 -3.0279,0.3923 -3.5388,-0.5118 -0.0421,-0.5046 -0.2012,-1.8818 -0.45,-2.2789 -0.3893,-0.6215 -1.3202,-0.8535 -1.7998,-1.5355 -0.3313,-0.4713 0.0243,-0.7807 -0.0973,-1.1455 -0.8033,0 -0.7084,-0.8766 -0.5107,-1.499 0.2502,-0.7879 1.0523,-1.3746 -0.45,-1.5964 -0.8458,-0.1248 -0.7178,-0.3815 -1.2039,-0.9384 -0.133,-0.2126 -0.3336,-0.3589 -0.5108,-0.524 -0.0635,-0.0591 -0.4515,-0.2312 -0.4134,-0.3168 0.1318,-0.2954 0.616,-0.7591 0.8877,-0.9628 1.5148,-1.1361 0.4736,-0.9819 -0.4135,-1.6939 -0.5683,-0.456 -0.5062,-1.0969 -0.6566,-1.7061 -0.318,0 -0.5556,0.4191 -0.9364,0.3412 -0.3362,-0.0687 -0.1609,-0.4311 -0.3892,-0.6459 -1.0839,-1.0202 -0.0729,-0.5842 -0.0729,-1.5842 -1.1311,0 -1.2156,0.6017 -0.8635,-0.9018 0.1276,-0.5448 1.5341,-0.3393 1.6539,-1.3649l0.4007 -1.6597 0 0c-0.5694,0.0632 -1.1224,0.1669 -1.6046,0.4166l-3.247 1.6818c-0.8691,0.4501 -3.3049,0.4798 -3.5631,1.767 -0.1995,0 -0.3402,-0.0446 -0.4782,-0.0691l0 0 0.4782 1.4584c-0.2613,0.995 -1.5075,1.7156 -1.6539,2.9004 -0.1415,1.1457 0.8968,1.0827 -0.2067,1.9742 -0.2045,0.1651 -0.1134,1.4848 0.4256,1.3771 1.0085,-0.2017 1.838,1.0726 2.6633,1.633 0.3733,0.2534 0.8845,0.4213 0.9485,0.9018 0.04,0.3001 -0.1392,1.3587 -0.2554,1.6208 -0.174,0.6654 -0.4478,2.0094 -0.1702,2.6323 0.1312,0.2946 0.3233,0.6149 0.4134,0.9262 0.0818,0.283 -0.8015,0.7159 -1.1066,0.9262l-3.4294 2.3642c-0.5587,0.3852 -0.4426,0.8136 -0.7661,1.3161 -0.3584,0.5565 -0.4645,0.4529 -0.681,1.1577 -0.2002,0.4876 0.0507,0.26 0.1581,0.585 0.0779,0.236 -2.2095,1.5618 -2.5173,1.767 -0.0474,0.0316 0.4022,2.0367 1.0215,1.2552 1.0519,-1.3271 0.8773,-1.0863 2.3835,-1.0967l1.7634 -0.0122c0.2643,-0.0018 0.2771,0.9801 0.3769,1.2308 0.8945,0 1.649,-1.2774 1.5931,0.2559 -0.0263,0.7238 0.1335,1.3882 0.6567,1.9133 0.2659,0.267 0.6846,0.6444 0.8026,0.9993 0.0703,0.2117 -0.7363,0.3557 -0.8756,0.3778 -1.094,0.1736 -0.1138,2.1297 0.073,2.6932 0.1311,0.2907 0.2159,0.5186 0.4135,0.7678 0.1996,0.2519 0.3504,0.3345 0.4256,0.6702 0.0676,0.3013 0.0975,0.7311 0.2675,0.9872l0.0852 0.7799 0 0z",

                        "Wrexham": "M159.416 74.4089l-1.2607 -0.8318c-0.406,-0.3648 -0.9935,-0.8645 -1.4958,-0.39 -0.5062,0.4781 -1.2026,0.5185 -1.8606,0.5484 -0.455,0.0206 -0.5781,0.8035 -0.7418,1.1455 -0.2678,0.5598 -1.3573,1.4697 -2.0309,1.4137l-2.2011 -0.1828c-0.9153,-0.076 -0.4864,-0.5331 -1.0093,-0.9506 -0.6659,-0.5315 -1.4068,-0.1693 -2.2133,-0.9384 -0.6936,-0.6613 -1.9773,0.0822 -2.797,-0.329l0 0 0.3527 -1.0968c1.2266,-0.3891 0.9485,-0.6237 0.9485,-1.6817 0.5392,-0.387 0.9592,-0.6278 1.4593,-1.1456 0.4283,-0.4436 0.4996,-1.3774 0.7905,-1.6695 0.8767,0 1.842,0.2872 2.724,0.2072 0.7977,-0.0724 1.5629,-0.5508 2.3714,-0.6581 1.1442,-0.152 2.0859,0.6629 3.2348,0.3656l3.7212 -0.9628c0.8925,-0.1187 2.4618,0.1543 2.9672,-0.719 0.1826,-0.3154 0.0652,-0.4499 -0.1094,-0.7555 -0.3077,-0.5388 -0.2021,-0.877 -0.6932,-1.3771 -0.706,-0.7191 -1.9077,-0.371 -2.7483,-0.78 -1.2071,-0.5872 -0.8214,-2.3109 -0.2189,-3.1806 0.2789,-0.1771 0.6188,-0.8302 0.4986,-1.17 -0.169,-0.4775 -1.5089,-0.8479 -1.0215,-1.377 0.6846,-0.7434 0.8848,-1.4312 0.9363,-2.4252l0.1825 -0.6337 0 0c0.6165,-0.108 1.6044,0.0707 2.0795,-0.4509 0.3891,-0.4273 0.9959,-1.0976 1.5444,-1.2795 0.2936,-0.0974 0.4955,0.44 0.9242,0.329 0.4217,-0.1091 0.8631,-0.5971 1.2283,-0.8409 0.7209,-0.4815 0.5653,-0.971 1.2404,-1.4502 0.846,-0.6007 0.8372,-1.8386 1.4836,-2.4251 0.1164,-0.1057 0.5276,-0.2044 0.5229,-0.2072l1.8606 -0.2763 0 0c0.5381,0.5481 1.0458,1.0681 1.1918,1.2878 0.1847,0.584 1.103,0.7236 1.5687,1.0602 0.2518,0.1819 0.3318,0.4562 0.6202,0.6215 0.2751,0.1576 0.6147,0.2621 0.9243,0.3169l0.666 0.2834c-0.0251,0.4299 0.0542,0.8127 0.0643,1.3496 0.0127,0.681 1.0196,0.8121 0.8756,1.438 -0.113,0.4912 -0.3694,0.9638 0.0486,1.438 0.7488,0.8494 1.3054,1.0995 0.681,2.2423 -0.399,0.7303 0.5411,1.1273 0.1703,1.828l0.9478 0.7922c0.5336,0.4354 0.166,1.0727 0.5351,1.5355 0.6754,0.8471 1.9014,1.8416 3.0402,1.3527 0.7724,-0.3317 0.5608,-0.4729 1.2526,-0.0366 0.5789,0.3652 3.7364,0.787 3.8307,1.0724 0.472,1.4286 -0.8148,3.0524 -0.9242,4.4969 0,0.4718 -0.0385,0.9227 -0.146,1.3527 -1.2322,0.1546 -1.7898,-0.142 -2.6632,0.7677 -0.3486,0.3632 -1.6006,1.4229 -1.7268,1.8036 -0.2559,0 -2.4545,-4.0684 -3.7699,-4.5577 -2.8868,-1.0737 -4.3936,1.7228 -6.7614,-0.8531l-0.5836 -0.7652 -1.6892 0.2451 -1.3139 0.6076c-0.2385,1.2938 -0.8641,2.8068 -2.4695,2.8495 -0.7363,0.0196 -1.3545,-0.6143 -2.0916,-0.3291 -0.7227,0.2797 -1.3626,1.1246 -1.7147,1.7915 -0.023,0.4842 0.38,1.4022 0.2554,1.7792 -0.1642,0.4972 -1.0341,0.1212 -1.3499,0.2681 -0.0391,0.0182 -0.0861,0.0688 -0.1378,0.1372l0 0z",

                        "Flintshire": "M170.085 48.233l-1.8606 0.2763c0.0047,0.0028 -0.4065,0.1015 -0.5229,0.2072 -0.6464,0.5865 -0.6376,1.8244 -1.4836,2.4251 -0.6751,0.4792 -0.5195,0.9687 -1.2404,1.4502 -0.3652,0.2438 -0.8066,0.7318 -1.2283,0.8409 -0.4287,0.111 -0.6306,-0.4264 -0.9242,-0.329 -0.5485,0.1819 -1.1553,0.8522 -1.5444,1.2795 -0.4751,0.5216 -1.463,0.3429 -2.0795,0.4509l0 0 -0.6932 -0.658c-0.2391,-0.6603 -0.3892,-1.2379 -0.3892,-1.9499 0,-0.9084 -0.6757,-0.7517 -1.3741,-0.8287 -1.3709,-0.1511 -1.2575,-3.4899 -1.1188,-4.4968 0.1363,-0.9887 -1.2513,-1.09 -1.9336,-0.6825 -0.8118,0.4847 -3.0279,0.3923 -3.5388,-0.5118 -0.0421,-0.5046 -0.2012,-1.8818 -0.45,-2.2789 -0.3893,-0.6215 -1.3202,-0.8535 -1.7998,-1.5355 -0.3313,-0.4713 0.0243,-0.7807 -0.0973,-1.1455 -0.8033,0 -0.7084,-0.8766 -0.5107,-1.499 0.2502,-0.7879 1.0523,-1.3746 -0.45,-1.5964 -0.8458,-0.1248 -0.7178,-0.3815 -1.2039,-0.9384 -0.133,-0.2126 -0.3336,-0.3589 -0.5108,-0.524 -0.0635,-0.0591 -0.4515,-0.2312 -0.4134,-0.3168 0.1318,-0.2954 0.616,-0.7591 0.8877,-0.9628 1.5148,-1.1361 0.4736,-0.9819 -0.4135,-1.6939 -0.5683,-0.456 -0.5062,-1.0969 -0.6566,-1.7061 -0.318,0 -0.5556,0.4191 -0.9364,0.3412 -0.3362,-0.0687 -0.1609,-0.4311 -0.3892,-0.6459 -1.0839,-1.0202 -0.0729,-0.5842 -0.0729,-1.5842 -1.1311,0 -1.2156,0.6017 -0.8635,-0.9018 0.1276,-0.5448 1.5341,-0.3393 1.6539,-1.3649l0.4007 -1.6597 0 0c0.9813,-0.1091 2.0111,-0.0984 2.8098,-0.5095 0.2113,-0.1088 1.3863,-0.2232 1.3863,0.0731 0,1.0796 0.3258,1.1139 0.6932,1.9986 0.2627,0.4432 0.6103,0.7365 1.0215,1.0358 0.8437,0.6139 1.2526,0.2071 1.9944,1.0359 0.3489,0.3897 1.1671,1.0667 1.6782,1.2552 0.8574,0.3161 1.7484,1.2651 2.42,1.9377 0.4292,0.4297 0.7473,0.9563 1.2404,1.3405 0.4257,0.3318 1.0271,0.6936 1.3377,1.1211 0.2193,0.3407 0.9894,0.9024 1.3498,1.17 0.6017,0.4469 1.2994,0.8811 1.9215,1.2552 0.5155,0.3099 1.0384,0.8051 1.5687,1.0724l0 -0.0366c-0.1578,-0.0397 -1.1807,-2.3293 -1.2769,-2.6445l0 0 1.1675 0.0366c0.3659,0.0344 0.7337,0.1958 1.0823,0.329 0.813,0.3105 1.7768,0.4823 2.5416,0.8653 0.9451,0.4732 2.0774,1.3012 2.7484,2.1204 0.0128,0.4185 1.0725,1.9869 1.3863,2.3277 0.4758,0.5165 0.72,1.0424 1.2647,1.5233 2.1166,1.8685 -3.9446,3.013 -4.086,3.5097l-0.0243 0.0122c0,0.1553 0.7948,0.9591 1.5322,1.7101l0 0z",

                        "Isle_of_Anglesey": "M66.8879 31.046c0.1305,-0.526 -1.1435,-0.2864 -1.4958,-0.4631 -0.5183,-0.2598 -0.8819,-0.7669 -1.2526,-1.2187 -0.4772,-0.5814 -3.0273,-0.7185 -3.3077,0.0122 -0.3226,0.8403 -1.1749,0.4264 -0.5594,1.2674 0.1797,0.2455 0.322,0.5484 0.6566,0.5484 0.005,0.015 0.0094,0.0194 0.0244,0.0244l0 0.0366c0.1206,0.0299 -0.1604,0.806 -0.3041,0.9018 -0.3413,0.2275 -0.0121,0.4841 -0.0121,0.7555l0.0121 0.0122c0.7826,0 1.4635,-0.0758 2.2133,-0.2193 0.2947,-0.0563 0.5524,0.2301 0.7662,0.3777 0.5,0.345 0.4894,0.2316 1.0701,0.2316 0,0.4057 -0.1592,0.7457 -0.1094,1.1943 0.1095,0.4867 0.9784,0.7648 0.5715,1.377 -0.3907,0.588 -0.1089,0.6471 0.4621,0.914 0.2976,0.139 0.4355,0.4872 0.681,0.5728 0.5506,0.1919 1.674,-0.4631 2.2863,-0.4631 0.0998,-0.3084 -0.4583,-0.5613 -0.4743,-0.9871l-0.0365 -0.9627c-0.0152,-0.0051 -0.5473,-0.966 -0.6199,-1.0395 -0.5047,-0.5102 -1.2446,-0.9796 -1.2893,-1.1541 -0.1506,-0.5868 0.7613,-0.9456 0.8877,-1.5843l-0.1702 -0.134zm23.9845 12.5387c0.1136,-0.5641 -1.4656,0.4976 -2.8494,1.1895 -0.6758,0.3379 -1.4468,0.384 -1.6899,0.6275 -0.784,0.7853 -0.7303,1.3278 -2.0187,1.694 -0.7701,0.2188 -1.9891,0.068 -2.4808,0.8896 -0.7725,1.2909 -1.3594,0.1581 -2.2498,-0.4022 -0.6887,-0.4335 -2.4812,-0.9219 -1.9336,-2.0229 0.2625,-0.5277 3.0298,-2.1596 0.8513,-1.7061 -1.0016,0.2085 -0.6823,0.6108 -1.3255,1.0724l-0.9 0.6459c-0.8481,0.6086 -0.6873,0.0953 -1.0215,-0.6581 -0.4524,-1.2198 -3.7828,-1.7878 -3.4658,-2.9857 0.5017,-1.8962 -0.7455,-2.5027 -1.4107,-4.0947 -0.1829,-0.4376 -0.6255,-0.3292 -0.912,-0.7312 -0.1423,-0.3788 -0.8406,-0.6219 -1.0337,-1.0602 -0.1522,-0.3452 -0.1824,-0.6804 -0.1824,-1.0603 0,-0.3515 -0.7573,-1.4241 -1.058,-1.5842 -0.2082,-0.1109 -0.9903,-0.5129 -0.681,-0.8287l1.289 -1.3161c0.5726,-0.5846 0.4876,-1.5985 0.1338,-2.2911 -0.2319,-0.4538 -0.6658,-0.4271 -0.9607,-0.8409 0.0529,-0.6331 0.6989,-0.5952 0.9364,-1.0724 0.2314,-0.4652 0.0153,-1.0143 0.0973,-1.5233 0.117,-0.7253 1.0214,-1.8198 0.7053,-2.5348 -0.0908,-0.2053 -0.3303,-0.247 -0.4378,-0.4631 -0.11,-0.2213 -0.0816,-0.5838 -0.0608,-0.8409 -0.1351,-0.4738 -0.469,-0.9607 -0.5229,-1.4624 -0.0617,-0.5752 0.6722,-0.3198 1.1066,-0.3778 0.6262,-0.0837 1.0476,-0.0622 1.5931,-0.4265 0.3568,-0.2384 0.7525,-0.6778 1.1188,-0.8043 0.2187,-0.0756 0.5312,0.7422 1.4715,0.1341 0.2846,-0.1841 0.88,-1.0363 1.1552,-0.6581 0.6767,0.9297 0.9953,0.2923 1.739,-0.195 0.2521,-0.1652 0.7258,-0.678 1.0945,-0.524 0.3421,0.1428 0.9821,0.5118 1.3256,0.5118 0.7195,0.2096 1.5176,-0.6841 2.2376,-0.4996 0.7186,0.1841 1.5835,0.2678 2.2862,0.5362 0.5203,0.1988 0.8828,0.5927 1.4593,0.7555 0.9575,0.2703 1.6609,0.1835 2.0187,1.1943 0.435,1.2292 0.204,1.9608 -0.5472,2.9735 -0.5367,0.7236 0.4152,0.5586 0.8026,0.8043 0.2873,0.1823 0.3294,0.5051 0.7296,0.585 0.1648,0.0329 0.8219,-0.0224 0.8999,0.0366 0.6037,0.3119 0.9486,0.4727 0.9486,1.2308 0,0.6345 0.308,0.9055 0.4743,1.4502 0.2783,0.912 0.2251,1.3067 0.912,2.0473 0.1999,0.2154 0.2333,0.6244 0.1946,0.9262 -0.0511,0.3988 0.0847,0.5705 0.1338,0.914 0.6996,0.5562 1.4887,0.3556 2.2011,-0.0731 0.7159,-0.4307 1.0481,-0.9186 1.97,-1.2552 1.3539,-0.4942 2.7727,-0.5728 4.1955,-0.5728 0.458,0 1.3128,0.2829 1.7998,0.3778 0.8005,0.1559 -1.4418,2.1328 -1.6903,2.5957 -0.2844,0.53 -0.5867,0.8745 -0.7662,1.4868 -0.1954,0.6662 -0.2325,1.2578 -0.8755,1.7427 -0.6839,1.3021 -3.0516,1.8401 -3.4659,3.0832l0 0c-0.6273,0.6291 -1.8279,1.0733 -2.4078,1.6817 -0.6762,0.7094 -1.0126,1.3558 -1.0825,2.3276l0.1531 1.3291 -0.0037 0.0224z",

                        "Gwynedd": "M90.8724 43.5847l-0.1494 -1.3515c0.0699,-0.9718 0.4063,-1.6182 1.0825,-2.3276 0.5799,-0.6084 1.7805,-1.0526 2.4078,-1.6817l0 0c0.3415,0 1.0458,-0.3915 1.4107,-0.5119 0.4969,-0.1639 2.2349,-0.0758 2.5416,0.3656 0.4431,0.6375 0.9408,-0.0487 1.6417,-0.0487 1.3252,0 2.1004,-0.8417 3.2834,-1.3284 0.289,-0.1189 0.5583,-0.2737 0.8187,-0.4467l0 0 1.0663 0.7514c1.2314,1.326 1.7975,2.1514 3.6726,2.6201 0.149,0.6063 0.196,1.572 -0.2554,2.0961 -0.3366,0.391 -0.9677,0.5628 -1.2039,1.0359 -0.4415,0.8846 -0.3351,1.7537 -0.6081,2.6444 -0.2975,0.971 -1.7763,1.0816 -2.2254,2.0474 0.0193,0.3416 -0.482,0.8774 -0.6324,1.2186 -0.2895,0.6571 0.5837,0.4929 0.5837,0.8165 0,0.0726 -0.3533,0.158 -0.4378,0.2072 -0.4101,0.2387 -1.0378,1.3411 -1.1188,1.7914 -0.067,0.372 0.7459,0.1747 0.8756,0.8287 0.2223,1.12 0.8894,1.2224 1.5688,2.0352 0.6127,0.7328 1.03,1.0707 0.6202,2.0595 -0.1886,0.6808 -0.7278,0.5159 -0.681,1.5477 0.041,0.9033 -0.4581,3.1186 0.535,3.5585 1.8131,0.803 3.7109,-2.1524 5.6184,-0.3534 0.5941,0.5602 -0.5019,1.3253 0.2797,2.1082 0.649,0.6499 2.1738,1.259 2.5173,2.0839 0.1189,0.8136 1.6365,2.819 2.6024,2.4495 0.8483,-0.3244 2.2587,-0.521 2.7605,-1.2796 1.2405,-1.8749 2.639,-2.2006 4.7063,-2.4007 0.7283,-0.0704 0.5062,-1.09 1.4957,-0.9627 0.9395,0.1208 1.3949,-1.0122 2.1647,-1.2674l1.0336 -0.2681c0.4905,-0.1272 1.0774,-0.4533 0.7297,0.3777 -0.4124,0.9854 0.1634,1.855 0.4135,2.8761 0.5087,2.0774 3.1452,0.3696 4.3171,0.7433 0.7501,0.2391 1.6623,0.8908 2.4686,0.4022 0.5809,-0.3521 1.6158,-1.5917 1.9458,-2.1692l0 0c0.2361,0.2282 0.5556,0.4098 0.7418,0.6581 -0.5243,0.6559 0.2132,1.7265 -0.5229,2.3763 -0.3932,0.3472 -0.86,0.5498 -1.2404,0.914 -0.5179,0.496 -0.6674,0.8781 -0.9486,1.5234 0.0602,0.8228 0.5896,0.9368 1.2891,1.1699 0,0.2513 0.0402,0.5574 0.0851,0.8043 0.0656,0.3609 -0.4707,0.7245 -0.6689,1.0115 -0.6327,0.9166 -0.5806,1.4093 -0.0973,2.3885 0.4807,0.9737 0.3813,1.2581 -0.158,2.1083l0 0 -0.6081 0.2803c-0.0331,0.3672 -0.321,1.6062 -0.5351,1.9011 -0.4612,0.6349 -0.8309,0.9365 -1.593,0.6093 -0.7868,-0.3379 -2.054,0.4648 -2.493,1.0603 -0.5382,0.7298 -1.0872,-0.0551 -1.7025,0.1462 -0.1858,0.0607 -0.4701,1.389 -0.5594,1.633 -0.3095,0.8461 -1.1851,1.4243 -0.6446,2.3398 0.6464,1.0947 0.589,1.4279 0.8878,2.6201 -0.0828,0.9655 0.6526,1.8336 0.2067,2.7298 -0.3117,0.6263 -0.7245,1.1863 -0.8269,1.8889 -0.0659,0.4519 0.0905,1.1396 -0.2432,1.4746 -0.241,0.2418 -0.5976,0.3948 -0.8635,0.6459 -0.251,0.2372 -0.6548,0.0218 -0.9485,0.134 -0.485,0.1852 -0.7547,0.646 -1.2526,0.7678 -0.4626,0.1131 -1.2271,-0.1529 -1.6539,-0.3291 -0.9043,0.1556 -1.0113,1.2744 -1.3863,1.9012 -0.6035,1.0084 -0.2558,-0.2957 -1.0701,-0.195 -0.506,0.0626 -1.1368,-0.4474 -1.3621,-0.3534 -0.5179,0.2159 -0.6492,0.8959 -1.289,1.1089 -0.3075,0.1023 -1.2444,0.1155 -1.5566,0.0366 -0.2296,-0.0581 -1.7409,-1.0779 -1.9093,-0.2681 -0.1961,0.9435 -2.4232,2.4555 -1.5809,3.5463 0.5767,0.7469 0.2311,0.2669 -0.2553,1.243 -0.1933,0.3881 -0.2804,1.7294 -0.1338,2.1205 0.1459,0.3384 0.5204,0.5362 -0.073,0.5362 -0.7759,0 -0.5535,0.4084 -0.9972,0.8043 -0.1417,0.1265 -0.4269,0.1 -0.4986,0.2315 -0.2167,0.3969 -0.1959,0.8023 -0.6688,1.109 -0.5477,0.3551 -1.1612,0.1868 -1.739,0.4997 -0.5061,0.2742 -1.1675,0.6486 -1.1675,1.3283l0.1703 0.6093 0 0 -0.5108 0.8165 -0.8877 -0.0609 0 0c-0.6031,0 -1.3786,0.4056 -1.9579,0.5849 -1.0104,0.3126 -2.1821,0.3007 -3.1375,0.5972 -0.5287,0.1641 -1.4045,0.6176 -1.9336,0.5118 -0.7566,-0.1512 -1.3653,-2.2764 -1.6903,-3.1197 -0.5442,-1.4178 -1.3061,-2.4076 -2.189,-3.5829 -0.7811,-1.0397 0.0416,-2.425 0.5229,-3.4366 0.2715,-0.5709 1.066,-2.0219 0.9121,-2.6567 0.436,-0.5333 0.8254,-0.8231 1.3742,-1.243 0.4467,-0.3419 0.4167,-1.0451 0.8999,-1.2308 0.426,-0.1638 0.6825,-0.0936 0.8147,-0.6337 0.1117,-0.456 0.0256,-0.9461 0.073,-1.4137 0.0723,-0.7137 0.7853,-0.7114 1.2769,-1.0237 0.9306,-0.5914 1.4661,-0.6862 2.2133,-1.6329 0.031,-0.0392 0.3596,-0.4189 0.231,-0.451l-2.4929 1.4502c-1.2275,0.714 -1.492,1.1942 -2.0431,-0.5483 -0.1948,-0.6162 -0.5992,-1.1388 -0.7783,-1.7671 -0.7502,-2.112 -3.1266,-3.5253 -4.0739,-5.4961 -0.1292,-0.2687 -1.1174,-1.3577 -1.0458,-1.4746 0.3323,-0.5431 0.9637,-0.6794 1.2647,-1.2674 1.114,-1.0464 1.4779,-2.6237 0.8148,-4.0094 -0.1853,-0.3872 -0.4955,-1.0656 -0.8148,-1.3283 -0.3152,-0.5711 -0.9284,-0.9478 -1.1309,-1.6086 -0.1714,-0.5597 0.1094,-0.7315 0.1094,-1.17 -0.3635,0.0916 -0.7083,0.4725 -0.8756,0.0975 -0.1766,-0.3961 -0.6192,-0.6938 -0.9607,-0.9505 -1.2277,-0.9226 -2.3241,-1.355 -3.8428,-0.8409 -1.2611,0.427 -1.6913,0.6044 -3.0159,0.4631 -1.683,-0.1795 -1.9721,1.6317 -3.0888,1.7305 -1.2146,0 -4.1712,-0.688 -4.1712,1.304l-0.0122 0.0121c-0.9702,0 -1.6849,0.4298 -2.5659,0.7678 -1.0305,0.3955 -1.455,1.2393 -2.189,1.9986 0.04,0.6396 0.7682,0.8489 -0.1216,1.243 -0.3742,0.1658 -0.9062,0.6361 -1.058,1.0359 -0.3964,1.0433 -0.465,2.2051 0.5837,2.7907 0.6644,0.3711 -0.0848,1.3047 -0.3648,1.6817 -0.1619,0.2181 -0.4204,-0.0551 -0.6323,-0.1096 -1.1638,-0.2994 -1.3911,1.8665 -1.8485,1.5842 -1.1394,-0.703 -0.1888,-2.0592 -0.9364,-2.7541 -0.5328,-0.4951 -1.1651,-0.947 -1.7755,-1.3406 -0.6948,-0.5048 -2.2706,-1.2942 -2.6632,-0.1584 -0.2081,0.602 -1.4047,2.4942 -2.2133,1.9011 -0.5717,-0.4192 -0.4446,-0.6318 -1.3377,-0.2315 -0.8886,0.3982 -1.2488,1.4591 -1.9457,0.3534 -0.7692,-1.2202 -2.0065,1.3099 -2.0065,1.9133l-0.0244 0 -1.593 -1.0359c-0.9735,-0.6329 -0.5459,-0.4693 0.0364,-1.1821 0.3171,-0.3883 0.3608,-0.8682 0.5473,-1.3161 0.2995,-0.7196 0.7408,-1.158 1.1431,-1.7915 0.2204,-0.5294 0.4763,-0.7452 0.377,-1.3649 -0.0256,-0.1604 -0.2822,-1.0577 -0.073,-1.0724 0.6879,-0.0484 1.7761,-0.2911 2.0917,-0.9627 0.101,-0.2148 0.1401,-1.304 0.2189,-1.304 0.9913,0 1.1763,0.2624 1.435,-0.914 0.0845,-0.3841 1.0153,-2.3602 1.2404,-2.2788 0.6368,0.2301 1.1678,0.1151 1.4714,-0.5363 0.3583,-0.7685 0.2964,-0.976 1.0094,-1.4136 0.5759,-0.2064 1.351,-0.5404 1.6782,-1.0724 0.2794,-0.4541 0.5472,-0.2726 0.8148,-0.6337 0.0555,-0.075 0.2054,-0.589 0.2189,-0.5484l0.0243 0c0.0233,0.095 0.1034,0.8309 0.2675,0.7068 0.5732,0.5756 2.6899,0.0219 3.1983,-0.4874 0.9936,-0.9951 2.2433,-2.2455 2.9186,-3.4732 0.516,-0.5638 0.8767,-1.3516 1.3742,-1.8889 0.5629,-0.6081 0.9004,-0.4088 1.6417,-0.4509 1.1155,-0.0635 2.2703,-1.9436 3.0281,-2.6689 0.5327,-0.5097 1.3725,-1.1636 1.3255,-1.962 0.1288,-0.4845 0.4978,-0.805 0.6324,-1.2431 0.1386,-0.4515 0.0851,-0.8874 0.0851,-1.3648 0,-0.9507 0.0911,-1.9611 -0.1094,-2.8639 -0.0898,-0.4048 -0.3938,-1.2606 -0.6567,-1.5721 0,-1.1331 0.1881,-1.6086 1.3133,-1.6086 -0.1135,0.4615 0.046,3.0284 0.5716,2.0352 0.404,-0.7632 0.2695,-1.6884 0.4621,-2.5105 0.1097,-0.4687 1.1927,-1.1068 1.6174,-1.4502 0.5907,-0.4775 1.082,-1.5408 1.5931,-2.1813 0.3368,-0.4221 3.3135,-2.0652 3.3597,-2.268l0 0zm-37.702 46.103c0.2884,-0.3757 0.5465,-1.0836 0.4378,-1.5721 -0.0231,-0.1042 -0.1106,-0.4059 0.0122,-0.4753 0.0339,-0.0192 0.3719,0.0244 0.4378,0.0244 0.3225,0 0.6378,0.0637 0.5715,0.4753 -0.0471,0.2921 -0.0645,0.4932 -0.2675,0.7312 -0.2316,0.2713 -0.5805,0.306 -0.7418,0.6702 -0.1034,0.2337 -0.298,0.7104 -0.6446,0.5119l0.1946 -0.3656z",

                        "Monmouthshire": "M163.606 169.576c0.467,0.5512 1.0237,1.1088 1.4683,1.5544 0.9728,0.9753 2.0322,2.3592 2.2741,3.7413 0.2657,1.5179 2.4079,-0.1293 2.4079,1.8524 0.1696,1.4589 0.6453,0.9353 1.6782,0.6337 1.2983,-0.379 2.3327,-1.0594 3.4293,-1.7915 1.2282,-0.8201 1.4462,-0.4746 2.8943,-0.1096 0.0346,0.2413 -0.4688,0.8574 -0.2189,0.9749 0.2473,0.1164 0.7278,-0.0036 0.8756,0.2925 0.4625,0.9268 0.3896,0.3823 1.2283,1.1577l2.2011 2.0351c0.8525,0.7881 0.041,2.108 1.3377,2.8273 0.3948,0.6446 0.5886,1.1633 1.2039,1.6208 0.6844,0.5088 1.0936,0.0666 1.812,-0.0487 0.616,-0.0988 0.6325,0.4614 1.058,0.6824 0.6788,0.3524 1.7055,-0.8298 2.1403,-0.2559 0.5147,0.6792 0.4935,0.3805 0.2553,1.2187 -0.1068,0.3758 0.1553,0.6641 0.0487,1.048 -0.1236,0.4455 -0.904,0.8481 -1.1553,1.2552 -0.1667,0.2702 0.4753,1.4468 0.5594,1.7549 0.3481,0.8726 0.0301,0.8358 -0.5229,1.3527 -0.3759,0.3512 1.4067,1.5814 1.3742,2.3642 -0.0366,0.8829 -0.7148,1.2834 -1.4472,1.4989 -0.5382,0.1583 0.0045,0.7331 0.0487,1.109 0.0509,0.4324 -0.0896,0.7144 0.2432,1.0481 0.4898,0.4909 0.7228,0.9168 -0.0243,1.0846 -0.6804,0.1529 0.1531,0.8046 0.3405,1.2064 -0.0734,0.8516 1.9527,2.2867 -0.1216,2.6323 -0.5694,0.0949 -0.7577,-0.3348 -0.7054,0.3047 0.017,0.2094 -0.1581,0.5224 -0.1581,0.8043 0.0464,0.0154 -0.0729,0.4915 -0.0729,0.719 0.174,0.035 0.9796,-0.446 0.9972,-0.195 0.0483,0.688 -0.3003,1.4203 0.0851,2.0474 0.1937,0.3153 0.4959,0.3905 0.5959,0.7921 0.0626,0.2515 0.7744,1.3994 1.0215,1.5233l0 0c-0.025,0.2875 -1.5743,0.7645 -1.9093,0.9627 -0.4074,0.2409 -0.7532,0.7625 -1.1553,0.9384 -0.4274,0.4292 -0.3784,1.0682 -0.9971,1.3405 -0.4585,0.2017 -1.1684,0.1219 -1.6661,0.1219 -1.2407,0 -2.9645,0.8998 -3.9158,1.6574 -0.2705,0.2154 -0.5544,0.4338 -0.8493,0.6493l0 0c-0.251,-0.3541 -0.5392,-1.1665 -0.9965,-1.6678 -0.2181,-0.2392 -0.8501,-0.1575 -1.0529,-0.3082 -0.2297,-0.1708 -0.0159,-0.5687 0.0166,-0.7572 0.0437,-0.2535 -0.0431,-0.914 0.0608,-1.0603 0.2537,-0.3575 0.6283,-0.5238 0.8148,-0.9871 0.3163,-0.7861 0.3413,-1.5393 1.2647,-1.8036 0.7998,-0.229 1.0541,-0.2476 0.45,-0.9627 -0.2792,-0.3306 -1.6148,-2.4458 -1.7877,-2.2667 -0.8202,0.8491 -1.8591,0.3835 -2.6754,0.7921 -0.5576,0.2792 -0.7555,0.8408 -1.2404,1.2065 -0.2094,0.158 -0.7288,0.3422 -0.9972,0.3046 -0.6288,-0.088 -0.9992,0.9936 -1.7633,0.8409 -0.4805,-0.0961 -0.202,-0.4388 -0.377,-0.7434 -0.1936,-0.3368 -0.5997,-0.24 -0.8999,-0.3899l0 0 -0.1946 -0.4753c-0.2892,-0.2113 -0.7026,-0.4567 -0.8755,-0.7678 -0.2268,-0.4079 -0.2292,-0.8531 -0.3041,-1.3039 -0.1742,-1.0482 -1.4331,-1.0569 -1.2525,-2.2302 0.3371,-0.464 0.809,-0.2845 1.1552,0.0244 0.4872,0.4349 0.4491,-0.8014 0.4986,-0.9627 0.0778,-0.2539 0.2189,-0.6029 0.2189,-0.8531 -0.4858,-0.1224 -1.8713,0.3923 -1.8363,-0.4631 0.0203,-0.4956 1.124,-1.7524 0.9729,-1.9986 -0.16,-0.2606 -1.2887,-0.4162 -1.5809,-0.3778 -0.561,0.0739 -0.7435,0.1778 -1.2647,-0.1218 -0.2425,-0.5353 -0.1294,-1.6747 0.0243,-2.2545 0.1341,-0.5063 -0.0721,-0.6315 -0.377,-0.914 -0.1248,-0.1155 -0.197,-0.2048 -0.304,-0.3656 -0.3476,-0.2535 -0.5468,-0.5942 -0.6081,-1.0115 -0.0515,-0.3501 0.1984,-0.5732 0.2189,-0.8653 0.0258,-0.3686 -1.2908,-1.171 -1.6052,-1.3283 -0.5199,-0.2602 -1.1594,-0.3345 -1.6539,-0.6093 -0.7436,-0.4131 -1.6233,-0.2586 -2.4443,-0.2194l0 0 -0.4864 -0.1706c-0.4027,0 -0.9104,0.1744 -0.8878,-0.4021 0.0129,-0.328 0.2783,-0.6094 0.3892,-0.9018 0.1102,-0.2902 -0.0642,-0.566 -0.2311,-0.7922l0 0c0.4031,-0.4538 1.6215,-2.3708 2.189,-2.2789 0.2006,0.0324 0.9008,0.7425 0.9485,0.5484 0.2306,-0.0569 0.3734,-1.2577 0.8756,-1.5477 0.4741,-0.2739 0.9362,-1.2816 1.3499,-1.7304 0.3968,-0.4303 -0.3406,-0.9358 -0.3406,-1.304 0.4856,-0.2086 2.2107,-0.5598 2.0552,-1.0968 0.3246,-1.0539 0.0162,-1.6854 -0.6323,-2.4982 -0.4768,-0.5975 -1.8097,-1.5249 -1.9823,-2.2302 -0.1326,-0.5416 -0.0309,-1.0749 -0.2188,-1.6086 -0.2454,-0.6966 0.1853,-1.4825 -0.5594,-1.9499 -0.0248,-0.1983 0.2646,-0.3673 0.3526,-0.5605l0.9152 -0.9817 0 0z"

                    }
                }
            }
        }
    );
})(jQuery);