"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const VALID_METHODS = ["HEAD", "GET", "POST", "PUT", "DELETE"];

class CommonService {
  constructor(osDriver) {
    _defineProperty(this, "osDriver", void 0);

    _defineProperty(this, "apiCaller", async (context, request, response) => {
      const useQuery = !request.body;
      const usedParam = useQuery ? request.query : request.body;
      const {
        endpoint,
        data,
        hideLog
      } = usedParam || {};

      try {
        const {
          callAsCurrentUser: callWithRequest
        } = this.osDriver.asScoped(request);
        const finalData = data;
        /**
         * The endpoint must not be an empty string, reference from proxy caller
         */

        if (!endpoint) {
          return response.custom({
            statusCode: 200,
            body: {
              ok: false,
              error: `Expected non-empty string on endpoint`
            }
          });
        }
        /**
         * Update path parameter to follow RFC/generic HTTP convention
         */


        if (endpoint === "transport.request" && typeof (finalData === null || finalData === void 0 ? void 0 : finalData.path) === "string" && !/^\//.test((finalData === null || finalData === void 0 ? void 0 : finalData.path) || "")) {
          finalData.path = `/${finalData.path || ""}`;
        }
        /**
         * Check valid method here
         */


        if (endpoint === "transport.request" && data !== null && data !== void 0 && data.method) {
          var _data$method$toUpperC, _data$method;

          if (VALID_METHODS.indexOf((_data$method$toUpperC = (_data$method = data.method).toUpperCase) === null || _data$method$toUpperC === void 0 ? void 0 : _data$method$toUpperC.call(_data$method)) === -1) {
            return response.custom({
              statusCode: 200,
              body: {
                ok: false,
                error: `Method must be one of, case insensitive ['HEAD', 'GET', 'POST', 'PUT', 'DELETE']. Received '${data.method}'.`
              }
            });
          }
        }

        const payload = useQuery ? JSON.parse(finalData || "{}") : finalData;
        const commonCallerResponse = await callWithRequest(endpoint, payload || {});
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: commonCallerResponse
          }
        });
      } catch (err) {
        if (!hideLog) {
          console.error("Index Management - CommonService - apiCaller", err);
        }

        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: err === null || err === void 0 ? void 0 : err.message,
            body: (err === null || err === void 0 ? void 0 : err.body) || ""
          }
        });
      }
    });

    this.osDriver = osDriver;
  }

}

exports.default = CommonService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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