"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseInsensitiveCharStream = void 0;

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class CaseInsensitiveCharStream {
  get index() {
    return this.stream.index;
  }

  get size() {
    return this.stream.size;
  }

  get sourceName() {
    return 'pplquery';
  }

  constructor(stream) {
    _defineProperty(this, "stream", void 0);

    this.stream = stream;
  }

  LA(offset) {
    const c = this.stream.LA(offset);

    if (c <= 0) {
      return c;
    } // case insensitivity support for PPL


    return String.fromCodePoint(c).toUpperCase().codePointAt(0);
  }

  consume() {
    this.stream.consume();
  }

  mark() {
    return this.stream.mark();
  }

  release(marker) {
    this.stream.release(marker);
  }

  seek(index) {
    this.stream.seek(index);
  }

  getText(interval) {
    return this.stream.getText(interval);
  }

  toString() {
    return this.stream.toString();
  }

}

exports.CaseInsensitiveCharStream = CaseInsensitiveCharStream;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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