/*
*  RAL -- Rubrica Addressbook Library
*  file: groups.h
*  
*  Copyright (C) Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 3 of the License
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _R_GROUPS_SET_H
#define _R_GROUPS_SET_H

#include <glib.h>
#include <glib-object.h>

#include "utils.h"
#include "group.h"


#define R_GROUP_TYPE           (r_group_get_type())

#define R_GROUP(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj),  \
                                R_GROUP_TYPE, RGroup))

#define R_GROUP_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),   \
                                R_GROUP_TYPE, RGroupClass))

#define IS_R_GROUP(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj),  \
                                R_GROUP_TYPE))

#define IS_R_GROUP_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls), R_GROUP_TYPE))

#define R_GROUP_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),   \
				R_GROUP_TYPE, RGroupClass))



typedef struct _RGroup        RGroup;
typedef struct _RGroupClass   RGroupClass;
typedef struct _RGroupPrivate RGroupPrivate;


struct _RGroup {
  GObject parent;
  
  RGroupPrivate* priv;  
};


struct _RGroupClass {
  GObjectClass parent;
};



GType    r_group_get_type      (void);


RGroup*  r_group_new           (void);
void     r_group_free          (RGroup* group);
RGroup*  r_group_copy          (RGroup* group);


gboolean r_group_rename        (RGroup* group, gchar* newname);
gboolean r_group_change_pixmap (RGroup* group, gchar* newpix);
gboolean r_group_has_name      (RGroup* group, const gchar* name);
gboolean r_group_has_owner     (RGroup* group, const gchar* owner);

#endif
