/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.MetalEditorTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;

public final class MetalEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private Rectangle scratch = new Rectangle();
    private static Map<Integer, String[]> buttonIconPaths;

    public MetalEditorTabDisplayerUI(TabDisplayer tabDisplayer) {
        super(tabDisplayer);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new MetalEditorTabCellRenderer();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalEditorTabDisplayerUI((TabDisplayer)jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return new Dimension(80, 28);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        int n = 28;
        Graphics2D graphics2D = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (graphics2D != null) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.displayer.getFont());
            Insets insets = this.getTabAreaInsets();
            n = fontMetrics.getHeight() + insets.top + insets.bottom + 9;
        }
        return new Dimension(this.displayer.getWidth(), n);
    }

    protected int createRepaintPolicy() {
        return 428;
    }

    public Insets getTabAreaInsets() {
        Insets insets = super.getTabAreaInsets();
        insets.bottom += 4;
        insets.right += 3;
        return insets;
    }

    public void install() {
        super.install();
        this.displayer.setBackground(UIManager.getColor("control"));
    }

    protected void paintAfterTabs(Graphics graphics) {
        Rectangle rectangle = new Rectangle();
        this.getTabsVisibleArea(rectangle);
        rectangle.width = this.displayer.getWidth();
        graphics.setColor(this.displayer.isActive() ? this.defaultRenderer.getSelectedActivatedBackground() : this.defaultRenderer.getSelectedBackground());
        Insets insets = this.getTabAreaInsets();
        graphics.fillRect(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, this.displayer.getHeight() - (rectangle.y + rectangle.height));
        graphics.setColor(UIManager.getColor("controlHighlight"));
        int n = 0;
        int n2 = this.selectionModel.getSelectedIndex();
        if (n2 != -1) {
            this.getTabRect(n2, this.scratch);
            if (this.scratch.width != 0) {
                if (rectangle.x < this.scratch.x) {
                    graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, this.scratch.x - 1, this.displayer.getHeight() - insets.bottom);
                }
                if (this.scratch.x + this.scratch.width < rectangle.x + rectangle.width) {
                    n = this.scratch.x + this.scratch.width;
                    graphics.drawLine(n, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width, this.displayer.getHeight() - insets.bottom);
                }
            } else {
                graphics.drawLine(0, this.displayer.getHeight() - insets.bottom, this.displayer.getWidth(), this.displayer.getHeight() - insets.bottom);
            }
            graphics.setColor(UIManager.getColor("controlDkShadow"));
            graphics.drawLine(n, this.displayer.getHeight() - 5, this.displayer.getWidth(), this.displayer.getHeight() - 5);
            return;
        }
        graphics.drawLine(rectangle.x, this.displayer.getHeight() - insets.bottom, rectangle.x + rectangle.width, this.displayer.getHeight() - insets.bottom);
        graphics.setColor(UIManager.getColor("controlDkShadow"));
        graphics.drawLine(0, this.displayer.getHeight() - 5, this.displayer.getWidth(), this.displayer.getHeight() - 5);
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_scrollleft_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_scrollleft_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_scrollleft_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_scrollleft_pressed.png";
            buttonIconPaths.put(9, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_scrollright_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_scrollright_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_scrollright_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_scrollright_pressed.png";
            buttonIconPaths.put(10, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_popup_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_popup_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_popup_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_popup_pressed.png";
            buttonIconPaths.put(8, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_maximize_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_maximize_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_maximize_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_maximize_pressed.png";
            buttonIconPaths.put(3, stringArray);
            stringArray = new String[4];
            stringArray[0] = "org/netbeans/swing/tabcontrol/resources/metal_restore_enabled.png";
            stringArray[2] = "org/netbeans/swing/tabcontrol/resources/metal_restore_disabled.png";
            stringArray[3] = "org/netbeans/swing/tabcontrol/resources/metal_restore_rollover.png";
            stringArray[1] = "org/netbeans/swing/tabcontrol/resources/metal_restore_pressed.png";
            buttonIconPaths.put(4, stringArray);
        }
    }

    public Icon getButtonIcon(int n, int n2) {
        Icon icon = null;
        MetalEditorTabDisplayerUI.initIcons();
        String[] stringArray = buttonIconPaths.get(n);
        if (null != stringArray && n2 >= 0 && n2 < stringArray.length) {
            icon = TabControlButtonFactory.getIcon(stringArray[n2]);
        }
        return icon;
    }

    protected Rectangle getControlButtonsRectangle(Container container) {
        Component component = this.getControlButtons();
        return new Rectangle(container.getWidth() - component.getWidth() - 3, 3, component.getWidth(), component.getHeight());
    }
}

