/*
 * Decompiled with CFR 0.152.
 */
package tr.view.projects;

import java.awt.EventQueue;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import tr.model.Data;
import tr.model.DataLookup;
import tr.util.Observable;
import tr.util.Observer;
import tr.view.projects.ImportTemplate;

public final class ImportTemplateAction
extends CallableSystemAction
implements Observer {
    public ImportTemplateAction() {
        this.setEnabled(false);
        this.dataChanged();
        Lookup.Result r = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        r.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                ImportTemplateAction.this.dataChanged();
            }
        });
    }

    public void performAction() {
        ImportTemplate importer = new ImportTemplate();
        importer.process();
    }

    public String getName() {
        return NbBundle.getMessage(ImportTemplateAction.class, (String)"CTL_ImportTemplateAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private void dataChanged() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Data data = (Data)DataLookup.instance().lookup(Data.class);
                if (data == null) {
                    ImportTemplateAction.this.setEnabled(false);
                } else {
                    ImportTemplateAction.this.setEnabled(true);
                    data.addObserver((Observer)ImportTemplateAction.this);
                }
            }
        });
    }

    public void update(Observable observable, Object arguement) {
        this.dataChanged();
    }
}

