/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.broadcast;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.broadcast.BaseBroadcastService;
import org.traccar.broadcast.BroadcastMessage;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;

public class RedisBroadcastService
extends BaseBroadcastService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisBroadcastService.class);
    private final ObjectMapper objectMapper;
    private final ExecutorService service = Executors.newSingleThreadExecutor();
    private final String url;
    private final String channel = "traccar";
    private Jedis subscriber;
    private Jedis publisher;
    private final String id = UUID.randomUUID().toString();
    private final Runnable receiver = new Runnable(){

        @Override
        public void run() {
            try {
                RedisBroadcastService.this.subscriber.subscribe(new JedisPubSub(){

                    public void onMessage(String messageChannel, String message) {
                        try {
                            String[] parts = message.split(":", 2);
                            if (messageChannel.equals("traccar") && parts.length == 2 && !RedisBroadcastService.this.id.equals(parts[0])) {
                                RedisBroadcastService.this.handleMessage((BroadcastMessage)RedisBroadcastService.this.objectMapper.readValue(parts[1], BroadcastMessage.class));
                            }
                        }
                        catch (IOException e) {
                            LOGGER.warn("Broadcast handleMessage failed", (Throwable)e);
                        }
                    }
                }, new String[]{"traccar"});
            }
            catch (JedisConnectionException e) {
                throw new RuntimeException(e);
            }
            catch (JedisException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public RedisBroadcastService(Config config, ObjectMapper objectMapper) throws IOException {
        this.objectMapper = objectMapper;
        this.url = config.getString(Keys.BROADCAST_ADDRESS);
        try {
            this.subscriber = new Jedis(this.url);
            this.publisher = new Jedis(this.url);
            this.subscriber.connect();
        }
        catch (JedisConnectionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean singleInstance() {
        return false;
    }

    @Override
    protected void sendMessage(BroadcastMessage message) {
        try {
            String payload = this.id + ":" + this.objectMapper.writeValueAsString((Object)message);
            this.publisher.publish("traccar", payload);
        }
        catch (IOException e) {
            LOGGER.warn("Broadcast failed", (Throwable)e);
        }
        catch (JedisConnectionException e) {
            LOGGER.warn("Broadcast failed", (Throwable)e);
        }
    }

    @Override
    public void start() throws IOException {
        this.service.submit(this.receiver);
    }

    @Override
    public void stop() {
        try {
            if (this.subscriber != null) {
                this.subscriber.close();
                this.subscriber = null;
            }
        }
        catch (JedisException e) {
            LOGGER.warn("Subscriber close failed", (Throwable)e);
        }
        try {
            if (this.publisher != null) {
                this.publisher.close();
                this.publisher = null;
            }
        }
        catch (JedisException e) {
            LOGGER.warn("Publisher close failed", (Throwable)e);
        }
        this.service.shutdown();
    }
}

