/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.InetSocketAddress;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.model.Position;

@Singleton
@ChannelHandler.Sharable
public class RemoteAddressHandler
extends ChannelInboundHandlerAdapter {
    private final boolean enabled;

    @Inject
    public RemoteAddressHandler(Config config) {
        this.enabled = config.getBoolean(Keys.PROCESSING_REMOTE_ADDRESS_ENABLE);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (this.enabled) {
            String hostAddress;
            InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
            String string = hostAddress = remoteAddress != null ? remoteAddress.getAddress().getHostAddress() : null;
            if (msg instanceof Position) {
                Position position = (Position)msg;
                position.set("ip", hostAddress);
            }
        }
        ctx.fireChannelRead(msg);
    }
}

