/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.hash;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.firebase.auth.UserImportHash;
import java.util.Map;

abstract class Hmac
extends UserImportHash {
    private final String key;

    Hmac(String name, Builder builder) {
        super(name);
        Preconditions.checkArgument((builder.key != null && builder.key.length > 0 ? 1 : 0) != 0, (Object)"A non-empty key is required for HMAC algorithms");
        this.key = BaseEncoding.base64().encode(builder.key);
    }

    @Override
    protected final Map<String, Object> getOptions() {
        return ImmutableMap.of((Object)"signerKey", (Object)this.key);
    }

    static abstract class Builder<T extends Builder, U extends UserImportHash> {
        private byte[] key;

        Builder() {
        }

        protected abstract T getInstance();

        public T setKey(byte[] key) {
            this.key = key;
            return this.getInstance();
        }

        public abstract U build();
    }
}

