/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.remoteconfig.TagColor;
import com.google.firebase.remoteconfig.internal.TemplateResponse;
import java.util.Objects;

public final class Condition {
    private String name;
    private String expression;
    private TagColor tagColor;

    public Condition(@NonNull String name, @NonNull String expression) {
        this(name, expression, null);
    }

    public Condition(@NonNull String name, @NonNull String expression, @Nullable TagColor tagColor) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"condition name must not be null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)expression) ? 1 : 0) != 0, (Object)"condition expression must not be null or empty");
        this.name = name;
        this.expression = expression;
        this.tagColor = tagColor;
    }

    Condition(@NonNull TemplateResponse.ConditionResponse conditionResponse) {
        Preconditions.checkNotNull((Object)conditionResponse);
        this.name = conditionResponse.getName();
        this.expression = conditionResponse.getExpression();
        if (!Strings.isNullOrEmpty((String)conditionResponse.getTagColor())) {
            this.tagColor = TagColor.valueOf(conditionResponse.getTagColor());
        }
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getExpression() {
        return this.expression;
    }

    @NonNull
    public TagColor getTagColor() {
        return this.tagColor;
    }

    public Condition setName(@NonNull String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"condition name must not be null or empty");
        this.name = name;
        return this;
    }

    public Condition setExpression(@NonNull String expression) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)expression) ? 1 : 0) != 0, (Object)"condition expression must not be null or empty");
        this.expression = expression;
        return this;
    }

    public Condition setTagColor(@Nullable TagColor tagColor) {
        this.tagColor = tagColor;
        return this;
    }

    TemplateResponse.ConditionResponse toConditionResponse() {
        return new TemplateResponse.ConditionResponse().setName(this.name).setExpression(this.expression).setTagColor(this.tagColor == null ? null : this.tagColor.getColor());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition condition = (Condition)o;
        return Objects.equals(this.name, condition.name) && Objects.equals(this.expression, condition.expression) && this.tagColor == condition.tagColor;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.expression, this.tagColor});
    }
}

