/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.enterprise.client;

import ca.sqlpower.enterprise.client.ConnectionTestAction;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.enterprise.client.SPServerInfoManager;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.enterprise.client.SPServerInfoPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class SPServerInfoManagerPanel {
    private final SPServerInfoManager manager;
    private final Component dialogOwner;
    private final JPanel panel;
    private JList serverInfos;
    private final JButton connectButton;
    private ConnectionTestAction testAction = new ConnectionTestAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(null, "Testing not implemented");
        }
    };
    private Action removeAction = new AbstractAction("Remove"){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object[] selectedValues;
            for (Object o : selectedValues = SPServerInfoManagerPanel.this.serverInfos.getSelectedValues()) {
                SPServerInfo si = (SPServerInfo)o;
                SPServerInfoManagerPanel.this.manager.remove(si);
            }
            SPServerInfoManagerPanel.this.refreshInfoList();
        }
    };
    private Action addAction = new AbstractAction("Add..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            SPServerInfoManagerPanel.this.showAddOrEditDialog(null);
        }
    };
    private Action editAction = new AbstractAction("Edit..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            SPServerInfoManagerPanel.this.editSelectedServer();
        }
    };

    public SPServerInfoManagerPanel(SPServerInfoManager manager, Component dialogOwner, Action closeAction) {
        this.manager = manager;
        this.dialogOwner = dialogOwner;
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref", "pref, pref, pref"));
        this.serverInfos = new JList(new DefaultListModel());
        this.serverInfos.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e) && SPServerInfoManagerPanel.this.connectButton.getAction() != null) {
                    SPServerInfoManagerPanel.this.connectButton.getAction().actionPerformed(null);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.serverInfos);
        scrollPane.setPreferredSize(new Dimension(400, 300));
        this.connectButton = new JButton();
        this.refreshInfoList();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JLabel("Available Server Connections:"), cc.xyw(1, 1, 3));
        builder.nextLine();
        builder.add((Component)scrollPane, cc.xywh(1, 2, 1, 2));
        DefaultFormBuilder buttonBarBuilder = new DefaultFormBuilder(new FormLayout("pref"));
        buttonBarBuilder.append((Component)new JButton(this.addAction));
        buttonBarBuilder.append((Component)new JButton(this.editAction));
        buttonBarBuilder.append((Component)new JButton(this.removeAction));
        buttonBarBuilder.append((Component)this.connectButton);
        buttonBarBuilder.append((Component)new JButton(closeAction));
        builder.add((Component)buttonBarBuilder.getPanel(), cc.xy(3, 2));
        builder.setDefaultDialogBorder();
        this.panel = builder.getPanel();
    }

    private void refreshInfoList() {
        DefaultListModel model = (DefaultListModel)this.serverInfos.getModel();
        model.removeAllElements();
        for (SPServerInfo si : this.manager.getServers(false)) {
            model.addElement(si);
        }
    }

    public JPanel getPanel() {
        return this.panel;
    }

    private void showAddOrEditDialog(final SPServerInfo serverInfo) {
        final SPServerInfoPanel infoPanel = serverInfo == null ? new SPServerInfoPanel(this.panel, this.manager.getClientVersion(), this.manager.getDefaultSettings()) : new SPServerInfoPanel(this.panel, this.manager.getClientVersion(), serverInfo);
        this.testAction.addPanel(infoPanel);
        infoPanel.setTestAction(this.testAction);
        Callable<Boolean> okCall = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (!infoPanel.applyChanges()) {
                    return false;
                }
                if (serverInfo != null) {
                    SPServerInfoManagerPanel.this.manager.remove(serverInfo);
                }
                SPServerInfoManagerPanel.this.manager.add(infoPanel.getServerInfo());
                SPServerInfoManagerPanel.this.refreshInfoList();
                SPServerInfoManagerPanel.this.testAction.removePanel(infoPanel);
                return true;
            }
        };
        Callable<Boolean> cancelCall = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                SPServerInfoManagerPanel.this.testAction.removePanel(infoPanel);
                return true;
            }
        };
        JDialog dialog = DataEntryPanelBuilder.createDataEntryPanelDialog(infoPanel, this.dialogOwner, "Server Connection Properties", "OK", okCall, cancelCall);
        dialog.setVisible(true);
    }

    public void setTestAction(ConnectionTestAction action) {
        this.testAction = action;
    }

    private void editSelectedServer() {
        SPServerInfo selectedItem = this.getSelectedServer();
        if (selectedItem != null) {
            this.showAddOrEditDialog(selectedItem);
        }
    }

    public SPServerInfo getSelectedServer() {
        return (SPServerInfo)this.serverInfos.getSelectedValue();
    }

    public void setLoginAction(Action action) {
        this.connectButton.setAction(action);
    }
}

