/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.OfflineController;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named
public class DefaultOfflineController
implements OfflineController {
    static final String CONFIG_PROP_OFFLINE_PROTOCOLS = "aether.offline.protocols";
    static final String CONFIG_PROP_OFFLINE_HOSTS = "aether.offline.hosts";
    private static final Pattern SEP = Pattern.compile("\\s*,\\s*");

    @Override
    public void checkOffline(RepositorySystemSession session2, RemoteRepository repository) throws RepositoryOfflineException {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        if (this.isOfflineProtocol(session2, repository) || this.isOfflineHost(session2, repository)) {
            return;
        }
        throw new RepositoryOfflineException(repository);
    }

    private boolean isOfflineProtocol(RepositorySystemSession session2, RemoteRepository repository) {
        String protocol2;
        String[] protocols2 = this.getConfig(session2, CONFIG_PROP_OFFLINE_PROTOCOLS);
        if (protocols2 != null && (protocol2 = repository.getProtocol()).length() > 0) {
            for (String p : protocols2) {
                if (!p.equalsIgnoreCase(protocol2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOfflineHost(RepositorySystemSession session2, RemoteRepository repository) {
        String host;
        String[] hosts = this.getConfig(session2, CONFIG_PROP_OFFLINE_HOSTS);
        if (hosts != null && (host = repository.getHost()).length() > 0) {
            for (String h2 : hosts) {
                if (!h2.equalsIgnoreCase(host)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getConfig(RepositorySystemSession session2, String key2) {
        String value = ConfigUtils.getString(session2, "", key2).trim();
        if (value.isEmpty()) {
            return null;
        }
        return SEP.split(value);
    }
}

