/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.reflect.validation.AbstractValidationProblemBuilder;
import org.gradle.internal.reflect.validation.TypeProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemLocation;
import org.gradle.plugin.use.PluginId;

public class DefaultTypeValidationProblemBuilder
extends AbstractValidationProblemBuilder<TypeProblemBuilder>
implements TypeProblemBuilder {
    private Class<?> type;

    public DefaultTypeValidationProblemBuilder(DocumentationRegistry documentationRegistry, PluginId pluginId) {
        super(documentationRegistry, pluginId);
    }

    @Override
    public TypeProblemBuilder forType(Class<?> type) {
        this.type = type;
        return this;
    }

    @Override
    public TypeValidationProblem build() {
        if (this.problemId == null) {
            throw new IllegalStateException("You must set the problem id");
        }
        if (this.type == null) {
            throw new IllegalStateException("The type on which the problem should be reported hasn't been set");
        }
        if (this.shortProblemDescription == null) {
            throw new IllegalStateException("You must provide at least a short description of the problem");
        }
        if (this.userManualReference == null) {
            throw new IllegalStateException("You must provide a user manual reference");
        }
        return new TypeValidationProblem(this.problemId, this.severity, this.typeIrrelevantInErrorMessage ? TypeValidationProblemLocation.irrelevant() : TypeValidationProblemLocation.inType(this.type, this.pluginId), this.shortProblemDescription, this.longDescription, this.reason, this.userManualReference, this.possibleSolutions);
    }
}

