/*
 * Decompiled with CFR 0.152.
 */
package com.michaelbaranov.microba.marker.ui;

import com.michaelbaranov.microba.common.BoundedTableModel;
import com.michaelbaranov.microba.marker.MarkerBar;
import com.michaelbaranov.microba.marker.MarkerMutationModel;
import com.michaelbaranov.microba.marker.ui.basic.BasicMarkerBarUI;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class MarkerBarListener
implements TableModelListener,
MouseListener,
MouseMotionListener,
FocusListener,
PropertyChangeListener,
ComponentListener,
ListSelectionListener {
    private static final String VK_DELETE_KEY = "##VK_DELETE##";
    private static final KeyStroke DELETE_KEYSTROKE = KeyStroke.getKeyStroke(127, 0);
    private final BasicMarkerBarUI barUI;
    private MarkerBar bar;
    private int holdingIndex = -1;
    private int holdingShift;

    public MarkerBarListener(BasicMarkerBarUI barUI, MarkerBar markerBar) {
        this.barUI = barUI;
        this.bar = markerBar;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.bar.isEnabled()) {
            return;
        }
        this.barUI.calculateViewRectAndBaseline(this.bar);
        this.bar.requestFocusInWindow();
        BoundedTableModel dataModel = this.bar.getDataModel();
        ListSelectionModel selectionModel = this.bar.getSelectionModel();
        int dataColumn = this.bar.getPositionColumn();
        if (SwingUtilities.isLeftMouseButton(e) && selectionModel != null && dataModel != null) {
            this.handleLMBDown(e, dataModel, selectionModel, dataColumn);
        }
        if (SwingUtilities.isRightMouseButton(e) && dataModel != null) {
            this.handleRMBDown(e, dataModel);
        }
    }

    private void handleRMBDown(MouseEvent e, BoundedTableModel dataModel) {
        MarkerMutationModel mutationModel;
        int logicalOffset = this.bar.getOrientation() == 0 ? this.barUI.componentOffsetToLogicalOffset(e.getX(), dataModel) : this.barUI.componentOffsetToLogicalOffset(e.getY(), dataModel);
        int logicalPos = dataModel.getLowerBound() + logicalOffset;
        if (logicalPos >= dataModel.getLowerBound() && logicalPos <= dataModel.getUpperBound() && (mutationModel = this.bar.getMutationModel()) != null) {
            mutationModel.addMarkAtPosition(logicalPos);
        }
    }

    private void handleLMBDown(MouseEvent e, BoundedTableModel dataModel, ListSelectionModel selectionModel, int dataColumn) {
        Polygon p;
        int i;
        int numAreas = dataModel.getRowCount();
        Polygon[] areas = this.barUI.calculateMarkerAreas(this.bar);
        for (i = 0; i < numAreas; ++i) {
            p = areas[i];
            if (!p.contains(e.getPoint()) || !selectionModel.isSelectedIndex(i) || !dataModel.isCellEditable(i, dataColumn)) continue;
            this.holdingIndex = i;
            return;
        }
        for (i = 0; i < numAreas; ++i) {
            p = areas[i];
            if (!p.contains(e.getPoint()) || !dataModel.isCellEditable(i, dataColumn)) continue;
            selectionModel.setSelectionInterval(i, i);
            this.holdingIndex = i;
            this.holdingShift = this.bar.getOrientation() == 0 ? e.getX() - p.xpoints[0] : e.getY() - p.ypoints[0];
            return;
        }
        for (i = 0; i < numAreas; ++i) {
            p = areas[i];
            if (!p.contains(e.getPoint())) continue;
            selectionModel.setSelectionInterval(i, i);
            this.holdingIndex = -1;
            return;
        }
        selectionModel.clearSelection();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.holdingIndex = -1;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!this.bar.isEnabled()) {
            return;
        }
        BoundedTableModel dataModel = this.bar.getDataModel();
        if (this.holdingIndex >= 0 && dataModel != null) {
            int componentOffset = this.bar.getOrientation() == 0 ? e.getX() - this.holdingShift : e.getY() - this.holdingShift;
            int logicalOffset = this.barUI.componentOffsetToLogicalOffset(componentOffset, dataModel);
            int logicalPos = dataModel.getLowerBound() + logicalOffset;
            if (logicalPos < dataModel.getLowerBound()) {
                logicalPos = dataModel.getLowerBound();
            }
            if (logicalPos > dataModel.getUpperBound()) {
                logicalPos = dataModel.getUpperBound();
            }
            dataModel.setValueAt(new Integer(logicalPos), this.holdingIndex, this.bar.getPositionColumn());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.bar.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.bar.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof MarkerBar) {
            Object newModel;
            Object oldModel;
            if ("dataModel".equals(evt.getPropertyName())) {
                oldModel = (BoundedTableModel)evt.getOldValue();
                newModel = (BoundedTableModel)evt.getNewValue();
                if (oldModel != null) {
                    oldModel.removeTableModelListener(this);
                }
                if (newModel != null) {
                    newModel.addTableModelListener(this);
                }
                this.holdingIndex = -1;
                this.bar.revalidate();
            }
            if ("selectionModel".equals(evt.getPropertyName())) {
                oldModel = (ListSelectionModel)evt.getOldValue();
                newModel = (ListSelectionModel)evt.getNewValue();
                if (oldModel != null) {
                    oldModel.removeListSelectionListener(this);
                }
                if (newModel != null) {
                    newModel.addListSelectionListener(this);
                }
                this.holdingIndex = -1;
                this.bar.repaint();
            }
            if ("mutationModel".equals(evt.getPropertyName())) {
                // empty if block
            }
            if ("orientation".equals(evt.getPropertyName())) {
                this.holdingIndex = -1;
                this.bar.revalidate();
            }
            if ("positionColumn".equals(evt.getPropertyName())) {
                this.holdingIndex = -1;
                this.bar.repaint();
            }
            if ("enabled".equals(evt.getPropertyName())) {
                this.holdingIndex = -1;
                this.bar.repaint();
            }
        }
        if (evt.getSource() instanceof BoundedTableModel) {
            this.bar.revalidate();
        }
    }

    public void installKeyboardActions(JComponent c) {
        c.getInputMap().put(DELETE_KEYSTROKE, VK_DELETE_KEY);
        c.getActionMap().put(VK_DELETE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selected;
                BoundedTableModel dataModel = MarkerBarListener.this.bar.getDataModel();
                ListSelectionModel selectionModel = MarkerBarListener.this.bar.getSelectionModel();
                MarkerMutationModel mutationModel = MarkerBarListener.this.bar.getMutationModel();
                if (selectionModel != null && dataModel != null && mutationModel != null && !selectionModel.isSelectionEmpty() && dataModel.isCellEditable(selected = selectionModel.getLeadSelectionIndex(), MarkerBarListener.this.bar.getPositionColumn())) {
                    mutationModel.removeMarkerAtIndex(selected);
                }
            }
        });
    }

    public void uninstallKeyboardActions(JComponent c) {
        c.getActionMap().remove(VK_DELETE_KEY);
        c.getInputMap().remove(DELETE_KEYSTROKE);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.bar.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.bar.repaint();
    }
}

