/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.ListBlock;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphContainer;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.ast.BlankLineContainer;
import com.vladsch.flexmark.util.ast.Block;
import com.vladsch.flexmark.util.ast.BlockContent;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ListItem
extends Block
implements ParagraphItemContainer,
BlankLineContainer,
ParagraphContainer {
    protected BasedSequence openingMarker = BasedSequence.NULL;
    protected BasedSequence markerSuffix = BasedSequence.NULL;
    private boolean tight = true;
    private boolean hadBlankAfterItemParagraph = false;
    private boolean containsBlankLine = false;
    private int priority = Integer.MIN_VALUE;

    public ListItem() {
    }

    public ListItem(ListItem other) {
        this.openingMarker = other.openingMarker;
        this.markerSuffix = other.markerSuffix;
        this.tight = other.tight;
        this.hadBlankAfterItemParagraph = other.hadBlankAfterItemParagraph;
        this.containsBlankLine = other.containsBlankLine;
        this.priority = other.priority;
        this.takeChildren(other);
        this.setCharsFromContent();
    }

    public ListItem(BasedSequence chars) {
        super(chars);
    }

    public ListItem(BasedSequence chars, List<BasedSequence> segments) {
        super(chars, segments);
    }

    public ListItem(BlockContent blockContent) {
        super(blockContent);
    }

    public boolean isOrderedItem() {
        return false;
    }

    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        ListItem.segmentSpanChars(out, this.openingMarker, "open");
        ListItem.segmentSpanChars(out, this.markerSuffix, "openSuffix");
        if (this.isTight()) {
            out.append(" isTight");
        } else {
            out.append(" isLoose");
        }
        if (this.isHadBlankAfterItemParagraph()) {
            out.append(" hadBlankLineAfter");
        } else if (this.isContainsBlankLine()) {
            out.append(" hadBlankLine");
        }
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return new BasedSequence[]{this.openingMarker, this.markerSuffix};
    }

    public boolean canChangeMarker() {
        return true;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public BasedSequence getOpeningMarker() {
        return this.openingMarker;
    }

    public void setOpeningMarker(BasedSequence openingMarker) {
        this.openingMarker = openingMarker;
    }

    public BasedSequence getMarkerSuffix() {
        return this.markerSuffix;
    }

    public void setMarkerSuffix(BasedSequence markerSuffix) {
        assert (markerSuffix.isNull() || this.openingMarker.getBase() == markerSuffix.getBase());
        this.markerSuffix = markerSuffix;
    }

    public void setTight(boolean tight) {
        this.tight = tight;
    }

    public void setLoose(boolean loose2) {
        this.tight = !loose2;
    }

    public boolean isTight() {
        return this.tight && this.isInTightList();
    }

    public boolean isOwnTight() {
        return this.tight;
    }

    public boolean isLoose() {
        return !this.isTight();
    }

    @Override
    public boolean isParagraphEndWrappingDisabled(Paragraph node) {
        return this.getFirstChild() != node && this.getLastChild() == node || this.getFirstChild() == node && (this.getParent() == null || this.getParent().getLastChildAny(ListItem.class) == this);
    }

    @Override
    public boolean isParagraphStartWrappingDisabled(Paragraph node) {
        return this.isItemParagraph(node);
    }

    @Override
    public boolean isParagraphInTightListItem(Paragraph node) {
        if (!this.isTight()) {
            return false;
        }
        return this.isItemParagraph(node);
    }

    @Override
    public boolean isItemParagraph(Paragraph node) {
        Node child;
        for (child = this.getFirstChild(); child != null && !(child instanceof Paragraph); child = child.getNext()) {
        }
        return child == node;
    }

    @Override
    public boolean isParagraphWrappingDisabled(Paragraph node, ListOptions listOptions, DataHolder options) {
        assert (node.getParent() == this);
        return listOptions.isInTightListItem(node);
    }

    public boolean isInTightList() {
        return !(this.getParent() instanceof ListBlock) || ((ListBlock)this.getParent()).isTight();
    }

    public boolean isHadBlankAfterItemParagraph() {
        return this.hadBlankAfterItemParagraph;
    }

    public boolean isContainsBlankLine() {
        return this.containsBlankLine;
    }

    public void setContainsBlankLine(boolean containsBlankLine) {
        this.containsBlankLine = containsBlankLine;
    }

    public void setHadBlankAfterItemParagraph(boolean hadBlankAfterItemParagraph) {
        this.hadBlankAfterItemParagraph = hadBlankAfterItemParagraph;
    }

    @Override
    public Node getLastBlankLineChild() {
        return this.getLastChild();
    }
}

