/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.IntData;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.RemoveListRange;
import org.jetbrains.jetCheck.ShrinkStep;
import org.jetbrains.jetCheck.StructureElement;
import org.jetbrains.jetCheck.StructureKind;

class StructureNode
extends StructureElement {
    final List<StructureElement> children;
    @NotNull
    StructureKind kind = StructureKind.GENERIC;
    boolean shrinkProhibited;

    StructureNode(NodeId id) {
        this(id, new ArrayList<StructureElement>());
    }

    StructureNode(NodeId id, List<StructureElement> children) {
        super(id);
        this.children = children;
    }

    StructureNode copyWithChildren(List<StructureElement> children) {
        StructureNode node = new StructureNode(this.id, children);
        node.kind = this.kind;
        node.shrinkProhibited = this.shrinkProhibited;
        return node;
    }

    Iterator<StructureElement> childrenIterator() {
        return this.children.iterator();
    }

    void addChild(StructureElement child) {
        this.children.add(child);
    }

    StructureNode subStructure(@NotNull Generator<?> generator) {
        StructureNode e = new StructureNode(this.id.childId(generator));
        this.addChild(e);
        return e;
    }

    void removeLastChild(StructureNode node) {
        if (this.children.isEmpty() || this.children.get(this.children.size() - 1) != node) {
            throw new IllegalStateException("Last sub-structure changed");
        }
        this.children.remove(this.children.size() - 1);
    }

    @Override
    @Nullable
    ShrinkStep shrink() {
        if (this.shrinkProhibited) {
            return null;
        }
        return this.kind == StructureKind.LIST && this.children.size() > 1 ? RemoveListRange.fromEnd(this) : this.shrinkChild(this.children.size() - 1);
    }

    @Nullable
    ShrinkStep shrinkChild(int index) {
        int minIndex;
        int n = minIndex = this.kind == StructureKind.GENERIC ? 0 : 1;
        while (index >= minIndex) {
            ShrinkStep childShrink = this.children.get(index).shrink();
            if (childShrink != null) {
                return this.wrapChildShrink(index, childShrink);
            }
            --index;
        }
        return this.shrinkRecursion();
    }

    @Nullable
    private ShrinkStep wrapChildShrink(final int index, final @Nullable ShrinkStep step) {
        if (step == null) {
            return this.shrinkChild(index - 1);
        }
        final NodeId oldChild = this.children.get((int)index).id;
        return new ShrinkStep(){

            @Override
            List<?> getEqualityObjects() {
                return Collections.singletonList(step);
            }

            @Override
            @Nullable
            StructureNode apply(StructureNode root) {
                return step.apply(root);
            }

            @Override
            ShrinkStep onSuccess(StructureNode smallerRoot) {
                StructureNode inheritor = (StructureNode)Objects.requireNonNull(smallerRoot.findChildById(StructureNode.this.id));
                int nextIndex = Math.min(index, inheritor.children.size() - 1);
                if (inheritor.children.get((int)nextIndex).id != oldChild) {
                    return inheritor.shrink();
                }
                return inheritor.wrapChildShrink(nextIndex, step.onSuccess(smallerRoot));
            }

            @Override
            ShrinkStep onFailure() {
                return StructureNode.this.wrapChildShrink(index, step.onFailure());
            }

            public String toString() {
                return "-" + step.toString();
            }
        };
    }

    boolean isIncompleteList() {
        return ((IntData)this.children.get((int)0)).value > this.children.size() - 1;
    }

    private void findChildrenWithGenerator(int generatorHash, List<StructureNode> result2) {
        for (StructureElement child : this.children) {
            if (!(child instanceof StructureNode)) continue;
            Integer childGen = child.id.generatorHash;
            if (childGen != null && generatorHash == childGen) {
                result2.add((StructureNode)child);
                continue;
            }
            ((StructureNode)child).findChildrenWithGenerator(generatorHash, result2);
        }
    }

    @Nullable
    private ShrinkStep shrinkRecursion() {
        if (this.id.generatorHash != null) {
            ArrayList<StructureNode> sameGeneratorChildren = new ArrayList<StructureNode>();
            this.findChildrenWithGenerator(this.id.generatorHash, sameGeneratorChildren);
            return this.tryReplacing(sameGeneratorChildren, 0);
        }
        return null;
    }

    @Nullable
    private ShrinkStep tryReplacing(List<StructureNode> candidates, int index) {
        if (index < candidates.size()) {
            StructureNode replacement = candidates.get(index);
            return ShrinkStep.create(this.id, replacement, __ -> replacement.shrink(), () -> this.tryReplacing(candidates, index + 1));
        }
        return null;
    }

    @Override
    @NotNull
    StructureNode replace(NodeId id, StructureElement replacement) {
        StructureElement newChild;
        if (id == this.id) {
            return (StructureNode)replacement;
        }
        if (this.children.isEmpty()) {
            return this;
        }
        int index = this.indexOfChildContaining(id);
        StructureElement oldChild = this.children.get(index);
        if (oldChild == (newChild = oldChild.replace(id, replacement))) {
            return this;
        }
        ArrayList<StructureElement> newChildren = new ArrayList<StructureElement>(this.children);
        newChildren.set(index, newChild);
        return this.copyWithChildren(newChildren);
    }

    @Override
    @Nullable
    StructureElement findChildById(NodeId id) {
        if (id == this.id) {
            return this;
        }
        int index = this.indexOfChildContaining(id);
        return index < 0 ? null : this.children.get(index).findChildById(id);
    }

    @Override
    void serialize(ByteArrayOutputStream out) {
        for (StructureElement child : this.children) {
            child.serialize(out);
        }
    }

    private int indexOfChildContaining(NodeId id) {
        int i;
        for (i = 0; i < this.children.size() && this.children.get((int)i).id.number <= id.number; ++i) {
        }
        return i - 1;
    }

    @Override
    StructureNode removeUnneeded(Set<NodeId> unneeded) {
        ArrayList<StructureElement> replaced = new ArrayList<StructureElement>(this.children.size());
        boolean changed = false;
        for (StructureElement child : this.children) {
            if (unneeded.contains(child.id)) {
                return this.copyWithChildren(replaced);
            }
            StructureElement removed = child.removeUnneeded(unneeded);
            if (removed != child) {
                changed = true;
            }
            replaced.add(removed);
        }
        return changed ? this.copyWithChildren(replaced) : this;
    }

    public boolean equals(Object obj) {
        return obj instanceof StructureNode && this.children.equals(((StructureNode)obj).children);
    }

    public int hashCode() {
        return this.children.hashCode();
    }

    public String toString() {
        String inner = this.children.stream().map(Object::toString).collect(Collectors.joining(", "));
        switch (this.kind) {
            case LIST: {
                return "[" + inner + "]";
            }
            case CHOICE: {
                return "?(" + inner + ")";
            }
        }
        return "(" + inner + ")";
    }
}

