/*
 * Decompiled with CFR 0.152.
 */
package training.actions;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.actions.IftDumpMode;
import training.actions.TextCollector;
import training.dsl.LessonContext;
import training.dsl.TaskContext;
import training.dsl.impl.LessonExecutorUtil;
import training.dsl.impl.TaskProperties;
import training.learn.course.KLesson;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ!\u0010\u0010\u001a\u00020\u00112\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\b\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltraining/actions/ApplyTaskLessonContext;", "Ltraining/dsl/LessonContext;", "buffer", "Ljava/lang/StringBuffer;", "project", "Lcom/intellij/openapi/project/Project;", "mode", "Ltraining/actions/IftDumpMode;", "lesson", "Ltraining/learn/course/KLesson;", "(Ljava/lang/StringBuffer;Lcom/intellij/openapi/project/Project;Ltraining/actions/IftDumpMode;Ltraining/learn/course/KLesson;)V", "internalTaskNumber", "", "getLesson$intellij_featuresTrainer", "()Ltraining/learn/course/KLesson;", "taskVisualIndex", "task", "", "taskContent", "Lkotlin/Function1;", "Ltraining/dsl/TaskContext;", "Lkotlin/ExtensionFunctionType;", "intellij.featuresTrainer"})
final class ApplyTaskLessonContext
extends LessonContext {
    @NotNull
    private final StringBuffer buffer;
    @NotNull
    private final Project project;
    @NotNull
    private final IftDumpMode mode;
    @NotNull
    private final KLesson lesson;
    private int internalTaskNumber;
    private int taskVisualIndex;

    public ApplyTaskLessonContext(@NotNull StringBuffer buffer, @NotNull Project project, @NotNull IftDumpMode mode, @NotNull KLesson lesson) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)lesson, (String)"lesson");
        this.buffer = buffer;
        this.project = project;
        this.mode = mode;
        this.lesson = lesson;
        this.taskVisualIndex = 1;
    }

    @Override
    @NotNull
    public KLesson getLesson$intellij_featuresTrainer() {
        return this.lesson;
    }

    @Override
    public void task(@NotNull Function1<? super TaskContext, Unit> taskContent) {
        int n;
        TaskProperties taskProperties;
        Intrinsics.checkNotNullParameter(taskContent, (String)"taskContent");
        this.buffer.append("(" + this.internalTaskNumber + " -> " + this.taskVisualIndex + ") ");
        if (this.mode == IftDumpMode.TEXT_ONLY) {
            TaskContext taskContext = new TextCollector(this.buffer, this.project);
            taskContent.invoke((Object)taskContext);
        }
        if (this.mode == IftDumpMode.CODE_POSITIONS) {
            this.buffer.append(LessonExecutorUtil.INSTANCE.getTaskCallInfo());
            this.buffer.append('\n');
        }
        if ((taskProperties = LessonExecutorUtil.INSTANCE.taskProperties(taskContent, this.project)).getHasDetection() && taskProperties.getMessagesNumber() > 0) {
            n = this.taskVisualIndex;
            this.taskVisualIndex = n + 1;
        }
        n = this.internalTaskNumber;
        this.internalTaskNumber = n + 1;
    }
}

