/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.FileEncodingProvider;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.EditorConfigEncodingCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/editorconfig/configmanagement/ConfigEncodingManager;", "Lcom/intellij/openapi/vfs/encoding/FileEncodingProvider;", "()V", "getEncoding", "Ljava/nio/charset/Charset;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.editorconfig"})
public final class ConfigEncodingManager
implements FileEncodingProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String charsetKey = "charset";
    @NotNull
    public static final String UTF8_BOM_ENCODING = "utf-8-bom";
    @NotNull
    private static final String UTF8_ENCODING = "utf-8";
    @NotNull
    private static final Map<String, Charset> encodingMap;

    @Nullable
    public Charset getEncoding(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Project project = ProjectLocator.Companion.getInstance().guessProjectForFile(virtualFile);
        return project != null && Utils.INSTANCE.isEnabledFor(project, virtualFile) ? EditorConfigEncodingCache.Companion.getInstance().getCachedEncoding(virtualFile) : null;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"latin1", (Object)StandardCharsets.ISO_8859_1), TuplesKt.to((Object)UTF8_ENCODING, (Object)StandardCharsets.UTF_8), TuplesKt.to((Object)UTF8_BOM_ENCODING, (Object)StandardCharsets.UTF_8), TuplesKt.to((Object)"utf-16be", (Object)StandardCharsets.UTF_16BE), TuplesKt.to((Object)"utf-16le", (Object)StandardCharsets.UTF_16LE)};
        encodingMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/configmanagement/ConfigEncodingManager$Companion;", "", "()V", "UTF8_BOM_ENCODING", "", "UTF8_ENCODING", "charsetKey", "encodingMap", "", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "toCharset", "str", "toString", "charset", "useBom", "", "intellij.editorconfig"})
    @SourceDebugExtension(value={"SMAP\nConfigEncodingManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigEncodingManager.kt\norg/editorconfig/configmanagement/ConfigEncodingManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String toString(@NotNull Charset charset, boolean useBom) {
            String string;
            Intrinsics.checkNotNullParameter((Object)charset, (String)ConfigEncodingManager.charsetKey);
            if (charset == StandardCharsets.UTF_8) {
                string = useBom ? ConfigEncodingManager.UTF8_BOM_ENCODING : ConfigEncodingManager.UTF8_ENCODING;
            } else {
                Object v1;
                block3: {
                    Iterable iterable = encodingMap.entrySet();
                    for (Object t : iterable) {
                        Map.Entry entry = (Map.Entry)t;
                        boolean bl = false;
                        Charset v = (Charset)entry.getValue();
                        if (!Intrinsics.areEqual((Object)v, (Object)charset)) continue;
                        v1 = t;
                        break block3;
                    }
                    v1 = null;
                }
                Map.Entry entry = v1;
                string = entry != null ? (String)entry.getKey() : null;
            }
            return string;
        }

        @Nullable
        public final Charset toCharset(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            return (Charset)encodingMap.get(str);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

