/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.codeinsight.inspections.EditorConfigUnexpectedCommaInspection;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigOptionValueList;
import org.editorconfig.language.psi.interfaces.EditorConfigDescribableElement;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\f0\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigCleanupValueListQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
@SourceDebugExtension(value={"SMAP\nEditorConfigCleanupValueListQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigCleanupValueListQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigCleanupValueListQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n1855#2,2:34\n*S KotlinDebug\n*F\n+ 1 EditorConfigCleanupValueListQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigCleanupValueListQuickFix\n*L\n22#1:34,2\n*E\n"})
public final class EditorConfigCleanupValueListQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.values.list.cleanup.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
        EditorConfigOptionValueList editorConfigOptionValueList = psiElement2 instanceof EditorConfigOptionValueList ? (EditorConfigOptionValueList)psiElement2 : null;
        if (editorConfigOptionValueList == null) {
            return;
        }
        EditorConfigOptionValueList list = editorConfigOptionValueList;
        List<PsiElement> badCommas = EditorConfigUnexpectedCommaInspection.Companion.findBadCommas(list);
        CodeStyleManager manager = CodeStyleManager.getInstance((Project)project);
        manager.performActionWithFormatterDisabled(() -> EditorConfigCleanupValueListQuickFix.applyFix$lambda$0(badCommas));
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        String string = list.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"list.text");
        EditorConfigDescribableElement newValue = factory.createAnyValue(string);
        manager.reformat((PsiElement)newValue, true);
        manager.performActionWithFormatterDisabled(() -> EditorConfigCleanupValueListQuickFix.applyFix$lambda$1(list, newValue));
    }

    private static final void applyFix$lambda$0(List $badCommas) {
        Intrinsics.checkNotNullParameter((Object)$badCommas, (String)"$badCommas");
        Iterable $this$forEach$iv = $badCommas;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement p0 = (PsiElement)element$iv;
            boolean bl = false;
            p0.delete();
        }
    }

    private static final void applyFix$lambda$1(EditorConfigOptionValueList $list, EditorConfigDescribableElement $newValue) {
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        Intrinsics.checkNotNullParameter((Object)$newValue, (String)"$newValue");
        $list.replace($newValue);
    }
}

