/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.codeinsight.inspections.EditorConfigHeaderUniquenessInspection;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.language.psi.EditorConfigHeader;
import org.editorconfig.language.psi.EditorConfigSection;
import org.editorconfig.language.services.EditorConfigElementFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0012\u0010\u000e\u001a\f0\n\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigMergeSectionsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createReplacementText", "", "source", "Lorg/editorconfig/language/psi/EditorConfigSection;", "destination", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "intellij.editorconfig"})
public final class EditorConfigMergeSectionsQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.section.merge-duplicate.description");
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement = descriptor2.getPsiElement();
        EditorConfigHeader editorConfigHeader = psiElement instanceof EditorConfigHeader ? (EditorConfigHeader)psiElement : null;
        if (editorConfigHeader == null) {
            return;
        }
        EditorConfigHeader header = editorConfigHeader;
        EditorConfigSection editorConfigSection = EditorConfigHeaderUniquenessInspection.Companion.findDuplicateSection(header.getSection());
        if (editorConfigSection == null) {
            return;
        }
        EditorConfigSection duplicateSection = editorConfigSection;
        EditorConfigElementFactory elementFactory = EditorConfigElementFactory.Companion.getInstance(project);
        String replacementText = this.createReplacementText(header.getSection(), duplicateSection);
        EditorConfigSection replacement = elementFactory.createSection(replacementText);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if (codeStyleManager == null) {
            return;
        }
        CodeStyleManager manager = codeStyleManager;
        manager.performActionWithFormatterDisabled(() -> EditorConfigMergeSectionsQuickFix.applyFix$lambda$0(duplicateSection, replacement, header));
    }

    private final String createReplacementText(EditorConfigSection source, EditorConfigSection destination) {
        StringBuilder result2 = new StringBuilder(destination.getTextLength() + source.getTextLength());
        result2.append(destination.getText());
        PsiElement[] psiElementArray = source.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"source.children");
        for (PsiElement child : psiElementArray) {
            if (child instanceof EditorConfigHeader) continue;
            result2.append('\n');
            result2.append(child.getText());
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private static final void applyFix$lambda$0(EditorConfigSection $duplicateSection, EditorConfigSection $replacement, EditorConfigHeader $header) {
        Intrinsics.checkNotNullParameter((Object)$duplicateSection, (String)"$duplicateSection");
        Intrinsics.checkNotNullParameter((Object)$replacement, (String)"$replacement");
        Intrinsics.checkNotNullParameter((Object)$header, (String)"$header");
        $duplicateSection.replace((PsiElement)$replacement);
        $header.getSection().delete();
    }
}

