/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.config;

import com.intellij.util.ArrayUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.utils.MavenLog;

public final class MavenConfigParser {
    private MavenConfigParser() {
    }

    @Nullable
    public static MavenConfig parse(@NotNull String baseDir) {
        if (baseDir == null) {
            MavenConfigParser.$$$reportNull$$$0(0);
        }
        Options options = new Options();
        for (MavenConfigSettings value : MavenConfigSettings.values()) {
            options.addOption(value.toOption());
        }
        File configFile = new File(baseDir, "/.mvn/maven.config");
        ArrayList<String> configArgs = new ArrayList<String>();
        try {
            if (configFile.isFile()) {
                for (String arg : Files.readString(configFile.toPath(), Charset.defaultCharset()).split("\\s+")) {
                    if (arg.isEmpty()) continue;
                    configArgs.add(arg);
                }
                String[] cleanArgs = CleanArgument.cleanArgs(ArrayUtil.toStringArray(configArgs));
                GnuParser parser = new GnuParser();
                CommandLine parse = parser.parse(options, cleanArgs, true);
                return new MavenConfig(Arrays.stream(parse.getOptions()).collect(Collectors.toMap(o -> o.getOpt(), Function.identity())), baseDir);
            }
        }
        catch (Exception e) {
            MavenLog.LOG.error("error read maven config " + configFile.getAbsolutePath(), (Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "org/jetbrains/idea/maven/config/MavenConfigParser", "parse"));
    }

    public static final class CleanArgument {
        public static String[] cleanArgs(String[] args) {
            int cleanedSz;
            ArrayList<String> cleaned = new ArrayList<String>();
            StringBuilder currentArg = null;
            for (String arg : args) {
                boolean addedToBuffer = false;
                if (arg.startsWith("\"")) {
                    if (currentArg != null) {
                        cleaned.add(currentArg.toString());
                    }
                    currentArg = new StringBuilder(arg.substring(1));
                    addedToBuffer = true;
                }
                if (addedToBuffer && arg.endsWith("\"")) {
                    currentArg.setLength(currentArg.length() - 1);
                    cleaned.add(currentArg.toString());
                    currentArg = null;
                    continue;
                }
                if (addedToBuffer) continue;
                if (currentArg != null) {
                    currentArg.append(' ').append(arg);
                    continue;
                }
                cleaned.add(arg);
            }
            if (currentArg != null) {
                cleaned.add(currentArg.toString());
            }
            String[] cleanArgs = (cleanedSz = cleaned.size()) == 0 ? args : ArrayUtil.toStringArray(cleaned);
            return cleanArgs;
        }
    }
}

