/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.dom.converters.MavenDependencyCompletionUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomShortArtifactCoordinates;
import org.jetbrains.idea.maven.dom.model.completion.MavenAbstractPluginExtensionCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.MavenCoordinateCompletionContributor;
import org.jetbrains.idea.maven.dom.model.completion.MavenVersionNegatingWeigher;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.reposearch.DependencySearchService;
import org.jetbrains.idea.reposearch.RepositoryArtifactData;
import org.jetbrains.idea.reposearch.SearchParameters;

public class MavenVersionCompletionContributor
extends MavenCoordinateCompletionContributor {
    public MavenVersionCompletionContributor() {
        super("version");
    }

    @Override
    protected Promise<Integer> find(@NotNull DependencySearchService service, @NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull CompletionParameters parameters, @NotNull Consumer<RepositoryArtifactData> consumer) {
        if (service == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(0);
        }
        if (coordinates == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(3);
        }
        SearchParameters searchParameters = this.createSearchParameters(parameters);
        String groupId = MavenVersionCompletionContributor.trimDummy(coordinates.getGroupId().getStringValue());
        String artifactId = MavenVersionCompletionContributor.trimDummy(coordinates.getArtifactId().getStringValue());
        if (MavenAbstractPluginExtensionCompletionContributor.isPluginOrExtension(coordinates) && StringUtil.isEmpty((String)groupId)) {
            return MavenAbstractPluginExtensionCompletionContributor.findPluginByArtifactId(service, artifactId, searchParameters, new RepositoryArtifactDataConsumer(artifactId, groupId, consumer));
        }
        return service.suggestPrefix(groupId, artifactId, searchParameters, (Consumer)new RepositoryArtifactDataConsumer(artifactId, groupId, consumer));
    }

    @Override
    protected void fillAfter(CompletionResultSet result2) {
        if (MavenServerManager.getInstance().isUseMaven2()) {
            result2.addElement((LookupElement)LookupElementBuilder.create((String)"RELEASE").withStrikeoutness(true));
            result2.addElement((LookupElement)LookupElementBuilder.create((String)"LATEST").withStrikeoutness(true));
        }
    }

    @Override
    protected void fillResult(@NotNull MavenDomShortArtifactCoordinates coordinates, @NotNull CompletionResultSet result2, @NotNull MavenRepositoryArtifactInfo item, @NotNull String completionPrefix) {
        if (coordinates == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(5);
        }
        if (item == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(6);
        }
        if (completionPrefix == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(7);
        }
        result2.addAllElements((Iterable)ContainerUtil.map((Object[])item.getItems(), dci -> {
            LookupElementBuilder lookup = MavenDependencyCompletionUtil.lookupElement(dci, dci.getVersion());
            lookup.putUserData(MAVEN_COORDINATE_COMPLETION_PREFIX_KEY, (Object)completionPrefix);
            return lookup;
        }));
    }

    @Override
    protected boolean validate(String groupId, String artifactId) {
        return !StringUtil.isEmptyOrSpaces((String)artifactId);
    }

    @Override
    @NotNull
    protected CompletionResultSet amendResultSet(@NotNull CompletionResultSet result2) {
        if (result2 == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(8);
        }
        CompletionResultSet completionResultSet = result2.withRelevanceSorter(CompletionService.getCompletionService().emptySorter().weigh((LookupElementWeigher)new MavenVersionNegatingWeigher()));
        if (completionResultSet == null) {
            MavenVersionCompletionContributor.$$$reportNull$$$0(9);
        }
        return completionResultSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coordinates";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionPrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/model/completion/MavenVersionCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/model/completion/MavenVersionCompletionContributor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "amendResultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "amendResultSet";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private static class RepositoryArtifactDataConsumer
    implements Consumer<RepositoryArtifactData> {
        private final String myArtifactId;
        private final String myGroupId;
        @NotNull
        private final Consumer<RepositoryArtifactData> myConsumer;

        public RepositoryArtifactDataConsumer(String artifactId, String groupId, @NotNull Consumer<RepositoryArtifactData> consumer) {
            if (consumer == null) {
                RepositoryArtifactDataConsumer.$$$reportNull$$$0(0);
            }
            this.myArtifactId = artifactId;
            this.myGroupId = groupId;
            this.myConsumer = consumer;
        }

        @Override
        public void accept(RepositoryArtifactData rad) {
            MavenRepositoryArtifactInfo mrai;
            if (rad instanceof MavenRepositoryArtifactInfo && StringUtil.equals((CharSequence)(mrai = (MavenRepositoryArtifactInfo)rad).getArtifactId(), (CharSequence)this.myArtifactId) && (StringUtil.isEmpty((String)this.myGroupId) || StringUtil.equals((CharSequence)mrai.getGroupId(), (CharSequence)this.myGroupId))) {
                this.myConsumer.accept((RepositoryArtifactData)mrai);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/idea/maven/dom/model/completion/MavenVersionCompletionContributor$RepositoryArtifactDataConsumer", "<init>"));
        }
    }
}

